/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.terminal.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.log.vo.OperationType;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.customer.vo.TmCustomerVo;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.terminal.dao.TmTermCustPostDao;
import com.biz.eisp.mdm.terminal.entity.TmRTermCustPosBGEntity;
import com.biz.eisp.mdm.terminal.entity.TmTerminalEntity;
import com.biz.eisp.mdm.terminal.service.TmTermCustPostService;
import com.biz.eisp.mdm.terminal.vo.TmTermCustPostVo;
import com.biz.eisp.mdm.terminal.vo.TmTerminalVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jodd.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmTermCustPostService")
@Transactional
public class TmTermCustPostServiceImpl
extends BaseServiceImpl
implements TmTermCustPostService {
    @Autowired
    private TmTermCustPostDao tmTermCustPostDao;

    @Override
    public List<TmTermCustPostVo> findTmTermCustPostList(TmTermCustPostVo tmTermCustPostVo, Page page) {
        if (page == null) {
            return this.tmTermCustPostDao.findTermCustPostList(tmTermCustPostVo);
        }
        return this.tmTermCustPostDao.findTermListByCustomerId(tmTermCustPostVo, page);
    }

    @Override
    public void deleteTmTermCustPost(TmTermCustPostVo tmTermCustPostVo) {
        if (StringUtil.isEmpty((String)tmTermCustPostVo.getId())) {
            throw new BusinessException("\u5220\u9664\u7ec8\u7aef\u4e0e\u7ecf\u9500\u5546\u5c97\u4f4d\u5bf9\u5e94\u5173\u7cfb\u65f6\uff0c\u4e3b\u952eID\u627e\u4e0d\u5230:" + tmTermCustPostVo.getId());
        }
        TmRTermCustPosBGEntity tmTermCustPostEntity = this.get(TmRTermCustPosBGEntity.class, (Serializable)((Object)tmTermCustPostVo.getId()));
        tmTermCustPostVo.setTerminalCode(tmTermCustPostEntity.getTmTerminal().getTerminalCode());
        tmTermCustPostVo.setCustomerCode(tmTermCustPostEntity.getTmCustomer().getCustomerCode());
        this.delete(tmTermCustPostEntity);
    }

    @Override
    public List<TmTerminalVo> findNotAnyCustTerminalList(TmTermCustPostVo tmTermCustPostVo, Page page) {
        return this.tmTermCustPostDao.findNotAnyCustTerminalList(tmTermCustPostVo, page);
    }

    @Override
    public List<TmTerminalVo> findNotCurrCustTerminalList(TmTermCustPostVo tmTermCustPostVo, Page page) {
        return this.tmTermCustPostDao.findNotCurrCustTerminalList(tmTermCustPostVo, page);
    }

    @Override
    public void addRelotaionForCustomerId(String terminalIds, String customerId) {
        if (StringUtil.isEmpty((String)terminalIds) && StringUtil.isEmpty((String)customerId)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        String[] ids = terminalIds.split(",");
        TmCustomerEntity tmCustomerEntity = this.get(TmCustomerEntity.class, (Serializable)((Object)customerId));
        TmTerminalEntity tmTerminalEntity = null;
        String hql = "from TmRTermCustPosBGEntity where tmTerminal.id=? and tmCustomer.id=?";
        for (String terminalId : ids) {
            tmTerminalEntity = this.get(TmTerminalEntity.class, (Serializable)((Object)terminalId));
            List tmRTermCustPosBGEntities = this.findByHql(hql, terminalId, customerId);
            if (CollectionUtil.listNotEmptyNotSizeZero(tmRTermCustPosBGEntities)) continue;
            TmRTermCustPosBGEntity tmRTermCustPosBGEntity = new TmRTermCustPosBGEntity();
            tmRTermCustPosBGEntity.setTmCustomer(tmCustomerEntity);
            tmRTermCustPosBGEntity.setTmTerminal(tmTerminalEntity);
            this.save(tmRTermCustPosBGEntity);
            String content = "\u4e0a\u7ea7\u5ba2\u6237\u6279\u91cf\u8c03\u6574,\u5173\u8054\u4e0a\u7ea7\u5ba2\u6237:<b>" + tmCustomerEntity.getCustomerName() + "</b>";
            this.addLog(OperationType.INSERT, "\u7ec8\u7aef\u4e0e\u5ba2\u6237\u5bf9\u5e94\u5173\u7cfb", terminalId, content);
        }
    }

    @Override
    public List<TmTermCustPostVo> deleteRelotaionForCustomerId(String ids, Integer flag) {
        if (StringUtil.isEmpty((String)ids)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        String[] idArray = ids.split(",");
        ArrayList<TmTermCustPostVo> result = new ArrayList<TmTermCustPostVo>();
        for (String id : idArray) {
            TmTermCustPostVo termCustPostVo = new TmTermCustPostVo();
            TmRTermCustPosBGEntity tmRTermCustPosBGEntity = this.get(TmRTermCustPosBGEntity.class, (Serializable)((Object)id));
            termCustPostVo.setId(id);
            termCustPostVo.setCustomerCode(tmRTermCustPosBGEntity.getTmCustomer().getCustomerCode());
            termCustPostVo.setTerminalCode(tmRTermCustPosBGEntity.getTmTerminal().getTerminalCode());
            result.add(termCustPostVo);
            String content = "";
            if (flag != null && flag == 1) {
                content = "\u7ec8\u7aef\u4e0a\u7ea7\u5ba2\u6237\u6279\u91cf\u8c03\u6574,\u53d6\u6d88\u5173\u8054\u4e0a\u7ea7\u5ba2\u6237:<b>" + tmRTermCustPosBGEntity.getTmCustomer().getCustomerName() + "</b>";
                if (tmRTermCustPosBGEntity.getTmPosition() == null) {
                    this.delete(tmRTermCustPosBGEntity);
                } else {
                    tmRTermCustPosBGEntity.setTmCustomer(null);
                    this.updateEntity(tmRTermCustPosBGEntity);
                }
            } else {
                content = "\u7ec8\u7aef\u5bf9\u63a5\u4eba\u804c\u4f4d\u6279\u91cf\u8c03\u6574,\u53d6\u6d88\u5173\u8054\u5bf9\u63a5\u4eba\u804c\u4f4d:<b>" + tmRTermCustPosBGEntity.getTmPosition().getPositionName() + "</b>";
                if (tmRTermCustPosBGEntity.getTmCustomer() == null) {
                    this.delete(tmRTermCustPosBGEntity);
                } else {
                    tmRTermCustPosBGEntity.setTmPosition(null);
                    this.updateEntity(tmRTermCustPosBGEntity);
                }
            }
            this.addLog(OperationType.DELETE, "\u7ec8\u7aef\u4e0e\u5ba2\u6237\u5bf9\u5e94\u5173\u7cfb", tmRTermCustPosBGEntity.getTmTerminal().getId(), content);
        }
        return result;
    }

    @Override
    public List<TmTermCustPostVo> deleteTmRCustTermPost(String ids) {
        String[] idArray;
        if (StringUtil.isEmpty((String)ids) && StringUtil.isEmpty((String)ids)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        ArrayList<TmTermCustPostVo> result = new ArrayList<TmTermCustPostVo>();
        for (String id : idArray = ids.split(",")) {
            TmRTermCustPosBGEntity tmRTermCustPosBGEntity = this.get(TmRTermCustPosBGEntity.class, (Serializable)((Object)id));
            TmTermCustPostVo termCustPostVo = new TmTermCustPostVo();
            termCustPostVo.setId(tmRTermCustPosBGEntity.getId());
            termCustPostVo.setTerminalCode(tmRTermCustPosBGEntity.getTmTerminal().getTerminalCode());
            termCustPostVo.setCustomerCode(tmRTermCustPosBGEntity.getTmCustomer().getCustomerCode());
            result.add(termCustPostVo);
            this.delete(tmRTermCustPosBGEntity);
        }
        return result;
    }

    @Override
    public List<TmTermCustPostVo> updateCustTerminalRelation(String relationIds, String customerId) {
        if (StringUtil.isEmpty((String)relationIds) && StringUtil.isEmpty((String)customerId)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        String[] ids = relationIds.split(",");
        String hql = "from TmRTermCustPosBGEntity where tmTerminal.id=? and tmCustomer.id=?";
        TmCustomerEntity tmCustomerEntity = this.get(TmCustomerEntity.class, (Serializable)((Object)customerId));
        TmRTermCustPosBGEntity tmRTermCustPosBGEntity = null;
        ArrayList<TmTermCustPostVo> result = new ArrayList<TmTermCustPostVo>();
        for (String id : ids) {
            tmRTermCustPosBGEntity = this.get(TmRTermCustPosBGEntity.class, (Serializable)((Object)id));
            TmTermCustPostVo termCustPostVo = new TmTermCustPostVo();
            termCustPostVo.setId(id);
            termCustPostVo.setTerminalCode(tmRTermCustPosBGEntity.getTmTerminal().getTerminalCode());
            termCustPostVo.setCustomerCode(tmRTermCustPosBGEntity.getTmCustomer().getCustomerCode());
            List tmRTermCustPosBGEntities = this.findByHql(hql, tmRTermCustPosBGEntity.getTmTerminal().getId(), customerId);
            if (CollectionUtil.listNotEmptyNotSizeZero(tmRTermCustPosBGEntities)) continue;
            String content = "\u4e0a\u7ea7\u5ba2\u6237\u6279\u91cf\u8c03\u6574,\u5173\u8054\u4e0a\u7ea7\u5ba2\u6237:<b>" + tmCustomerEntity.getCustomerName() + "</b>";
            if (tmRTermCustPosBGEntity.getTmCustomer() != null) {
                content = "\u4e0a\u7ea7\u5ba2\u6237\u66ff\u6362,\u539f\u4e0a\u7ea7\u5ba2\u6237:<b>" + tmRTermCustPosBGEntity.getTmCustomer().getCustomerName() + "</b>\u66ff\u6362\u4e3a<b>" + tmCustomerEntity.getCustomerName() + "<b>";
            }
            this.addLog(OperationType.UPDATE, "\u7ec8\u7aef\u4e0e\u5ba2\u6237\u5bf9\u5e94\u5173\u7cfb", tmRTermCustPosBGEntity.getTmTerminal().getId(), content);
            tmRTermCustPosBGEntity.setTmCustomer(tmCustomerEntity);
            this.updateEntity(tmRTermCustPosBGEntity);
        }
        return result;
    }

    @Override
    public List<TmCustomerVo> findCustomerBySelect(TmTermCustPostVo tmTermCustPostVo, Page page) {
        return this.tmTermCustPostDao.findCustomerBySelect(tmTermCustPostVo, page);
    }

    @Override
    public List<TmTerminalVo> findNotAnyPostTerminalList(TmTermCustPostVo tmTermCustPostVo, Page page) {
        return this.tmTermCustPostDao.findNotAnyPostTerminalList(tmTermCustPostVo, page);
    }

    @Override
    public List<TmTerminalVo> findNotCurrPostTerminalList(TmTermCustPostVo tmTermCustPostVo, Page page) {
        return this.tmTermCustPostDao.findNotCurrPostTerminalList(tmTermCustPostVo, page);
    }

    @Override
    public List<TmPositionVo> findPostionBySelect(TmTermCustPostVo tmTermCustPostVo, Page page) {
        return this.tmTermCustPostDao.findPositionBySelect(tmTermCustPostVo, page);
    }

    @Override
    public void addRelotaionForPositionId(String terminalIds, String positionId) {
        if (StringUtil.isEmpty((String)terminalIds) && StringUtil.isEmpty((String)positionId)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        String[] ids = terminalIds.split(",");
        TmPositionEntity tmPositionEntity = this.get(TmPositionEntity.class, (Serializable)((Object)positionId));
        TmTerminalEntity tmTerminalEntity = null;
        String hql = "from TmRTermCustPosBGEntity where tmTerminal.id=? and tmPosition.id=?";
        for (String terminalId : ids) {
            tmTerminalEntity = this.get(TmTerminalEntity.class, (Serializable)((Object)terminalId));
            List tmRTermCustPosBGEntities = this.findByHql(hql, terminalId, positionId);
            if (CollectionUtil.listNotEmptyNotSizeZero(tmRTermCustPosBGEntities)) continue;
            TmRTermCustPosBGEntity tmRTermCustPosBGEntity = new TmRTermCustPosBGEntity();
            tmRTermCustPosBGEntity.setTmPosition(tmPositionEntity);
            tmRTermCustPosBGEntity.setTmTerminal(tmTerminalEntity);
            this.save(tmRTermCustPosBGEntity);
            String content = "\u7ec8\u7aef\u5bf9\u63a5\u4eba\u804c\u4f4d\u6279\u91cf\u8c03\u6574,\u5173\u8054\u5bf9\u63a5\u4eba\u804c\u4f4d:<b>" + tmPositionEntity.getPositionName() + "</b>";
            this.addLog(OperationType.INSERT, "\u7ec8\u7aef\u4e0e\u804c\u4f4d\u5bf9\u5e94\u5173\u7cfb", terminalId, content);
        }
    }

    @Override
    public void updatePostTerminalRelation(String relationIds, String positionId) {
        if (StringUtil.isEmpty((String)relationIds) && StringUtil.isEmpty((String)positionId)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        String[] ids = relationIds.split(",");
        TmPositionEntity tmPositionEntity = this.get(TmPositionEntity.class, (Serializable)((Object)positionId));
        TmRTermCustPosBGEntity tmRTermCustPosBGEntity = null;
        String hql = "from TmRTermCustPosBGEntity where tmTerminal.id=? and tmPosition.id=?";
        for (String id : ids) {
            tmRTermCustPosBGEntity = this.get(TmRTermCustPosBGEntity.class, (Serializable)((Object)id));
            List tmRTermCustPosBGEntities = this.findByHql(hql, tmRTermCustPosBGEntity.getTmTerminal().getId(), positionId);
            if (CollectionUtil.listNotEmptyNotSizeZero(tmRTermCustPosBGEntities)) continue;
            String content = "\u7ec8\u7aef\u5bf9\u63a5\u4eba\u804c\u4f4d\u6279\u91cf\u8c03\u6574,\u5173\u8054\u5bf9\u63a5\u4eba\u804c\u4f4d:<b>" + tmPositionEntity.getPositionName() + "</b>";
            if (tmRTermCustPosBGEntity.getTmPosition() != null) {
                content = "\u7ec8\u7aef\u5bf9\u63a5\u4eba\u804c\u4f4d\u66ff\u6362,\u539f\u5bf9\u63a5\u4eba\u804c\u4f4d:<b>" + tmRTermCustPosBGEntity.getTmPosition().getPositionName() + "</b>\u66ff\u6362\u4e3a<b>" + tmPositionEntity.getPositionName() + "<b>";
            }
            this.addLog(OperationType.UPDATE, "\u7ec8\u7aef\u4e0e\u804c\u4f4d\u5bf9\u5e94\u5173\u7cfb", tmRTermCustPosBGEntity.getTmTerminal().getId(), content);
            tmRTermCustPosBGEntity.setTmPosition(tmPositionEntity);
            this.updateEntity(tmRTermCustPosBGEntity);
        }
    }
}

