/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.util.Md5EncryptionAndDecryption;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import com.biz.eisp.mdm.web.pojo.Client;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;

public class TokenUtil {
    public static Map<String, Client> tokenMap = new ConcurrentHashMap<String, Client>();
    public static final String TOKEN_STRING_NAME = "TOKEN_STRING_NAME";

    public static String getTokenStr(HttpSession session) {
        Object obj = session.getAttribute(TOKEN_STRING_NAME);
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    public static String tokenMd5(String token, String userName) {
        if (StringUtil.isNotEmpty((String)userName)) {
            token = userName + token;
        }
        String md5 = Md5EncryptionAndDecryption.encryPwd(token);
        return md5;
    }

    public static void saveTokenString(Client client, HttpSession session, IRedisCacheService redisCacheService) throws Exception {
        String tokenStr = TokenUtil.getTokenStr(session);
        if (redisCacheService != null && redisCacheService.checkAuto()) {
            redisCacheService.set(tokenStr, client, client.getExpire());
        } else {
            tokenMap.put(tokenStr, client);
        }
    }

    public static String generateToken(String userId) {
        return userId + new Long(System.currentTimeMillis()).toString();
    }

    public static boolean isTokenStringValid(IRedisCacheService redisCacheService, String token) {
        boolean valid = false;
        if (redisCacheService != null && redisCacheService.checkAuto()) {
            Client client = TokenUtil.getClient(redisCacheService, token);
            if (client != null) {
                valid = true;
                tokenMap.put(token, client);
            }
        } else if (tokenMap.containsKey(token)) {
            valid = true;
        }
        return valid;
    }

    public static void removeToken(IRedisCacheService redisCacheService, HttpSession session) throws Exception {
        String tokenStr = TokenUtil.getTokenStr(session);
        if (redisCacheService != null && redisCacheService.checkAuto()) {
            redisCacheService.remove(tokenStr);
            tokenMap.remove(tokenStr);
        } else {
            tokenMap.remove(tokenStr);
        }
    }

    public static Client getClient(IRedisCacheService redisCacheService, String token) {
        Client client = null;
        try {
            client = redisCacheService.get(token, Client.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return client;
    }
}

