/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.core.dao;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.JdbcProxy;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.utils.Constants;
import com.biz.eisp.base.utils.NumberUtils;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

public class HibernateBaseDao {
    public static final Log log = LogFactory.getLog((String)"HibernateBaseDao");
    private SessionFactory sessionFactory;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public Session getSession() {
        return this.sessionFactory.getCurrentSession();
    }

    @Transactional
    public void saveOrUpdate(Object object) {
        this.getSession().saveOrUpdate(object);
    }

    @Transactional
    public String save(Object object) {
        return (String)((Object)this.getSession().save(object));
    }

    @Transactional
    public void saveAll(Collection collection) {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.save(it.next());
        }
    }

    @Transactional
    public void delete(Object object) {
        this.getSession().delete(object);
    }

    @Transactional
    public void deleteAll(String hql, Object ... values) {
        this.deleteAll(this.find(hql, values));
    }

    @Transactional
    public void deleteAll(Collection collection) {
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            this.delete(it.next());
        }
    }

    @Transactional
    public <T> void deleteById(Class<T> entityClass, Serializable id) {
        this.delete(this.get(entityClass, id));
    }

    public <T> T get(Class<T> entityClass, Serializable id) {
        return (T)this.getSession().get(entityClass, id);
    }

    public <T> T load(Class<T> entityClass, Serializable id) {
        return (T)this.getSession().load(entityClass, id);
    }

    public <T> T get(Class<T> entityClass, Serializable id, LockMode mode) {
        return (T)this.getSession().get(entityClass, id, mode);
    }

    public <T> List<T> getAll(Class<T> entityClass) {
        return this.createCriteria(entityClass, new Criterion[0]).list();
    }

    public <T> List<T> getAll(Class<T> entityClass, String orderBy) {
        return this.find("from " + entityClass.getSimpleName() + " order by " + orderBy, new Object[0]);
    }

    public List find(String queryString, Object ... values) {
        return this.createQuery(queryString, values).list();
    }

    public List find(String queryString, LockMode mode, String alise, Object ... values) {
        return this.createQuery(queryString, mode, alise, values).list();
    }

    public <T> List<T> findEntity(Class<T> entityClass, String queryString, Object ... values) {
        return this.find(queryString, values);
    }

    public Integer findInt(String queryString, Object ... values) {
        return (Integer)this.findUnique(queryString, values);
    }

    public Long findLong(String queryString, Object ... values) {
        return (Long)this.findUnique(queryString, values);
    }

    public Object findUnique(String queryString, Object ... values) {
        return this.createQuery(queryString, values).setMaxResults(1).uniqueResult();
    }

    public <T> T findUniqueEntity(Class<T> entityClass, String queryString, Object ... values) {
        return (T)this.findUnique(queryString, values);
    }

    public Object sqlQueryForObject(String sql, Object ... params) {
        SQLQuery query = this.getSession().createSQLQuery(sql);
        this.addParams((Query)query, params);
        return query.uniqueResult();
    }

    private void addParams(Query query, Object ... params) {
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                query.setParameter(i, params[i]);
            }
        }
    }

    public <T> List<T> findPage(Class<T> entityClass, Page page, String queryString, Object ... values) {
        int pageStart = page.getInt(Page.PAGE);
        int pageSize = page.getInt(Page.ROWS);
        Query query = this.createQuery(queryString, values);
        if (page.isPaging()) {
            ScrollableResults scrollableResults = query.scroll(ScrollMode.SCROLL_SENSITIVE);
            scrollableResults.last();
            page.put(Page.TOTAL, String.valueOf(scrollableResults.getRowNumber() + 1));
            page.compute();
            query.setFirstResult(pageStart);
            query.setMaxResults(pageSize);
        }
        return query.list();
    }

    public boolean isUnique(Object entity, String propertyNames) {
        Class clazz = this.getTrueClass(entity);
        Criteria criteria = this.createCriteria(clazz, new Criterion[0]).setProjection(Projections.rowCount());
        String[] nameList = StringUtil.split((String)propertyNames, (String)",");
        try {
            boolean isQuery = false;
            for (String name : nameList) {
                Object obj = PropertyUtils.getProperty((Object)entity, (String)name);
                if (obj != null) {
                    criteria.add((Criterion)Restrictions.eq((String)name, (Object)obj));
                    isQuery = true;
                    continue;
                }
                isQuery = false;
            }
            if (!isQuery) {
                return true;
            }
            String idName = this.getIdName(clazz);
            Serializable id = this.getId(clazz, entity);
            if (id != null) {
                criteria.add(Restrictions.not((Criterion)Restrictions.eq((String)idName, (Object)id)));
            }
        }
        catch (Exception e) {
            ReflectionUtils.handleReflectionException((Exception)e);
        }
        return (Integer)criteria.uniqueResult() == 0;
    }

    public <T> List<T> findByCriteria(Class<T> entityClass, Criterion ... criterion) {
        return this.createCriteria(entityClass, criterion).list();
    }

    public Query createQuery(String queryString, Object ... values) {
        Query query = this.getSession().createQuery(queryString);
        for (int i = 0; i < values.length; ++i) {
            query.setParameter(i, values[i]);
        }
        return query;
    }

    public Query createQuery(String queryString, LockMode mode, String alise, Object ... values) {
        Query query = this.getSession().createQuery(queryString);
        query.setLockMode(alise, mode);
        for (int i = 0; i < values.length; ++i) {
            query.setParameter(i, values[i]);
        }
        return query;
    }

    public Criteria createCriteria(Class entityClass, Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(entityClass);
        for (Criterion c : criterions) {
            criteria.add(c);
        }
        return criteria;
    }

    public void flush() {
        this.getSession().flush();
    }

    public void clear() {
        this.getSession().clear();
    }

    public void evict(Object object) {
        this.getSession().evict(object);
    }

    public Serializable getId(Class entityClass, Object entity) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (Serializable)PropertyUtils.getProperty((Object)entity, (String)this.getIdName(entityClass));
    }

    public String getIdName(Class entityClass) {
        ClassMetadata meta = this.getSessionFactory().getClassMetadata(entityClass);
        return meta.getIdentifierPropertyName();
    }

    public Class getTrueClass(Object object) {
        Class<?> clazz = object.getClass();
        String className = clazz.getName();
        int index = className.indexOf("$");
        if (index != -1) {
            className = className.substring(0, index);
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
        }
        return clazz;
    }

    public <T> List<T> query(Class<T> entityClass, Page page) {
        return this.query(entityClass, page, (String)page.get(Page.AUTH_PREFIX));
    }

    public <T> List<T> query(Class<T> entityClass, Page page, String authPrefix) {
        StringBuilder sb = new StringBuilder("from " + entityClass.getSimpleName() + " where 1=1");
        sb.append(this.makeQueryConditions(entityClass, page, "", authPrefix));
        sb.append(this.makeQuerySort(entityClass, page, ""));
        return this.findPage(entityClass, page, sb.toString(), new Object[0]);
    }

    public void initAuthExp(Class entityClass, Page page, String expression, String authPrefix) {
        String entityName = entityClass.getSimpleName();
        String[] exps = StringUtil.split((String)expression, (String)";");
        String keys = "";
        String values = "";
        for (String exp : exps) {
            if (entityName.indexOf("BaseOrg") == 0 && exp.indexOf("baseEmployee") != -1) continue;
            String[] kv = StringUtil.split((String)exp, (String)"=");
            String key = kv[0];
            String value = (String)page.get(kv[1]);
            if (StringUtil.isNotBlank((String)authPrefix)) {
                int p = key.indexOf("_");
                key = key.substring(0, p + 1) + authPrefix + key.substring(p);
            }
            if (!StringUtil.isNotBlank((String)value)) continue;
            String[] props = StringUtil.split((String)key, (String)"_");
            if (props[1].toUpperCase().equals(entityName.toUpperCase())) {
                keys = keys + StringUtil.replace(key, "_" + props[1], "") + " ;";
                values = values + value + ";";
                continue;
            }
            try {
                Class<?> c = entityClass;
                for (int i = 1; i < props.length; ++i) {
                    c = c.getDeclaredField(props[i]).getType();
                }
                keys = keys + key + " ;";
                values = values + value + ";";
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!"".equals(keys)) {
            page.put(keys, values);
        }
    }

    public String makeQueryConditions(Class entityClass, Page page, String alias) {
        return this.makeQueryConditions(entityClass, page, alias, null);
    }

    public String makeQueryConditions(Class entityClass, Page page, String alias, String authPrefix) {
        String expressions = (String)page.get(Page.DATA_AUTH);
        if (StringUtil.isNotBlank((String)expressions)) {
            String[] expArray;
            for (String expression : expArray = StringUtil.split((String)expressions, (String)",")) {
                this.initAuthExp(entityClass, page, expression, authPrefix);
            }
        }
        alias = StringUtil.isNotBlank((String)alias) ? alias + "." : "";
        StringBuilder conditions = new StringBuilder(200);
        Set keys = page.keySet();
        for (String key : keys) {
            String[] val = StringUtil.split((String)((String)page.get(key)), (String)";");
            if (val == null) continue;
            String[] exp = StringUtil.split((String)key, (String)";");
            StringBuilder cond = new StringBuilder(50);
            for (int i = 0; i < exp.length && i < val.length; ++i) {
                String[] values;
                String prefix;
                if (exp[i].indexOf("$") != 0 || !StringUtil.isNotEmpty((String)val[i]) || !Constants.QUERY_EXP.containsKey(prefix = exp[i].substring(0, exp[i].indexOf("_")))) continue;
                String name = alias + exp[i].substring(prefix.length() + 1).replaceAll("_", ".");
                String queryExp = Constants.QUERY_EXP.get(prefix);
                if (Constants.PATTERN_DATE.matcher(val[i]).matches() && (prefix.equals("$lt") || prefix.equals("$le"))) {
                    val[i] = val[i] + " 23:59:59";
                }
                if ("$in".equals(prefix)) {
                    String v = "'" + StringUtil.replace(val[i], ",", "','") + "'";
                    if (cond.length() == 0) {
                        cond.append(" and (").append(name).append(StringUtil.replace(queryExp, "?", v));
                        continue;
                    }
                    cond.append(" or ").append(name).append(StringUtil.replace(queryExp, "?", v));
                    continue;
                }
                for (String v : values = StringUtil.split((String)val[i], (String)",")) {
                    if (cond.length() == 0) {
                        cond.append(" and (").append(name).append(StringUtil.replace(queryExp, "?", v));
                        continue;
                    }
                    cond.append(" or ").append(name).append(StringUtil.replace(queryExp, "?", v));
                }
            }
            if (cond.length() <= 0) continue;
            conditions.append((CharSequence)cond.append(")"));
        }
        return conditions.toString();
    }

    public String makeQuerySort(Class entityClass, Page page, String alias) {
        if (StringUtil.isNotBlank((String)((String)page.get(Page.SORT)))) {
            alias = StringUtil.isNotBlank((String)alias) ? alias + "." : "";
            return " order by " + alias + (String)page.get(Page.SORT) + " " + (String)page.get(Page.DIR);
        }
        return "";
    }

    public void makeParentInfo(Class entityClass, Object object, String descName) {
        String parentName = entityClass.getSimpleName();
        parentName = parentName.substring(0, 1).toLowerCase() + parentName.substring(1);
        String idName = this.getIdName(this.getTrueClass(object));
        try {
            String currId;
            String id;
            Long levelCode = (Long)PropertyUtils.getProperty((Object)object, (String)"levelCode");
            String desc = StringUtil.toString(PropertyUtils.getProperty((Object)object, (String)descName));
            String currDesc = StringUtil.toString(PropertyUtils.getProperty((Object)object, (String)("pn" + levelCode)));
            if (desc.equals(currDesc) && (id = StringUtil.toString(PropertyUtils.getProperty((Object)object, (String)idName))).equals(currId = StringUtil.toString(PropertyUtils.getProperty((Object)object, (String)("pi" + levelCode))))) {
                String parentId = "";
                Object parent = PropertyUtils.getProperty((Object)object, (String)parentName);
                if (parent != null) {
                    parentId = StringUtil.toString(PropertyUtils.getProperty((Object)parent, (String)idName));
                }
                String currParnetId = "";
                if (levelCode > 1L) {
                    currParnetId = StringUtil.toString(PropertyUtils.getProperty((Object)object, (String)("pi" + (levelCode - 1L))));
                }
                if (parentId.equals(currParnetId)) {
                    return;
                }
            }
            for (int i = 1; i <= 8; ++i) {
                PropertyUtils.setProperty((Object)object, (String)("pi" + i), null);
                PropertyUtils.setProperty((Object)object, (String)("pn" + i), null);
            }
            this.updateParentInfo(entityClass, object, descName);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    private void updateParentInfo(Class entityClass, Object object, String descName) {
        String parentName = entityClass.getSimpleName();
        parentName = parentName.substring(0, 1).toLowerCase() + parentName.substring(1);
        Object parent = object;
        StringBuilder pnall = new StringBuilder();
        try {
            while (parent != null) {
                Object id = PropertyUtils.getProperty((Object)parent, (String)this.getIdName(this.getTrueClass(object)));
                Object desc = PropertyUtils.getProperty((Object)parent, (String)descName);
                String levelCode = PropertyUtils.getProperty((Object)parent, (String)"levelCode") + "";
                PropertyUtils.setProperty((Object)object, (String)("pi" + levelCode), (Object)id);
                PropertyUtils.setProperty((Object)object, (String)("pn" + levelCode), (Object)desc);
                if (pnall.length() > 0) {
                    pnall.insert(0, "-");
                }
                pnall.insert(0, desc);
                parent = PropertyUtils.getProperty((Object)parent, (String)parentName);
            }
            PropertyUtils.setProperty((Object)object, (String)"pnall", (Object)pnall.toString());
            Iterator it = ((Set)PropertyUtils.getProperty((Object)object, (String)(parentName + "s"))).iterator();
            while (it.hasNext()) {
                this.updateParentInfo(entityClass, it.next(), descName);
            }
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public void makeSubCode(Class entityClass, Object object) {
        this.makeSubCode(entityClass, object, "");
    }

    public void makeSubCode(Class entityClass, Object object, String whereExp) {
        String parentName = entityClass.getSimpleName();
        parentName = parentName.substring(0, 1).toLowerCase() + parentName.substring(1);
        String parentSubCode = "";
        Long parentLevelCode = 0L;
        try {
            Object id;
            Object parent = PropertyUtils.getProperty((Object)object, (String)parentName);
            if (parent != null) {
                parentSubCode = (String)PropertyUtils.getProperty((Object)parent, (String)"subCode");
                parentLevelCode = (Long)PropertyUtils.getProperty((Object)parent, (String)"levelCode");
            }
            if ((id = PropertyUtils.getProperty((Object)object, (String)this.getIdName(this.getTrueClass(object)))) == null) {
                PropertyUtils.setProperty((Object)object, (String)"subCode", (Object)this.getValidSubCode(this.getTrueClass(object), parentSubCode, whereExp));
                PropertyUtils.setProperty((Object)object, (String)"levelCode", (Object)(parentLevelCode + 1L));
            } else {
                String subCode = (String)PropertyUtils.getProperty((Object)object, (String)"subCode");
                Long levelCode = (Long)PropertyUtils.getProperty((Object)object, (String)"levelCode");
                if (!parentSubCode.equals("") && parentSubCode.indexOf(subCode) == 0) {
                    throw new Exception("\u4e0d\u80fd\u628a\u81ea\u5df1\u6216\u81ea\u5df2\u7684\u4e0b\u7ea7\u6539\u53d8\u4e3a\u81ea\u5df1\u7684\u4e0a\u7ea7");
                }
                if (subCode == null || levelCode == null || subCode.equals("") || levelCode == 0L || subCode.indexOf(parentSubCode) != 0 || levelCode != parentLevelCode + 1L) {
                    this.updateSubCode(entityClass, object, whereExp);
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public void makeFullPath(Class entityClass, Object object) {
        this.makeFullPath(entityClass, object, "");
    }

    public void makeFullPath(Class entityClass, Object object, String whereExp) {
        String parentName = entityClass.getSimpleName();
        parentName = parentName.substring(0, 1).toLowerCase() + parentName.substring(1);
        String parentFullPath = "";
        Long parentPath = 0L;
        try {
            Object id;
            Object parent = PropertyUtils.getProperty((Object)object, (String)parentName);
            if (parent != null) {
                parentFullPath = (String)PropertyUtils.getProperty((Object)parent, (String)"fullPath");
            }
            if ((id = PropertyUtils.getProperty((Object)object, (String)this.getIdName(this.getTrueClass(object)))) == null) {
                PropertyUtils.setProperty((Object)object, (String)"fullPath", (Object)this.getValidSubCode(this.getTrueClass(object), parentFullPath, whereExp));
            }
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public void updateSubCode(Class entityClass, Object object) {
        this.updateSubCode(entityClass, object, "");
    }

    public void updateSubCode(Class entityClass, Object object, String whereExp) {
        String parentName = entityClass.getSimpleName();
        parentName = parentName.substring(0, 1).toLowerCase() + parentName.substring(1);
        String parentSubCode = "";
        Long parentLevelCode = 0L;
        try {
            Object parent = PropertyUtils.getProperty((Object)object, (String)parentName);
            if (parent != null) {
                parentSubCode = (String)PropertyUtils.getProperty((Object)parent, (String)"subCode");
                parentLevelCode = (Long)PropertyUtils.getProperty((Object)parent, (String)"levelCode");
            }
            PropertyUtils.setProperty((Object)object, (String)"subCode", (Object)this.getValidSubCode(this.getTrueClass(object), parentSubCode, whereExp));
            PropertyUtils.setProperty((Object)object, (String)"levelCode", (Object)(parentLevelCode + 1L));
            this.save(object);
            Iterator it = ((Set)PropertyUtils.getProperty((Object)object, (String)(parentName + "s"))).iterator();
            while (it.hasNext()) {
                this.updateSubCode(entityClass, it.next(), whereExp);
            }
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
    }

    public String getValidSubCode(Class entityClass, String parentSubCode) {
        return this.getValidSubCode(entityClass, parentSubCode, "");
    }

    public String getValidSubCode(Class entityClass, String parentSubCode, String whereExp) {
        whereExp = StringUtil.isNotBlank((String)whereExp) ? "and " + whereExp : "";
        String queryString = "select subCode from " + entityClass.getSimpleName() + " where subCode like '" + parentSubCode + "___' " + whereExp + " order by subCode";
        Iterator it = this.find(queryString, new Object[0]).iterator();
        String code = null;
        for (int index = 0; index < 999; ++index) {
            if (it.hasNext()) {
                String c = (String)it.next();
                if (index == Integer.parseInt(c = c.substring(c.length() - 3))) continue;
                code = NumberUtils.format(index, "000");
                break;
            }
            code = NumberUtils.format(index, "000");
            break;
        }
        return parentSubCode + code;
    }

    public String getCode(Class entityClass, String alias) {
        return null;
    }

    public String makeSqlAuthExpByOrg(Page page, String alias) {
        alias = StringUtil.isBlank((String)alias) ? "" : alias + ".";
        StringBuilder exp = new StringBuilder("");
        int authLevel = Integer.parseInt((String)page.get(Page.DATA_AUTH_LEVEL));
        if (authLevel != 2 && authLevel != 3) {
            if (authLevel == 4) {
                String[] codes;
                for (String code : codes = ((String)page.get(Page.ORG_SUBCODE_KEY)).split("\\,")) {
                    if (exp.length() == 0) {
                        exp.append(" and (");
                    } else {
                        exp.append(" or ");
                    }
                    exp.append(alias).append("sub_code like '").append(code).append("%'");
                }
                exp.append(")");
            } else if (authLevel == 5) {
                exp.append(" and ").append(alias).append("org_id in (").append((String)page.get(Page.ORG_ID_KEY)).append(")");
            } else if (authLevel == 99 && StringUtil.isNotBlank((String)((String)page.get(Page.ORG_AUTH_KEY)))) {
                exp.append(" and ").append(alias).append("org_id in (").append((String)page.get(Page.ORG_AUTH_KEY)).append(")");
            }
        }
        return exp.toString();
    }

    public String makeSqlAuthExpByEmp(Page page, String alias) {
        alias = StringUtil.isBlank((String)alias) ? "" : alias + ".";
        String exp = "";
        int authLevel = Integer.parseInt((String)page.get(Page.DATA_AUTH_LEVEL));
        if (authLevel == 2) {
            exp = exp + " and " + alias + "sub_code like '" + (String)page.get(Page.PARENT_EMP_SUBCODE_KEY) + "%'";
        } else if (authLevel == 3) {
            exp = exp + " and " + alias + "level_code>=" + (String)page.get(Page.EMP_LEVELCODE_KEY);
        } else if (authLevel == 4) {
            exp = exp + " and " + alias + "sub_code like '" + (String)page.get(Page.EMP_SUBCODE_KEY) + "%'";
        } else if (authLevel == 5) {
            exp = exp + " and " + alias + "emp_id=" + (String)page.get(Page.EMP_ID_KEY);
        } else if (authLevel == 99 && StringUtil.isNotBlank((String)((String)page.get(Page.EMP_AUTH_KEY)))) {
            exp = exp + " and " + alias + "emp_id in (" + (String)page.get(Page.EMP_AUTH_KEY) + ")";
        }
        return exp;
    }

    public String makeSqlAuthExpByProd(Page page, String alias) {
        return null;
    }

    public String makeSqlSortExp(Page page, String alias) {
        return this.makeQuerySort(null, page, alias);
    }

    public List<Object[]> executeSqlQuery(String sql) {
        return this.getSqlList(null, sql);
    }

    public List<Map> executeSqlQueryMap(String sql) {
        return this.getSqlListMap(null, sql);
    }

    public <T> List<T> executeSqlQuery(Class<T> entityClass, String sql) {
        return this.getSqlList(entityClass, sql);
    }

    public Object[] executeUniqueSqlQuery(String sql) {
        Object[] object = null;
        Iterator<Object[]> it = this.executeSqlQuery(sql).iterator();
        if (it.hasNext()) {
            object = it.next();
        }
        return object;
    }

    public Map executeUniqueSqlQueryMap(String sql) {
        Map map = null;
        Iterator<Map> it = this.executeSqlQueryMap(sql).iterator();
        if (it.hasNext()) {
            map = it.next();
        }
        return map;
    }

    public <T> T executeUniqueSqlQuery(Class<T> entityClass, String sql) {
        T object = null;
        Iterator<T> it = this.executeSqlQuery(entityClass, sql).iterator();
        if (it.hasNext()) {
            object = it.next();
        }
        return object;
    }

    public List<Object[]> executeSqlQuery(String sql, Page page) {
        return this.getSqlList(null, sql, page);
    }

    public List<Map> executeSqlQueryMap(String sql, Page page) {
        return this.getSqlListMap(null, sql, page);
    }

    public <T> List<T> executeSqlQuery(Class<T> entityClass, String sql, Page page) {
        return this.getSqlList(entityClass, sql, page);
    }

    public int executeSqlUpdate(String sql) {
        int n = 0;
        Statement stat = null;
        try {
            stat = SessionFactoryUtils.getDataSource((SessionFactory)this.sessionFactory).getConnection().createStatement();
            n = stat.executeUpdate(sql);
        }
        catch (SQLException e) {
            throw new BusinessException(e.getMessage() + ":" + sql);
        }
        finally {
            try {
                if (stat != null) {
                    stat.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        return n;
    }

    public void executeCall(String procedure) {
        CallableStatement stat = null;
        try {
            stat = SessionFactoryUtils.getDataSource((SessionFactory)this.sessionFactory).getConnection().prepareCall(procedure);
            stat.executeUpdate();
        }
        catch (SQLException e) {
            throw new BusinessException(e.getMessage() + ":" + procedure);
        }
        finally {
            try {
                if (stat != null) {
                    stat.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private <T> List getSqlList(Class<T> entityClass, String sql) {
        List<Object> list = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            stat = SessionFactoryUtils.getDataSource((SessionFactory)this.sessionFactory).getConnection().createStatement();
            rs = stat.executeQuery(sql);
            list = entityClass == null ? JdbcProxy.getObjectArrayList(rs) : JdbcProxy.getEntityList(rs, entityClass);
        }
        catch (SQLException e) {
            throw new BusinessException(e.getMessage() + ":" + sql);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    private <T> List getSqlList(Class<T> entityClass, String sql, Page page) {
        List<Object> list = null;
        int pageStart = page.getInt(Page.PAGE);
        int pageSize = page.getInt(Page.ROWS);
        Statement stat = null;
        ResultSet rs = null;
        try {
            stat = SessionFactoryUtils.getDataSource((SessionFactory)this.sessionFactory).getConnection().createStatement(1005, 1007);
            rs = stat.executeQuery(sql);
            rs.last();
            page.put(Page.TOTAL, String.valueOf(rs.getRow()));
            page.compute();
            if (pageStart == 0) {
                rs.beforeFirst();
            } else {
                rs.absolute(pageStart);
            }
            list = entityClass == null ? JdbcProxy.getObjectArrayList(rs, page.getLong(Page.ROWS)) : JdbcProxy.getEntityList(rs, page.getLong(Page.ROWS), entityClass);
        }
        catch (SQLException e) {
            throw new BusinessException(e.getMessage() + ":" + sql);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    private <T> List getSqlListMap(Class<T> entityClass, String sql) {
        List list = null;
        Statement stat = null;
        ResultSet rs = null;
        try {
            stat = SessionFactoryUtils.getDataSource((SessionFactory)this.sessionFactory).getConnection().createStatement();
            rs = stat.executeQuery(sql);
            list = entityClass == null ? JdbcProxy.getObjectMapList(rs) : JdbcProxy.getEntityList(rs, entityClass);
        }
        catch (SQLException e) {
            throw new BusinessException(e.getMessage() + ":" + sql);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    private <T> List getSqlListMap(Class<T> entityClass, String sql, Page page) {
        List list = null;
        int pageSize = page.getInt(Page.ROWS);
        int pageStart = (page.getInt(Page.PAGE) - 1) * pageSize;
        Statement stat = null;
        ResultSet rs = null;
        try {
            stat = SessionFactoryUtils.getDataSource((SessionFactory)this.sessionFactory).getConnection().createStatement(1005, 1007);
            rs = stat.executeQuery(sql);
            rs.last();
            page.put(Page.TOTAL, String.valueOf(rs.getRow()));
            page.compute();
            if (pageStart == 0) {
                rs.beforeFirst();
            } else {
                rs.absolute(pageStart);
            }
            list = entityClass == null ? JdbcProxy.getObjectMapList(rs, page.getLong(Page.ROWS)) : JdbcProxy.getEntityList(rs, page.getLong(Page.ROWS), entityClass);
        }
        catch (SQLException e) {
            throw new BusinessException(e.getMessage() + ":" + sql);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (stat != null) {
                try {
                    stat.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getProcValue(String procName, Map procParamValue, Page page, boolean isShowSql) {
        int pageStart = page.getInt(Page.PAGE);
        Statement cstat = null;
        ResultSet rs = null;
        List<Map> list = null;
        HashMap<String, Object> procValue = new HashMap<String, Object>();
        HashMap otherData = new HashMap();
        try {
            Connection connection = SessionFactoryUtils.getDataSource((SessionFactory)this.sessionFactory).getConnection();
            ResultSet procedureColumns = connection.getMetaData().getProcedureColumns(connection.getCatalog(), connection.getCatalog(), procName, null);
            String callValue = this.getCallValue(procedureColumns, procName, procParamValue, isShowSql);
            cstat = SessionFactoryUtils.getDataSource((SessionFactory)this.sessionFactory).getConnection().prepareCall(callValue);
            this.setProcParamValue((CallableStatement)cstat, procedureColumns, procParamValue);
            rs = cstat.executeQuery();
            rs.last();
            page.put(Page.TOTAL, String.valueOf(rs.getRow()));
            page.compute();
            if (pageStart == 0) {
                rs.beforeFirst();
            } else {
                rs.absolute(pageStart);
            }
            list = JdbcProxy.getObjectMapList(rs, page.getLong(Page.PAGE));
            this.setOutParameterValue((CallableStatement)cstat, procedureColumns, otherData);
            procValue.put("dataList", list);
            procValue.put("otherData", otherData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (cstat != null) {
                try {
                    cstat.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return procValue;
    }

    protected String getCallValue(ResultSet procedureColumns, String procName, Map procParamValue, boolean isShowSql) {
        StringBuilder callValue = new StringBuilder("{call " + procName + "(");
        StringBuilder callLogValue = new StringBuilder("{call " + procName + "(");
        try {
            boolean flag = procedureColumns.next();
            while (flag) {
                String columnName = procedureColumns.getString("COLUMN_NAME");
                short columnType = procedureColumns.getShort("COLUMN_TYPE");
                callValue.append("?,");
                if (columnType == 1) {
                    callLogValue.append("\"" + procParamValue.get(columnName) + "\",");
                } else {
                    callLogValue.append("@" + columnName + ",");
                }
                flag = procedureColumns.next();
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u6784\u9020\u5b58\u50a8\u8fc7\u7a0bcall\u8bed\u53e5\u5931\u8d25\n" + e.getMessage());
        }
        callValue.append("&)}");
        callLogValue.append("&)}");
        if (isShowSql) {
            log.info((Object)("\n\n\u8c03\u7528\u8bed\u53e5-->" + callLogValue.toString().replace(",&)}", ")}\n")));
        }
        return callValue.toString().replace(",&)}", ")}");
    }

    private void setProcParamValue(CallableStatement cstat, ResultSet procedureColumns, Map procParamValue) {
        String columnName = "";
        try {
            procedureColumns.beforeFirst();
            boolean flag = procedureColumns.next();
            while (flag) {
                short columnType = procedureColumns.getShort("COLUMN_TYPE");
                short dataType = procedureColumns.getShort("DATA_TYPE");
                columnName = procedureColumns.getString("COLUMN_NAME");
                Object paramValue = procParamValue.get(columnName);
                if (paramValue == null) {
                    throw new BusinessException("\u4e0d\u5b58\u5728\u5b58\u50a8\u8fc7\u7a0b\u53c2\u6570:" + columnName);
                }
                if (columnType == 1) {
                    cstat.setObject(columnName, paramValue);
                } else {
                    cstat.registerOutParameter(columnName, (int)dataType);
                }
                flag = procedureColumns.next();
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u5b58\u50a8\u8fc7\u7a0b\u53c2\u6570\u3010" + columnName + "\u3011\u8d4b\u503c\u65f6\u9519\u8bef\n" + e.getMessage());
        }
    }

    private void setOutParameterValue(CallableStatement cstat, ResultSet procedureColumns, Map otherData) {
        String columnName = "";
        try {
            procedureColumns.beforeFirst();
            boolean flag = procedureColumns.next();
            while (flag) {
                short columnType = procedureColumns.getShort("COLUMN_TYPE");
                short dataType = procedureColumns.getShort("DATA_TYPE");
                columnName = procedureColumns.getString("COLUMN_NAME");
                if (columnType == 4) {
                    if (dataType == 3 || dataType == 1111) {
                        otherData.put(columnName, cstat.getBigDecimal(columnName));
                    } else if (dataType == 4) {
                        otherData.put(columnName, cstat.getInt(columnName));
                    } else if (dataType == 12) {
                        otherData.put(columnName, cstat.getString(columnName));
                    }
                }
                flag = procedureColumns.next();
            }
        }
        catch (SQLException e) {
            throw new BusinessException("\u83b7\u53d6outParameter:" + columnName + "\u503c\u9519\u8bef\n" + e.getMessage());
        }
    }
}

