/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.demo.controller;

import com.biz.eisp.activiti.demo.entity.LeaveEntity;
import com.biz.eisp.activiti.demo.service.LeaveService;
import com.biz.eisp.activiti.demo.vo.TaLeaveQueryVo;
import com.biz.eisp.activiti.demo.vo.TaLeaveVo;
import com.biz.eisp.activiti.designer.businessconf.service.TaProcessBusinessObjConfigService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/leaveController"})
public class LeaveController
extends BaseController {
    @Autowired
    private LeaveService leaveService;
    @Autowired
    private TaProcessBusinessObjConfigService taProcessBusinessObjConfigService;

    @RequestMapping(value={"goLeaveMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goLeaveMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/activiti/demo/leaveMain");
    }

    @RequestMapping(value={"goLeaveHisMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goLeaveMain(String id, HttpServletRequest request) {
        request.setAttribute("id", (Object)id);
        return new ModelAndView("com/biz/eisp/activiti/demo/leaveHisMain");
    }

    @RequestMapping(value={"goLeaveForm"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goLeaveForm(String id, HttpServletRequest request) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            LeaveEntity entity = this.leaveService.get(LeaveEntity.class, (Serializable)((Object)id));
            TaLeaveQueryVo vo = new TaLeaveQueryVo();
            vo.setId(entity.getId());
            vo.setContent(entity.getContent());
            vo.setProcessTitle(entity.getProcessTitle());
            vo.setProcessKey(entity.getTaProcessBusinessObjConfigEntity().getTaProcessEntity().getProcessKey());
            vo.setProcessName(entity.getTaProcessBusinessObjConfigEntity().getTaProcessEntity().getProcessName());
            request.setAttribute("vo", (Object)vo);
        }
        return new ModelAndView("com/biz/eisp/activiti/demo/leaveForm");
    }

    @RequestMapping(params={"goLeaveForm1"})
    public ModelAndView goLeaveForm1(HttpServletRequest request) {
        String businessObjId = request.getParameter("businessObjId");
        LeaveEntity entity = this.leaveService.get(LeaveEntity.class, (Serializable)((Object)businessObjId));
        request.setAttribute("vo", (Object)entity);
        return new ModelAndView("com/biz/eisp/activiti/demo/leaveForm2");
    }

    @RequestMapping(value={"findLeaveList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findLeaveList(TaLeaveQueryVo taLeaveQueryVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        taLeaveQueryVo.setPositionCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
        List<TaLeaveQueryVo> list = this.leaveService.findLeaveList(taLeaveQueryVo, page);
        return new DataGrid(list, page);
    }

    @RequestMapping(value={"findLeaveHisList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findLeaveHisList(TaLeaveQueryVo taLeaveQueryVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        taLeaveQueryVo.setPositionCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
        if (StringUtil.isNotEmpty((String)taLeaveQueryVo.getId())) {
            LeaveEntity entity = this.leaveService.get(LeaveEntity.class, (Serializable)((Object)taLeaveQueryVo.getId()));
            taLeaveQueryVo.setId(entity.getRefrenceId());
        }
        List<TaLeaveQueryVo> list = this.leaveService.findLeaveHisList(taLeaveQueryVo, page);
        return new DataGrid(list, page);
    }

    @RequestMapping(value={"saveLeave"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveLeave(TaLeaveVo taLeaveVo, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        EuPage page = new EuPage(request);
        try {
            this.leaveService.saveTaLeave(taLeaveVo, page);
        }
        catch (Exception e) {
            ajaxJson.setSuccess(false);
            ajaxJson.setMsg("\u4fdd\u5b58\u5931\u8d25");
            e.printStackTrace();
        }
        return ajaxJson;
    }

    @RequestMapping(value={"deleteLeave"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson deleteLeave(String id, HttpServletRequest request, HttpServletResponse response) {
        String runtimeStatusCode;
        LeaveEntity leaveEntity = this.taProcessBusinessObjConfigService.get(LeaveEntity.class, (Serializable)((Object)id));
        String string = runtimeStatusCode = leaveEntity.getTaRuntimeStatusEntity() == null ? "" : leaveEntity.getTaRuntimeStatusEntity().getCode();
        if (StringUtils.isNotBlank((CharSequence)runtimeStatusCode) && !"new".equals(runtimeStatusCode)) {
            return new AjaxJson("\u5df2\u8fdb\u5165\u6d41\u7a0b\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.taProcessBusinessObjConfigService.delete(leaveEntity);
        return new AjaxJson();
    }
}

