/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.demo.service.impl;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.demo.entity.DemoEntity;
import com.biz.eisp.activiti.demo.entity.DemoObjEntity;
import com.biz.eisp.activiti.demo.service.DemoService;
import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessBusinessObjConfigEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaProcessBusinessObjConfigService;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessBusinessObjConfigVo;
import com.biz.eisp.activiti.runtime.entity.TaRuntimeStatusEntity;
import com.biz.eisp.activiti.runtime.service.TaKeyIndicators;
import com.biz.eisp.activiti.runtime.service.TaProcessInstanceService;
import com.biz.eisp.activiti.runtime.vo.TaProcessThemeVo;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="demoService")
@Transactional
public class DemoServiceImpl
extends BaseServiceImpl
implements DemoService,
TaKeyIndicators {
    @Autowired
    private TaProcessBusinessObjConfigService taProcessBusinessObjConfigService;
    @Autowired
    private TaProcessInstanceService taProcessInstanceService;

    @Override
    public List<DemoEntity> findDemoList(Page page) {
        String hql = " from DemoEntity where createName = ?";
        return this.findByHql(hql, page, ResourceConfigUtils.getCreateName());
    }

    @Override
    public void submit(TaProcessThemeVo vo) {
        String[] key;
        String processKey = "process1511940919545";
        TmPositionEntity positionEntity = this.get(TmPositionEntity.class, (Serializable)((Object)ResourceConfigUtils.getCurrPosition().getId()));
        DemoObjEntity obj = new DemoObjEntity();
        TaProcessBusinessObjConfigEntity busConfig = this.taProcessBusinessObjConfigService.getTaProcessBusinessObjConfigEntity(obj.getClass(), processKey);
        TaRuntimeStatusEntity runTimeStatusEnttiy = this.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", WorkFlowGlobals.RUNTIME_STATUS_NEW);
        obj.setCreatetime(new Date());
        obj.setTmPositionEntity(positionEntity);
        obj.setTaRuntimeStatusEntity(runTimeStatusEnttiy);
        obj.setTaProcessBusinessObjConfigEntity(busConfig);
        obj.setCreatetime(new Date());
        obj.setProcessTitle(vo.getName());
        obj.setProcessDetail(vo.getDetail());
        obj.setPositionCode(positionEntity.getPositionCode());
        obj.setPositionName(positionEntity.getPositionName());
        obj.setUserName(ResourceConfigUtils.getSessionUserName().getUserName());
        obj.setFullName(ResourceConfigUtils.getSessionUserName().getFullName());
        this.save(obj);
        String foreignKey = vo.getBusinessKeyMain();
        String sql = " update tb_attachment set business_key = ? where business_key = ?";
        this.updateBySql(sql, obj.getId(), foreignKey);
        for (String k : key = vo.getBusinessKey().split(",")) {
            DemoEntity de = this.get(DemoEntity.class, (Serializable)((Object)k));
            de.setStatus(1);
            this.saveOrUpdate(de);
        }
        TaProcessBusinessObjConfigVo configVo = new TaProcessBusinessObjConfigVo();
        configVo.setId(busConfig.getId());
        HashMap<String, Object> var = new HashMap<String, Object>();
        ArrayList<String> list = new ArrayList<String>();
        list.add("zw0001");
        list.add("zw00024");
        var.put("persons", list);
        configVo.setVariables(var);
        this.taProcessInstanceService.saveStartWorkflow(configVo, obj);
    }

    @Override
    public List<Map<String, Object>> findKeyIndicators(String bussinessKey) {
        String sql = "select name,content from ta_demo ";
        return this.findForMapList(sql, new Object[0]);
    }
}

