/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.businessconf.controller;

import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessVariableEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaProcessVariableService;
import com.biz.eisp.activiti.designer.businessconf.transformer.TaProcessVariableEntityToTaProcessVariableVo;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessVariableVo;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taProcessVariableController"})
public class TaProcessVariableController
extends BaseController {
    @Autowired
    private TaProcessNodeService taProcessNodeService;
    @Autowired
    private TaProcessVariableService taProcessVariableService;

    @RequestMapping(value={"goVariableMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goVariableMain(String taProcessId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/businessconf/taProcessVariableMain");
        view.addObject("taProcessId", (Object)taProcessId);
        return view;
    }

    @RequestMapping(value={"findVariableList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findTaProcessVariableList(String processId, HttpServletRequest request) {
        EuPage page = new EuPage(request);
        List<TaProcessVariableVo> list = this.taProcessVariableService.getVariableByProcessId(processId, page);
        return new DataGrid(list, page);
    }

    @RequestMapping(value={"goVariableForm"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goVariableForm(String id, String taProcessId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/businessconf/taProcessVariableForm");
        if (StringUtils.isNotBlank((CharSequence)id)) {
            TaProcessVariableEntity entity = this.taProcessVariableService.get(TaProcessVariableEntity.class, (Serializable)((Object)id));
            TaProcessVariableVo vo = new TaProcessVariableEntityToTaProcessVariableVo().apply(entity);
            view.addObject("pvVo", (Object)vo);
        }
        List<TaProcessNodeVo> nodes = this.findNodeListByProcessId(taProcessId);
        view.addObject("processId", (Object)taProcessId);
        view.addObject("nodes", nodes);
        return view;
    }

    @RequestMapping(value={"saveOrUpdateVariable"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveOrUpdateVariable(TaProcessVariableVo pvVo) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taProcessVariableService.saveVariable(pvVo);
            aj.setMsg("\u4fdd\u5b58\u6210\u529f");
            aj.setSuccess(true);
        }
        catch (Exception e) {
            aj.setMsg("\u4fdd\u5b58\u5931\u8d25");
            aj.setSuccess(false);
            throw new RuntimeException("\u4fdd\u5b58\u53d8\u91cf\u51fa\u73b0\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5");
        }
        return aj;
    }

    @RequestMapping(value={"delVariableById"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson delVariableById(String id) {
        AjaxJson aj = new AjaxJson();
        if (!id.equals("")) {
            TaProcessVariableEntity entity = this.taProcessVariableService.get(TaProcessVariableEntity.class, (Serializable)((Object)id));
            this.taProcessVariableService.delete(entity);
            aj.setMsg("\u5220\u9664\u6210\u529f");
        } else {
            aj.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return aj;
    }

    public List<TaProcessNodeVo> findNodeListByProcessId(String processId) {
        List<TaProcessNodeVo> nodes = this.taProcessNodeService.getNodeByProcessId(processId);
        return nodes;
    }
}

