/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processcheck.controller;

import com.biz.eisp.activiti.designer.processcheck.batchck.BatchCheckProDeal;
import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckDetail;
import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckRecord;
import com.biz.eisp.activiti.designer.processcheck.service.TaProcessCheckService;
import com.biz.eisp.activiti.designer.processcheck.vo.ProcCkQuerySetVo;
import com.biz.eisp.activiti.designer.processcheck.vo.TaProcessCkRecordVo;
import com.biz.eisp.activiti.util.DateUtils;
import com.biz.eisp.activiti.util.EhcacheUtil;
import com.biz.eisp.activiti.util.JsonUtil;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.core.web.BaseController;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taProcessCheckController"})
public class TaProcessCheckController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(TaProcessCheckController.class);
    @Autowired
    private TaProcessCheckService taProcessCheckService;
    @Autowired
    private TaskService taskService;

    @RequestMapping(value={"processcheckView"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView processcheckView(HttpServletRequest request, String processKey) {
        try {
            TaProcessCkRecordVo vo = this.taProcessCheckService.createProcessCheck(processKey);
            request.setAttribute("processCkRecord", (Object)JsonUtil.toJson(vo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ModelAndView("com/biz/eisp/activiti/designer/processcheck/processCheckView");
    }

    @RequestMapping(value={"checkQuerySet"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView checkQuerySet(HttpServletRequest request) {
        try {
            String title = request.getParameter("title");
            String processId = request.getParameter("processId");
            request.setAttribute("title", (Object)title);
            List<ProcCkQuerySetVo> list = this.taProcessCheckService.checkQuerySet(processId);
            request.setAttribute("processCkParams", (Object)JsonUtil.toJson(list));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ModelAndView("com/biz/eisp/activiti/designer/processcheck/processCkQuerySet");
    }

    @RequestMapping(value={"saveCkRecord"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveCkRecord(HttpServletRequest request, String processId, String proCkQuerySet) {
        AjaxJson aj = new AjaxJson("\u4fdd\u5b58\u68c0\u6d4b\u8bb0\u5f55\u6210\u529f");
        aj.setSuccess(true);
        try {
            aj.setObj(this.taProcessCheckService.saveRecord(processId, proCkQuerySet));
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u4fdd\u5b58\u68c0\u6d4b\u8bb0\u5f55\u5931\u8d25");
        }
        return aj;
    }

    @RequestMapping(value={"updateCkRecord"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson updateCkRecord(HttpServletRequest request, TaProcessCheckRecord entity) {
        AjaxJson aj = new AjaxJson("\u751f\u6210\u62a5\u544a\u6210\u529f");
        aj.setSuccess(true);
        try {
            this.taProcessCheckService.updateCkRecord(entity);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u751f\u6210\u62a5\u544a\u5931\u8d25");
        }
        return aj;
    }

    @RequestMapping(value={"saveStopedNode"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveStopedNode(HttpServletRequest request, String isStopCheck, String nodeCode, String recordId, String allCkState) {
        AjaxJson aj = new AjaxJson("\u4fdd\u5b58\u4e2d\u65ad\u8282\u70b9\u8bb0\u5f55\u6210\u529f");
        aj.setSuccess(true);
        TaProcessCheckDetail detail = this.taProcessCheckService.findCheckDetail(nodeCode, recordId);
        try {
            detail.setCheckTime(DateUtils.getFormatDateStr(new Date(), "yyyy-MM-dd HH:mm:ss"));
            detail.setState("3");
            String remark = "<p><span style=\"color: blue;\">\u8282\u70b9\u68c0\u6d4b\u4e2d\u65ad";
            remark = "true".equals(isStopCheck) ? remark + "\uff0c\u539f\u56e0\uff1a\u4e2d\u9014\u505c\u6b62\u68c0\u6d4b\uff0c\u88ab\u8feb\u4e2d\u65ad\uff01" : ("1".equals(allCkState) ? remark + "\uff0c\u539f\u56e0\uff1a\u672a\u81ea\u52a8\u627e\u5230\u8be5\u8282\u70b9\u4efb\u52a1\uff0c\u53ef\u80fd\u8be5\u8282\u70b9\u4e3a\u6761\u4ef6\u53c2\u6570\u7684\u5206\u652f\u8282\u70b9\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u5206\u652f\u53c2\u6570\u518d\u68c0\u6d4b\uff01" : remark + "\uff0c\u539f\u56e0\uff1a\u4e2d\u9014\u8282\u70b9\u68c0\u6d4b\u5931\u8d25\uff0c\u88ab\u8feb\u4e2d\u65ad\uff01");
            remark = remark + "</span></p><p>-----------------------------------------</p>";
            detail.setCheckResult(remark);
            this.taProcessCheckService.updateEntity(detail);
            aj.setObj(detail);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u4fdd\u5b58\u4e2d\u65ad\u8282\u70b9\u8bb0\u5f55\u5931\u8d25");
        }
        return aj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"passCkReq"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson passCkReq(HttpServletRequest request, String nodeCode, String recordId) {
        AjaxJson aj = new AjaxJson("\u68c0\u6d4b\u8bb0\u5f55\u6210\u529f");
        aj.setSuccess(true);
        TaProcessCheckDetail detail = this.taProcessCheckService.findCheckDetail(nodeCode, recordId);
        try {
            detail = this.taProcessCheckService.passCkReq(detail);
            String procInsId = detail.getProcessInsId();
            List nextTasks = this.taskService.createTaskQuery().processInstanceId(procInsId).list();
            if (nextTasks.size() > 0) {
                detail.setNextNode(((Task)nextTasks.get(0)).getTaskDefinitionKey());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            aj.setSuccess(false);
            aj.setMsg(e.getMessage());
        }
        finally {
            this.taProcessCheckService.updateEntity(detail);
            aj.setObj(detail);
            return aj;
        }
    }

    @RequestMapping(value={"loadHisRecord"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public List<TaProcessCkRecordVo> loadHisRecord(HttpServletRequest request, String processId) {
        TaProcessCkRecordVo vo = new TaProcessCkRecordVo();
        vo.setProcessId(processId);
        vo.setState("1");
        List<TaProcessCkRecordVo> list = this.taProcessCheckService.getCkRecords(vo);
        vo.setState("2");
        list.addAll(this.taProcessCheckService.getCkRecords(vo));
        return list;
    }

    @RequestMapping(value={"deleteHis"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson deleteHis(HttpServletRequest request, String id) {
        AjaxJson aj = new AjaxJson("\u5220\u9664\u62a5\u544a\u6210\u529f");
        aj.setSuccess(true);
        try {
            this.taProcessCheckService.deleteHis(id);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u5220\u9664\u62a5\u544a\u5931\u8d25");
        }
        return aj;
    }

    @RequestMapping(value={"openHis"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView openHis(HttpServletRequest request, String recordId) {
        String url = "com/biz/eisp/activiti/designer/processcheck/processCkHisDetail";
        try {
            TaProcessCkRecordVo vo = this.taProcessCheckService.findRecordDetail(recordId);
            if (vo.getIsBatchUser() != null && vo.getIsBatchUser() == 1) {
                url = "com/biz/eisp/activiti/designer/processcheck/procCkBatchHisDetail";
            }
            request.setAttribute("processCkRecord", (Object)JsonUtil.toJson(vo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ModelAndView(url);
    }

    @RequestMapping(value={"toBatchCheck"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson toBatchCheck(HttpServletRequest request, String processId, String proCkQuerySet) {
        AjaxJson aj = new AjaxJson("\u6279\u91cf\u68c0\u6d4b\u5f00\u59cb\u6210\u529f");
        aj.setSuccess(true);
        try {
            String batchId = UUID.randomUUID().toString().replace("-", "");
            TaProcessCkRecordVo vo = (TaProcessCkRecordVo)EhcacheUtil.getItem("PRO_CK_" + processId);
            vo.setId(batchId);
            vo.setTitle(vo.getTitle());
            vo.setCkParams(proCkQuerySet);
            vo.setIsBatchUser(1);
            vo.setCheckTime(DateUtils.getFormatDateStr(new Date(), "yyyy-MM-dd HH:mm:ss"));
            String modelDetails = JsonUtil.toJson(vo.getCkPassDetails());
            vo.setCkPassDetails(new ArrayList<TaProcessCheckDetail>());
            List<String> users = this.taProcessCheckService.getBatchUserIds(proCkQuerySet);
            vo.setUsers(users);
            for (String user : users) {
                ArrayList<TaProcessCheckDetail> details = JsonUtil.toObjectArrayListFromJson(modelDetails, new TypeReference<List<TaProcessCheckDetail>>(){});
                for (TaProcessCheckDetail detail : details) {
                    detail.setUserName(user);
                }
                vo.getCkPassDetails().addAll(details);
            }
            EhcacheUtil.putItem("PRO_CK_" + batchId, vo);
            EhcacheUtil.putItem("PRO_CK_PG_ALL_" + batchId, vo.getCkPassDetails().size());
            EhcacheUtil.putItem("PRO_CK_PG_SUCC_" + batchId, 0);
            EhcacheUtil.putItem("PRO_CK_PG_FAIL_" + batchId, 0);
            EhcacheUtil.putItem("PRO_CK_PG_STOP_" + batchId, 0);
            new BatchCheckProDeal(users, batchId).execute();
            aj.setObj(batchId);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u6279\u91cf\u68c0\u6d4b\u5f02\u5e38");
        }
        return aj;
    }

    @RequestMapping(value={"batchProgress"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson batchProgress(HttpServletRequest request, String batchId) {
        AjaxJson aj = new AjaxJson("\u6279\u91cf\u68c0\u6d4b\u8fdb\u5ea6\u60c5\u51b5\u83b7\u53d6\u6210\u529f");
        aj.setSuccess(true);
        try {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            int succ = (Integer)EhcacheUtil.getItem("PRO_CK_PG_SUCC_" + batchId);
            int fail = (Integer)EhcacheUtil.getItem("PRO_CK_PG_FAIL_" + batchId);
            int stop = (Integer)EhcacheUtil.getItem("PRO_CK_PG_STOP_" + batchId);
            int count = (Integer)EhcacheUtil.getItem("PRO_CK_PG_ALL_" + batchId);
            int pg = (succ + fail + stop) * 100 / count;
            if (pg == 100) {
                TaProcessCkRecordVo vo = (TaProcessCkRecordVo)EhcacheUtil.getItem("PRO_CK_" + batchId);
                List<TaProcessCheckDetail> ckDetails = vo.getCkPassDetails();
                for (String user : vo.getUsers()) {
                    for (TaProcessCheckDetail detail : ckDetails) {
                        if (!user.equals(detail.getUserName())) continue;
                        logger.info(user + ":" + JsonUtil.toJson(detail));
                    }
                }
            }
            map.put("succ", succ);
            map.put("fail", fail);
            map.put("stop", stop);
            map.put("pg", pg);
            aj.setObj(map);
        }
        catch (Exception e) {
            aj.setSuccess(false);
            aj.setMsg("\u6279\u91cf\u68c0\u6d4b\u8fdb\u5ea6\u60c5\u51b5\u83b7\u53d6\u5f02\u5e38");
        }
        return aj;
    }

    @RequestMapping(value={"saveBatchCk"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveBatchCk(HttpServletRequest request, String batchId, String resultRemark) {
        AjaxJson aj = new AjaxJson("\u751f\u6210\u62a5\u544a\u6210\u529f");
        aj.setSuccess(true);
        try {
            this.taProcessCheckService.saveBatchCk(batchId, resultRemark);
            EhcacheUtil.removeItem("PRO_CK_" + batchId);
            EhcacheUtil.removeItem("PRO_CK_PG_ALL_" + batchId);
            EhcacheUtil.removeItem("PRO_CK_PG_SUCC_" + batchId);
            EhcacheUtil.removeItem("PRO_CK_PG_FAIL_" + batchId);
            EhcacheUtil.removeItem("PRO_CK_PG_STOP_" + batchId);
        }
        catch (Exception e) {
            e.printStackTrace();
            aj.setSuccess(false);
            aj.setMsg("\u751f\u6210\u62a5\u544a\u5931\u8d25");
        }
        return aj;
    }
}

