/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.entity.TaListenerEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaListenerService;
import com.biz.eisp.activiti.designer.processconf.vo.TaListenerVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taListenerController"})
public class TaListenerController
extends BaseController {
    @Autowired
    private TaListenerService taListenerService;

    @RequestMapping(value={"goTaListenerMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTaListenerMain() {
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taListenerMain");
    }

    @RequestMapping(value={"goTaListenerForm"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTaListenerForm(TaListenerVo taListenerVo, HttpServletRequest request, HttpServletResponse response) {
        if (StringUtils.isNotBlank((CharSequence)taListenerVo.getId())) {
            TaListenerVo vo = this.taListenerService.getTaListener(taListenerVo, this.page);
            request.setAttribute("vo", (Object)vo);
        }
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/taListenerForm");
    }

    @RequestMapping(value={"goListenerListPage"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goListenerListPage(String typeId) {
        ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/processconf/listenerList");
        view.addObject("typeId", (Object)typeId);
        return view;
    }

    @RequestMapping(value={"findTaListenerGird"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findTaListenerGrid(HttpServletRequest request, TaListenerVo taListenerVo) {
        String pageStr = request.getParameter("page");
        this.page = StringUtils.isNotBlank((CharSequence)pageStr) ? new EuPage(request) : null;
        List<TaListenerVo> voList = this.taListenerService.findTaListenerList(taListenerVo, this.page);
        return new DataGrid(voList, this.page);
    }

    @RequestMapping(value={"findSelectedListenerList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findSelectedListenerList(String ids, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TaListenerVo> voList = this.taListenerService.findTaListenerList(ids, (Page)page);
        return new DataGrid(voList, page);
    }

    @RequestMapping(value={"saveTaListener"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveTaListener(TaListenerVo taListenerVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        this.taListenerService.saveTaListener(taListenerVo, page);
        return new AjaxJson();
    }

    @RequestMapping(value={"delListeren"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson delListeren(TaListenerVo taListenerVo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        TaListenerEntity te = this.taListenerService.get(TaListenerEntity.class, (Serializable)((Object)taListenerVo.getId()));
        if (te.getTaRProcessNodeListenerEntityList().size() == 0) {
            this.message = "\u76d1\u542c: " + te.getListenerName() + " \u5220\u9664\u6210\u529f";
            this.taListenerService.delete(te);
        } else {
            this.message = "\u76d1\u542c: " + te.getListenerName() + "\u5df2\u7ecf\u5728\u8fd0\u884c\u4e2d\u65e0\u6cd5\u5220\u9664";
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(value={"setTaListenerState"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson setTaListenerState(TaListenerVo taListenerVo) {
        AjaxJson j = new AjaxJson();
        String id = taListenerVo.getId();
        TaListenerEntity te = this.taListenerService.get(TaListenerEntity.class, (Serializable)((Object)id));
        if (te != null) {
            Short state = WorkFlowGlobals.LISTENER_YES.equals(te.getListenerState()) ? WorkFlowGlobals.LISTENER_NO : WorkFlowGlobals.LISTENER_YES;
            te.setListenerState(state);
            this.taListenerService.updateEntity(te);
            if (state.equals(WorkFlowGlobals.LISTENER_NO)) {
                j.setMsg("\u76d1\u542c\u5df2\u7981\u7528");
            } else {
                j.setMsg("\u76d1\u542c\u5df2\u542f\u7528");
            }
        }
        return j;
    }

    @RequestMapping(value={"validateName"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ValidForm validateName(TaListenerVo taListenerVo, HttpServletRequest request) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        if (StringUtil.isNotEmpty((String)taListenerVo.getId())) {
            SimpleExpression cr1 = Restrictions.eq((String)"listenerName", (Object)param);
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)taListenerVo.getId());
            List<TaListenerEntity> taListeners = this.taListenerService.findByCriteria(TaListenerEntity.class, new Criterion[]{cr1, cr2});
            if (!CollectionUtils.isEmpty(taListeners)) {
                validForm.setStatus("n");
                validForm.setInfo("\u76d1\u542c\u540d\u79f0\u5df2\u5b58\u5728");
            }
        } else {
            SimpleExpression cr3 = Restrictions.eq((String)"listenerName", (Object)param);
            List<TaListenerEntity> taListeners = this.taListenerService.findByCriteria(TaListenerEntity.class, new Criterion[]{cr3});
            if (!CollectionUtils.isEmpty(taListeners)) {
                validForm.setStatus("n");
                validForm.setInfo("\u76d1\u542c\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        return validForm;
    }
}

