/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.designer.processconf.controller;

import com.biz.eisp.activiti.designer.processconf.service.TaProcessDefinitionService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessDefinitionVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.core.web.BaseController;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.RepositoryService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taProcessDefinitionController"})
public class TaProcessDefinitionController
extends BaseController {
    @Autowired
    private TaProcessDefinitionService taProcessDefinitionService;
    @Autowired(required=false)
    private RepositoryService repositoryService;

    @RequestMapping(value={"goProcessDefinitionMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView deploymentListByProcesskey(String processKey, HttpServletRequest request) {
        if (StringUtils.isEmpty((String)processKey)) {
            throw new BusinessException("\u672a\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49Key");
        }
        request.setAttribute("processKey", (Object)processKey);
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/processdefinition/processDefinitionMain");
    }

    @RequestMapping(value={"findProcessDefinitionList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findProcessDefinitionList(TaProcessDefinitionVo taProcessDefinitionVo, HttpServletRequest request, HttpServletResponse response) {
        List<TaProcessDefinitionVo> voList = this.taProcessDefinitionService.findProcessDefinitionList(taProcessDefinitionVo, null);
        return new DataGrid(voList, null);
    }

    @RequestMapping(value={"setProcessState"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson setProcessState(String state, String processDefinitionId, HttpServletRequest request) {
        if (state.equals("active")) {
            this.repositoryService.activateProcessDefinitionById(processDefinitionId, true, null);
            return new AjaxJson("\u6d41\u7a0b\u5df2\u6fc0\u6d3b");
        }
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId, true, null);
        return new AjaxJson("\u6d41\u7a0b\u5df2\u6302\u8d77");
    }

    @RequestMapping(value={"goProcessDefinitionPicInfoForm"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goProcessDefinitionPicInfoForm(String diagramResourceName, String deploymentId, HttpServletRequest request) {
        request.setAttribute("diagramResourceName", (Object)diagramResourceName);
        request.setAttribute("deploymentId", (Object)deploymentId);
        return new ModelAndView("com/biz/eisp/activiti/designer/processconf/processdefinition/processDefinitionPicInfoForm");
    }

    @RequestMapping(value={"getProcessDefinitionPicInfo"}, method={RequestMethod.GET, RequestMethod.POST})
    public void getProcessDefinitionPicInfo(String diagramResourceName, String deploymentId, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            InputStream resourceAsStream = this.repositoryService.getResourceAsStream(deploymentId, diagramResourceName);
            byte[] b = new byte[1024];
            int len = -1;
            while ((len = resourceAsStream.read(b, 0, 1024)) != -1) {
                response.getOutputStream().write(b, 0, len);
            }
            response.getOutputStream().flush();
            response.getOutputStream().close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"deleteProcessDefinition"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson deleteProcessDefinition(TaProcessDefinitionVo taProcessDefinitionVo, HttpServletRequest request) {
        try {
            this.taProcessDefinitionService.deleteProcessDefinition(taProcessDefinitionVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson(e.getMessage());
        }
        return new AjaxJson();
    }
}

