/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.controller;

import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessBusinessObjConfigVo;
import com.biz.eisp.activiti.runtime.service.TaProcessInstanceService;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.MyInstanceVo;
import com.biz.eisp.activiti.runtime.vo.ProcessInstanceVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import java.io.InputStream;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taProcessInstanceController"})
public class TaProcessInstanceController
extends BaseController {
    @Autowired
    private TaProcessInstanceService taProcessInstanceService;

    @RequestMapping(value={"startBusinessProcess"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson startBusinessProcess(TaProcessBusinessObjConfigVo taProcessBusinessObjConfigVo, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson aj = new AjaxJson();
        try {
            this.taProcessInstanceService.saveStartWorkflow(taProcessBusinessObjConfigVo);
            aj.setSuccess(true);
            aj.setMsg("\u542f\u52a8\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            aj.setMsg("\u542f\u52a8\u4e1a\u52a1\u6d41\u7a0b\u5931\u8d25\uff1a" + e.getMessage());
        }
        return aj;
    }

    @RequestMapping(value={"goMyStartedProcessMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goMyStartedProcessList(HttpServletRequest request, HttpServletResponse response) {
        return new ModelAndView("com/biz/eisp/activiti/instance/myStartedProcessMain");
    }

    @RequestMapping(value={"goProcessInstanceMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goProcessInstanceMain(HttpServletRequest request, HttpServletResponse response) {
        return new ModelAndView("com/biz/eisp/activiti/instance/processInstanceMain");
    }

    @RequestMapping(value={"findMyStartedProcessList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findMyStartedProcessList(MyInstanceVo myInstanceVo, String time, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        TmPositionVo tmPositionVo = ResourceConfigUtils.getCurrPosition();
        myInstanceVo.setStartPositionCode(tmPositionVo.getPositionCode());
        myInstanceVo.setStartTime(time);
        List<MyInstanceVo> voList = this.taProcessInstanceService.findMyStartedProcessList(myInstanceVo, page);
        return new DataGrid(voList, page);
    }

    @RequestMapping(value={"findProcessInstanceList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findProcessInstanceList(ProcessInstanceVo processInstanceVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<ProcessInstanceVo> voList = this.taProcessInstanceService.findProcessInstanceList(processInstanceVo, page);
        return new DataGrid(voList, page);
    }

    @RequestMapping(value={"goProcessPicInfoForm"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goProcessPicInfoForm(String processInstanceId, HttpServletRequest request, HttpServletResponse respone, Model model) {
        request.setAttribute("processInstanceId", (Object)processInstanceId);
        return new ModelAndView("com/biz/eisp/activiti/instance/processPicInfoForm");
    }

    @RequestMapping(value={"getProcessPicInfo"}, method={RequestMethod.GET, RequestMethod.POST})
    public void getProcessPicInfo(HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setContentType("UTF-8");
        response.setCharacterEncoding("UTF-8");
        String processInstanceId = OConvertUtils.getString(request.getParameter("processInstanceId"));
        InputStream is = this.taProcessInstanceService.getProcessInstancePicInfo(processInstanceId);
        int len = 0;
        byte[] b = new byte[1024];
        while ((len = is.read(b, 0, 1024)) != -1) {
            response.getOutputStream().write(b, 0, len);
        }
    }

    @RequestMapping(value={"findProcessInstanceHistoryTaskList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findProcessInstanceHistoryTaskList(HistoryTaskVo historyTaskVo, HttpServletRequest request, HttpServletResponse response) {
        List<HistoryTaskVo> voList = this.taProcessInstanceService.findProcessInstanceHistoryTaskList(historyTaskVo, null);
        return new DataGrid(voList, null);
    }

    @RequestMapping(value={"deleteProcessInstance"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson deleteProcessInstance(MyInstanceVo myInstanceVo, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.taProcessInstanceService.deleteProcessInstance(myInstanceVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson(e.getMessage());
        }
        return new AjaxJson();
    }

    @RequestMapping(value={"callBackProcess"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson callBackProcess(MyInstanceVo myInstanceVo, HttpServletRequest request) {
        try {
            this.taProcessInstanceService.callBackProcess(myInstanceVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson(e.getMessage());
        }
        return new AjaxJson();
    }

    @RequestMapping(value={"closeProcessInstance"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson closeProcessInstance(MyInstanceVo myInstanceVo, HttpServletRequest request) {
        try {
            this.taProcessInstanceService.closeProcessInstance(myInstanceVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson(e.getMessage());
        }
        return new AjaxJson();
    }

    @RequestMapping(value={"suspend"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson suspend(MyInstanceVo myInstanceVo, HttpServletRequest request) {
        try {
            this.taProcessInstanceService.suspendProcessInstance(myInstanceVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson(e.getMessage());
        }
        return new AjaxJson();
    }

    @RequestMapping(value={"restart"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson restart(MyInstanceVo myInstanceVo, HttpServletRequest request) {
        try {
            this.taProcessInstanceService.activateProcessInstance(myInstanceVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson(e.getMessage());
        }
        return new AjaxJson();
    }
}

