/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.controller;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.runtime.entity.TaCommunicateContentEntity;
import com.biz.eisp.activiti.runtime.service.TaRejectRecordService;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.runtime.vo.CommentVo;
import com.biz.eisp.activiti.runtime.vo.HistoryTaskVo;
import com.biz.eisp.activiti.runtime.vo.MyTaskVo;
import com.biz.eisp.activiti.runtime.vo.OperationVo;
import com.biz.eisp.activiti.runtime.vo.TaRejectRecordVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.service.TtActAndAuditBillMainExtendService;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.utils.SysConfigUtils;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.activiti.engine.RepositoryService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/taTaskController"})
public class TaTaskController
extends BaseController {
    @Autowired(required=false)
    private RepositoryService repositoryService;
    @Autowired
    private TaTaskService taTaskService;
    @Autowired
    private TaRejectRecordService taRejectRecordService;
    @Autowired(required=false)
    private TtActAndAuditBillMainExtendService ttActAndAuditBillMainExtendService;
    @Autowired
    private TaProcessNodeService taProcessNodeService;
    @Autowired
    private SysConfigUtils sysConfigUtils;

    @RequestMapping(value={"goMyTaskMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goMyTaskMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/activiti/task/myTaskMain");
    }

    @RequestMapping(value={"findMyTaskList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findMyTaskList(MyTaskVo myTaskVo, String time, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        String positionCode = ResourceConfigUtils.getCurrPosition().getPositionCode();
        myTaskVo.setAssignee(positionCode);
        myTaskVo.setCreateTime(time);
        List<MyTaskVo> taskList = this.taTaskService.findMyTaskList(myTaskVo, page);
        return new DataGrid(taskList, page);
    }

    @RequestMapping(value={"goMyHistoryTaskMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goMyHistoryTaskMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/activiti/task/myHistoryTaskMain");
    }

    @RequestMapping(value={"findMyHistoryTaskList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findMyHistoryTaskList(HistoryTaskVo historyTaskVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        TmPositionVo tmPositionVo = ResourceConfigUtils.getCurrPosition();
        historyTaskVo.setAssignee(tmPositionVo.getPositionCode());
        List<HistoryTaskVo> taskList = this.taTaskService.findMyHistoryTaskList(historyTaskVo, page);
        return new DataGrid(taskList, page);
    }

    @RequestMapping(value={"findMyRejectTaskList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findMyRejectTaskList(TaRejectRecordVo taRejectRecordVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        TmPositionVo tmPositionVo = ResourceConfigUtils.getCurrPosition();
        if (StringUtils.isBlank((CharSequence)tmPositionVo.getPositionCode())) {
            String sql = "select * from ta_reject_record t where t.id = '-1'";
            List<TaRejectRecordVo> bySql = this.taRejectRecordService.findBySql(TaRejectRecordVo.class, sql, page, new Object[0]);
            return new DataGrid(bySql, page);
        }
        taRejectRecordVo.setAssignee(tmPositionVo.getPositionCode());
        List<TaRejectRecordVo> voList = this.taRejectRecordService.findMyRejectTaskList(taRejectRecordVo, page);
        return new DataGrid(voList, page);
    }

    @RequestMapping(value={"goInstanceHandleTabForm"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goInstanceHandleTabForm(MyTaskVo myTaskVo, @RequestParam(value="isView") boolean isView, @RequestParam(value="isReadFlag") boolean isReadFlag, String recordId, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        String processInstanceId = myTaskVo.getProcessInstanceId();
        String isCommunicate = myTaskVo.getIsCommunicate();
        String id = myTaskVo.getId();
        request.setAttribute("taskId", (Object)taskId);
        request.setAttribute("processInstanceId", (Object)processInstanceId);
        request.setAttribute("isView", (Object)isView);
        request.setAttribute("isReadFlag", (Object)isReadFlag);
        request.setAttribute("recordId", (Object)recordId);
        request.setAttribute("isCommunicate", (Object)isCommunicate);
        request.setAttribute("id", (Object)id);
        return new ModelAndView("com/biz/eisp/activiti/task/taskHandleTabForm");
    }

    @RequestMapping(value={"goTaskBusinessForm"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTaskBusinessForm(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        String modelAndView = null;
        modelAndView = StringUtils.isBlank((CharSequence)taskId) ? this.taTaskService.getProcessInstanceBusinessForm(myTaskVo.getProcessInstanceId()) : this.taTaskService.getTaskBusinessForm(taskId);
        request.setAttribute(WorkFlowGlobals.PROCNODE_START, (Object)modelAndView);
        return new ModelAndView("com/biz/eisp/activiti/task/taskBusinessForm");
    }

    @RequestMapping(value={"goTaskOperateForm"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTaskOperateForm(MyTaskVo myTaskVo, @RequestParam(value="isView") boolean isView, @RequestParam(value="isReadFlag") boolean isReadFlag, String recordId, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        String processInstanceId = myTaskVo.getProcessInstanceId();
        if (StringUtils.isBlank((CharSequence)processInstanceId)) {
            throw new BusinessException("\u6d41\u7a0b\u5b9e\u4f8bID\u4e22\u5931");
        }
        List<CommentVo> list = this.taTaskService.findActHiCommentEntity(processInstanceId);
        if (!isView) {
            boolean hasRejectNodes = this.taTaskService.hasRejectNodes(taskId, processInstanceId);
            request.setAttribute("hasRejectNodes", (Object)hasRejectNodes);
            request.setAttribute("isView", (Object)isView);
        }
        request.setAttribute("taskId", (Object)taskId);
        request.setAttribute("processInstanceId", (Object)processInstanceId);
        request.setAttribute("voList", list);
        request.setAttribute("isReadFlag", (Object)isReadFlag);
        request.setAttribute("recordId", (Object)recordId);
        return new ModelAndView("com/biz/eisp/activiti/task/taskOperateForm");
    }

    @RequestMapping(value={"saveComplete"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveComplete(OperationVo operationVo, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.taTaskService.saveCompelte(operationVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            AjaxJson aj = new AjaxJson("\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            aj.setSuccess(false);
            return aj;
        }
        return new AjaxJson();
    }

    @RequestMapping(value={"saveReject"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveReject(OperationVo operationVo, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.taTaskService.saveReject(operationVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson("\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
        return new AjaxJson();
    }

    @RequestMapping(value={"saveRejectToApply"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveRejectToApply(OperationVo operationVo, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.taTaskService.saveRejectToApply(operationVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson("\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
        return new AjaxJson();
    }

    @RequestMapping(value={"saveReadRejectStatus"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveReadRejectStatus(String recordId, HttpServletRequest request, HttpServletResponse response) {
        try {
            this.taRejectRecordService.updateTaRejectRecordStatus(recordId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson("\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
        }
        return new AjaxJson();
    }

    @RequestMapping(value={"goReassignForm"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goReassignForm(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        request.setAttribute("taskId", (Object)taskId);
        return new ModelAndView("com/biz/eisp/activiti/task/reassignForm");
    }

    @RequestMapping(value={"reassign"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson reassign(MyTaskVo myTaskVo, String reassignComment, HttpServletRequest request, HttpServletResponse response) {
        try {
            String reassignPositionCode = request.getParameter("id");
            this.taTaskService.reassign(myTaskVo, reassignComment, reassignPositionCode);
            return new AjaxJson();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson(e.getMessage());
        }
    }

    @RequestMapping(value={"goPositionList"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goPositionList(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        request.setAttribute("taskId", (Object)taskId);
        return new ModelAndView("com/biz/eisp/activiti/task/positionList");
    }

    @RequestMapping(value={"goTaskAbstractForm"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTaskAbstractForm(MyTaskVo myTaskVo, HttpServletRequest request) {
        this.taTaskService.findProcessBasicInfoByProcinstId(myTaskVo, request);
        this.taTaskService.findAttachmentListByProcinstId(myTaskVo.getProcessInstanceId(), request);
        return new ModelAndView("com/biz/eisp/activiti/task/taskAbstractForm");
    }

    @RequestMapping(value={"goTaskDetailForm"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTaskDetailForm(MyTaskVo myTaskVo, HttpServletRequest request, @RequestParam(value="isView") boolean isView) {
        request.setAttribute("taskId", (Object)myTaskVo.getTaskId());
        request.setAttribute("processInstanceId", (Object)myTaskVo.getProcessInstanceId());
        request.setAttribute("businessKey", (Object)this.taTaskService.getBusinessFormByProcessInstanceId(myTaskVo.getProcessInstanceId()).getBusinessObjId());
        request.setAttribute("currPositionCode", (Object)ResourceConfigUtils.getCurrPosition().getPositionCode());
        request.setAttribute("isReadFlag", (Object)request.getParameter("isReadFlag"));
        if ("Y".equals(myTaskVo.getIsCommunicate())) {
            isView = true;
            TaCommunicateContentEntity communicateEntity = this.taTaskService.get(TaCommunicateContentEntity.class, (Serializable)((Object)myTaskVo.getId()));
            request.setAttribute("communicateContent", (Object)communicateEntity.getContent());
            request.setAttribute("communicateId", (Object)communicateEntity.getId());
        }
        request.setAttribute("isView", (Object)isView);
        request.setAttribute("isCommunicate", (Object)myTaskVo.getIsCommunicate());
        boolean extendServiceFlag = true;
        if (StringUtil.isEmpty(this.ttActAndAuditBillMainExtendService)) {
            extendServiceFlag = false;
        }
        request.setAttribute("extendServiceFlag", (Object)extendServiceFlag);
        if (!isView) {
            boolean hasRejectNodes = this.taTaskService.hasRejectNodes(myTaskVo.getTaskId(), myTaskVo.getProcessInstanceId());
            request.setAttribute("hasRejectNodes", (Object)hasRejectNodes);
            this.taTaskService.findRejectNode(myTaskVo.getTaskId(), myTaskVo.getProcessInstanceId(), request);
        }
        this.setKeyIndicators(myTaskVo, request);
        this.taTaskService.findApprovalLogs(myTaskVo, request);
        this.taTaskService.findProcessBasicInfoByProcinstId(myTaskVo, request);
        this.taTaskService.findAttachmentListByProcinstId(myTaskVo.getProcessInstanceId(), request);
        request.setAttribute("hiddenAttachment", (Object)this.sysConfigUtils.getHiddenAttachment());
        String showHideButtom = this.sysConfigUtils.getShowHideButtom();
        request.setAttribute("showHideButtom", (Object)(showHideButtom == null ? "N" : showHideButtom));
        this.taTaskService.setNodeAuth(myTaskVo, request);
        return new ModelAndView("com/biz/eisp/activiti/task/taskDetailForm");
    }

    private void setKeyIndicators(MyTaskVo myTaskVo, HttpServletRequest request) {
        String taskId = myTaskVo.getTaskId();
        String modelAndView = null;
        modelAndView = StringUtils.isBlank((CharSequence)taskId) ? this.taTaskService.getProcessInstanceBusinessForm(myTaskVo.getProcessInstanceId()) : this.taTaskService.getTaskBusinessForm(taskId);
        if (modelAndView != null) {
            modelAndView = modelAndView + "&isKeyIndicators=true";
        }
        request.setAttribute(WorkFlowGlobals.PROCNODE_START, (Object)modelAndView);
    }
}

