/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjQueryEntity;
import com.biz.eisp.activiti.runtime.entity.TaCommunicateContentEntity;
import com.biz.eisp.activiti.runtime.entity.TaCommunicateEntity;
import com.biz.eisp.activiti.runtime.entity.TaProcessApprovalLogEntity;
import com.biz.eisp.activiti.runtime.service.TaCommunicateService;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import java.io.Serializable;
import java.util.Date;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taCommunicateService")
@Transactional
public class TaCommunicateServiceImpl
extends BaseServiceImpl
implements TaCommunicateService {
    @Autowired
    private TaskService taskService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;

    @Override
    public ValidForm saveCommunicate(String taskId, String codes, String names, String fullNames, String content, String forceReplyFlag) {
        ValidForm validForm = new ValidForm();
        validForm.setStatus("Y");
        validForm.setInfo("\u9a8c\u8bc1\u901a\u8fc7");
        boolean flag = this.validateValues(taskId, codes, names, content);
        if (flag) {
            String[] code = codes.split(",");
            String[] name = names.split(",");
            String[] fullName = fullNames.split(",");
            Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
            ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();
            String piId = task.getProcessInstanceId();
            ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(piId).singleResult();
            String businessKey = processInstance.getBusinessKey();
            TaBaseBusinessObjQueryEntity businessObjEntity = this.get(TaBaseBusinessObjQueryEntity.class, (Serializable)((Object)businessKey));
            TmPositionEntity tmPosition = businessObjEntity.getTmPositionEntity();
            TaCommunicateEntity communicateEntity = new TaCommunicateEntity();
            communicateEntity.setBusinessKey(businessKey);
            communicateEntity.setProcessInstanceId(piId);
            communicateEntity.setProcessName(processDefinition.getName());
            communicateEntity.setProcessKey(processDefinition.getKey());
            communicateEntity.setProcessTitle(businessObjEntity.getProcessTitle());
            communicateEntity.setLaunchCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
            communicateEntity.setLaunchName(ResourceConfigUtils.getCreateName());
            communicateEntity.setCreateProcessPositionCode(tmPosition.getPositionCode());
            communicateEntity.setCreateProcessPositionName(tmPosition.getPositionName());
            communicateEntity.setProcessNodeKey(task.getTaskDefinitionKey());
            communicateEntity.setTaskId(task.getId());
            communicateEntity.setTaskName(task.getName());
            super.save(communicateEntity);
            for (int i = 0; i < code.length; ++i) {
                TaCommunicateContentEntity communicateContentEntity = new TaCommunicateContentEntity();
                communicateContentEntity.setTaCommunicateId(communicateEntity.getId());
                communicateContentEntity.setContent(content);
                communicateContentEntity.setCirculationCode(code[i]);
                communicateContentEntity.setCirculationName(fullName[i] + "(" + name[i] + ")");
                communicateContentEntity.setViewStatus("0");
                communicateContentEntity.setReadStatus("0");
                communicateContentEntity.setIsReply("0");
                if ("Y".equals(forceReplyFlag)) {
                    communicateContentEntity.setForceReplyFlag("Y");
                } else {
                    communicateContentEntity.setForceReplyFlag("N");
                }
                this.save(communicateContentEntity);
                this.saveApproveLog(piId, task.getTaskDefinitionKey(), content, name[i], fullName[i]);
            }
        } else {
            validForm.setStatus("N");
            validForm.setInfo("\u6c9f\u901a\u6570\u636e\u9a8c\u8bc1\u4e0d\u901a\u8fc7\uff0c\u8bf7\u68c0\u67e5");
        }
        return validForm;
    }

    @Override
    public ValidForm saveSureCommunicate(String communicateId, String content) {
        ValidForm validForm = new ValidForm();
        validForm.setStatus("Y");
        validForm.setInfo("\u9a8c\u8bc1\u901a\u8fc7");
        TaCommunicateContentEntity communicateContentEntity = this.get(TaCommunicateContentEntity.class, (Serializable)((Object)communicateId));
        communicateContentEntity.setIsReply("1");
        communicateContentEntity.setReciveContent(content);
        communicateContentEntity.setForceReplyFlag("N");
        this.updateEntity(communicateContentEntity);
        TaCommunicateEntity communicateEntity = this.get(TaCommunicateEntity.class, (Serializable)((Object)communicateContentEntity.getTaCommunicateId()));
        this.saveReplyApproveLog(communicateEntity.getProcessInstanceId(), communicateEntity.getProcessNodeKey(), content);
        return validForm;
    }

    private void saveApproveLog(String processInstanceId, String taskDefinitionKey, String content, String positionName, String fullName) {
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        TmUserVo user = ResourceConfigUtils.getSessionTmUserVo();
        log.setCreateDate(new Date());
        log.setAccount(user.getUserName());
        log.setContent("\u3010" + positionName + " " + fullName + "\u3011" + content);
        log.setName(user.getFullName());
        log.setProcessInstId(processInstanceId);
        try {
            log.setTaskDefKey(taskDefinitionKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.setType(3);
        this.save(log);
    }

    private void saveReplyApproveLog(String processInstanceId, String taskDefinitionKey, String content) {
        TaProcessApprovalLogEntity log = new TaProcessApprovalLogEntity();
        TmUserVo user = ResourceConfigUtils.getSessionTmUserVo();
        log.setCreateDate(new Date());
        log.setAccount(user.getUserName());
        log.setContent(content);
        log.setName(user.getFullName());
        log.setProcessInstId(processInstanceId);
        try {
            log.setTaskDefKey(taskDefinitionKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.setType(3);
        this.save(log);
    }

    private boolean validateValues(String ... strs) {
        for (int i = 0; i < strs.length; ++i) {
            if (StringUtils.isNotBlank((CharSequence)strs[i])) continue;
            return false;
        }
        return true;
    }
}

