/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.service.impl;

import com.biz.eisp.activiti.runtime.dao.TaCarbonCopyDao;
import com.biz.eisp.activiti.runtime.dao.TaTaskDao;
import com.biz.eisp.activiti.runtime.entity.TaCirculationContentEntity;
import com.biz.eisp.activiti.runtime.service.TaHandCopyAndCirculationService;
import com.biz.eisp.activiti.runtime.vo.BusinessFormVo;
import com.biz.eisp.activiti.runtime.vo.TaCopyCirculationVo;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taHandCopyAndCirculationService")
@Transactional
public class TaHandCopyAndCirculationServiceImpl
extends BaseServiceImpl
implements TaHandCopyAndCirculationService {
    @Autowired
    private TaTaskDao taTaskDao;
    @Autowired
    private TaCarbonCopyDao taCarbonCopyDao;

    @Override
    public String getCopyAndCirculationBusinessForm(String piId, String businessKey) {
        BusinessFormVo vo = this.taTaskDao.getBusinessFormByProcessInstanceId(piId);
        try {
            String view = vo.getModelandview();
            String objId = vo.getBusinessObjId();
            String modelandview = view + "&businessObjId=" + objId;
            return modelandview;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void updateCarbonOrCirculationState(TaCopyCirculationVo vo) {
        String sql = null;
        if ("0".equals(vo.getType())) {
            sql = "update ta_copy t set t.view_status = 1 where id = ?";
            this.executeSql(sql, vo.getContentId());
        } else if ("1".equals(vo.getType())) {
            String positionCode = ResourceConfigUtils.getCurrPosition().getPositionCode();
            if ("1".equals(vo.getInOutType())) {
                sql = "update ta_circulation_content t set t.read_status = '0' where id = ?";
                this.executeSql(sql, vo.getContentId());
            } else if ("0".equals(vo.getInOutType())) {
                sql = "update ta_circulation_content t set t.view_status = '1' where id = ? and circulation_code = ?";
                this.executeSql(sql, vo.getContentId(), positionCode);
            }
        } else {
            throw new BusinessException("\u5bf9\u4e0d\u8d77\uff0c\u4f60\u67e5\u9605\u7684\u6570\u636e\u6709\u8bef");
        }
    }

    @Override
    public void saveCirculationContent(String id, String content) {
        String hql = "from TaCirculationContentEntity where taCirculationId = ? and circulationCode = ?";
        List list = this.findByHql(hql, id, ResourceConfigUtils.getCurrPosition().getPositionCode());
        try {
            for (TaCirculationContentEntity entity : list) {
                entity.setReciveContent(content);
                entity.setReadStatus("1");
                entity.setIsReply("1");
                entity.setViewStatus("1");
                this.saveOrUpdate(entity);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u4f60\u5df2\u8d85\u8fc7\u6700\u5927\u9650\u5236\u5b57\u6570,\u6700\u5927\u5b57\u6570:250");
        }
    }

    @Override
    public List<TaCopyCirculationVo> findCirculationMessage(TaCopyCirculationVo query) {
        List<TaCopyCirculationVo> result = this.taCarbonCopyDao.findCirculationById(query);
        return result;
    }
}

