/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.runtime.util;

import com.biz.eisp.activiti.runtime.entity.TaBaseBusinessObjEntity;
import com.biz.eisp.activiti.runtime.entity.TaRuntimeStatusEntity;
import com.biz.eisp.activiti.runtime.service.TaTaskService;
import com.biz.eisp.activiti.util.CommentUtil;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;

public class RejectTaskUtil {
    private List<String> list = new ArrayList<String>();
    private HistoryService historyService;
    private RepositoryService repositoryService;
    private RuntimeService runtimeService;
    private TaskService taskService;
    private TaTaskService taTaskService;

    public RejectTaskUtil() {
        this.list.clear();
        this.historyService = (HistoryService)ApplicationContextUtils.getContext().getBean("historyService");
        this.repositoryService = (RepositoryService)ApplicationContextUtils.getContext().getBean("repositoryService");
        this.runtimeService = (RuntimeService)ApplicationContextUtils.getContext().getBean("runtimeService");
        this.taskService = (TaskService)ApplicationContextUtils.getContext().getBean("taskService");
        this.taTaskService = (TaTaskService)ApplicationContextUtils.getContext().getBean("taTaskService");
    }

    public boolean rollBackFirst(String taskId, String firstNodeId, String comment) throws Exception {
        HistoricTaskInstance currTask = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).singleResult();
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).singleResult();
        Map variables = instance.getProcessVariables();
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(currTask.getProcessDefinitionId());
        ActivityImpl currActivity = definition.findActivity(currTask.getTaskDefinitionKey());
        ArrayList<PvmTransition> oriPvmTransitionList = new ArrayList<PvmTransition>();
        List pvmTransitionList = currActivity.getOutgoingTransitions();
        for (PvmTransition pvmTransition : pvmTransitionList) {
            oriPvmTransitionList.add(pvmTransition);
        }
        pvmTransitionList.clear();
        ArrayList<TransitionImpl> newTransitions = new ArrayList<TransitionImpl>();
        ActivityImpl nextActivityImpl = definition.findActivity(firstNodeId);
        TransitionImpl newTransition = currActivity.createOutgoingTransition();
        newTransition.setDestination(nextActivityImpl);
        newTransitions.add(newTransition);
        List tasks = this.taskService.createTaskQuery().processInstanceId(instance.getId()).taskDefinitionKey(currTask.getTaskDefinitionKey()).list();
        for (Task task : tasks) {
            this.taskService.addComment(task.getId(), instance.getId(), CommentUtil.buildRejectApplyComment(task.getName(), ResourceConfigUtils.getCreateName(), comment));
            this.taskService.complete(task.getId(), variables);
        }
        for (TransitionImpl transitionImpl : newTransitions) {
            currActivity.getOutgoingTransitions().remove(transitionImpl);
        }
        for (PvmTransition pvmTransition : oriPvmTransitionList) {
            pvmTransitionList.add(pvmTransition);
        }
        this.updateBusinessEntity(instance);
        return true;
    }

    private void updateBusinessEntity(ProcessInstance instance) {
        TaBaseBusinessObjEntity taBaseBusinessObjEntity = this.taTaskService.get(TaBaseBusinessObjEntity.class, (Serializable)((Object)instance.getBusinessKey()));
        TaRuntimeStatusEntity taRuntimeStatusEntity = this.taTaskService.findUniqueByProperty(TaRuntimeStatusEntity.class, "code", "reject");
        taBaseBusinessObjEntity.setTaRuntimeStatusEntity(taRuntimeStatusEntity);
        this.taTaskService.updateEntity(taBaseBusinessObjEntity);
    }

    public boolean rollBackAbove(String taskId, String target, String comment) throws Exception {
        HistoricTaskInstance currTask = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId).singleResult();
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).singleResult();
        if (instance == null) {
            return false;
        }
        Map variables = instance.getProcessVariables();
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(currTask.getProcessDefinitionId());
        if (definition == null) {
            return false;
        }
        ActivityImpl currActivity = definition.findActivity(currTask.getTaskDefinitionKey());
        ArrayList<PvmTransition> oriPvmTransitionList = new ArrayList<PvmTransition>();
        List pvmTransitionList = currActivity.getOutgoingTransitions();
        for (PvmTransition pvmTransition : pvmTransitionList) {
            oriPvmTransitionList.add(pvmTransition);
        }
        pvmTransitionList.clear();
        ArrayList<TransitionImpl> newTransitions = new ArrayList<TransitionImpl>();
        List<String> newTT = this.getAllAboveNode(currActivity.getId(), definition);
        for (String str : newTT) {
            if (!str.equals(target)) continue;
            ActivityImpl nextActivityImpl = definition.findActivity(target);
            TransitionImpl newTransition = currActivity.createOutgoingTransition();
            newTransition.setDestination(nextActivityImpl);
            newTransitions.add(newTransition);
            break;
        }
        List tasks = this.taskService.createTaskQuery().processInstanceId(instance.getId()).taskDefinitionKey(currTask.getTaskDefinitionKey()).list();
        for (Task task : tasks) {
            this.taskService.addComment(task.getId(), instance.getId(), CommentUtil.buildRejectPreComment(task.getName(), ResourceConfigUtils.getCreateName(), comment));
            this.taskService.complete(task.getId(), variables);
        }
        for (TransitionImpl transitionImpl : newTransitions) {
            currActivity.getOutgoingTransitions().remove(transitionImpl);
        }
        for (PvmTransition pvmTransition : oriPvmTransitionList) {
            pvmTransitionList.add(pvmTransition);
        }
        return true;
    }

    public String getFirstNodeName(String taskId) throws Exception {
        String result = null;
        Task task = (Task)this.taskService.createTaskQuery().taskId(taskId).singleResult();
        String pdId = task.getProcessDefinitionId();
        ProcessDefinition pd = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(pdId).singleResult();
        InputStream is = this.repositoryService.getProcessModel(pd.getId());
        XMLStreamReader xtr = XMLInputFactory.newInstance().createXMLStreamReader(is);
        BpmnModel model = new BpmnXMLConverter().convertToBpmnModel(xtr);
        Collection elements = model.getMainProcess().getFlowElements();
        for (FlowElement fe : elements) {
            if (!(fe instanceof StartEvent)) continue;
            List flows = ((StartEvent)fe).getOutgoingFlows();
            for (SequenceFlow s : flows) {
                result = s.getTargetRef();
            }
        }
        return result;
    }

    private List<String> getAllAboveNode(String actId, ProcessDefinitionEntity definition) {
        ArrayList<String> list = new ArrayList<String>();
        ActivityImpl nowActivityNode = definition.findActivity(actId);
        List incomingTransitions = nowActivityNode.getIncomingTransitions();
        for (PvmTransition p : incomingTransitions) {
            String aboveActId = p.getSource().getId();
            ActivityImpl aboveNode = definition.findActivity(aboveActId);
            String aboveNodeType = (String)aboveNode.getProperties().get("type");
            if (!aboveNodeType.equals("exclusiveGateway") && !aboveNodeType.equals("startEvent")) {
                list.add(aboveNode.getId());
                continue;
            }
            this.getAllAboveNode(aboveNode.getId(), definition);
        }
        return list;
    }
}

