/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.activiti.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static Logger logger = LoggerFactory.getLogger(DateUtils.class);
    public static final long ONE_DAY_MILLISECONDS = 86400000L;
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm";
    public static final String DEFAULT_DAY_PATTERN = "yyyy-MM-dd";
    public static final String DEFAULT_MONTH_PATTERN = "yyyy\u5e74MM\u6708";
    public static final String DEFAULT_MONTH_NO_CH_PATTERN = "yyyyMM";
    public static final String DEFAULT_TIME_PATTERN = "HH:mm";
    public static final String DEFAULT_DATE_ALL_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_TIME_ALL_PATTERN = "HH:mm:ss";
    public static final String DEFAULT_DATE_TIME_PATTERN = "yyyyMMddHHmmss";

    public static Date parseDate(String str, String pattern) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        Date dt = null;
        SimpleDateFormat dtFmt = new SimpleDateFormat(pattern, Locale.US);
        try {
            new Date();
            dt = new Date(dtFmt.parse(str).getTime());
        }
        catch (Exception ex) {
            logger.error("Parser Exception: Invalid Date or pattern!");
        }
        return dt;
    }

    public static String getDefaultFormatDateStr(Date date) {
        return DateUtils.getFormatDateStr(date, DEFAULT_TIME_ALL_PATTERN);
    }

    public static String getFormatDateStr(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dtFmt = new SimpleDateFormat(pattern, Locale.US);
        return dtFmt.format(date);
    }

    public static Calendar getOffsetDateForGivenDate(Date givenDate, int offset) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(givenDate);
        cal.add(5, offset);
        return cal;
    }

    public static Calendar getOffsetMinuteForGivenDate(Date givenDate, int offset) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(givenDate);
        cal.add(12, offset);
        return cal;
    }

    public static String getWeekDay(Date time) {
        String[] weekDays = new String[]{"\u5468\u65e5", "\u5468\u4e00", "\u5468\u4e8c", "\u5468\u4e09", "\u5468\u56db", "\u5468\u4e94", "\u5468\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static long convertTimeStamp(Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime() / 1000L;
    }

    public static Date convertDate(long millSec) {
        return new Date(millSec * 1000L);
    }

    public static int getDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static String convertDateStr(long millSec) {
        SimpleDateFormat fmtDateTime = new SimpleDateFormat(DEFAULT_DAY_PATTERN);
        return fmtDateTime.format(new Date(millSec * 1000L));
    }

    public static Date extractionDate(long millSec) {
        Date in = new Date(millSec * 1000L);
        SimpleDateFormat fmtDateTime = new SimpleDateFormat(DEFAULT_DAY_PATTERN);
        String text = fmtDateTime.format(in);
        ParsePosition pos = new ParsePosition(0);
        return ((DateFormat)fmtDateTime).parse(text, pos);
    }

    public static int[] monthToYear(int month) {
        int[] ret = new int[]{0, 0};
        ret[0] = month / 12;
        if (month % 12 != 0) {
            ret[1] = month % 12;
        }
        return ret;
    }

    public static String monthToYearStr(int month) {
        int[] ret = DateUtils.monthToYear(month);
        String str = ret[0] + "\u5c81";
        if (ret[0] <= 5 && ret[1] != 0) {
            str = str + ret[1] + "\u4e2a\u6708";
        }
        return str;
    }

    public static String getDateStrByFormat(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dtFmt = new SimpleDateFormat(format);
        return dtFmt.format(date);
    }

    public static boolean isSameDate(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        boolean isSameYear = cal1.get(1) == cal2.get(1);
        boolean isSameMonth = isSameYear && cal1.get(2) == cal2.get(2);
        boolean isSameDate = isSameMonth && cal1.get(5) == cal2.get(5);
        return isSameDate;
    }

    public static boolean isSameDay(Date date1, Date date2) {
        long between = Math.abs(date2.getTime() - date1.getTime());
        if (between > 86400000L) {
            return false;
        }
        if (between == 86400000L) {
            Calendar cal1 = Calendar.getInstance();
            cal1.setTime(date1);
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(date2);
            if (cal1.get(11) == 0 && cal2.get(11) == 0) {
                return true;
            }
            return cal1.get(11) == 24 && cal2.get(11) == 24;
        }
        return true;
    }

    public static Date getDateByFormat(String date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dtFmt = new SimpleDateFormat(format);
        Date dateTime = null;
        try {
            dateTime = dtFmt.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return dateTime;
    }

    public static long getDistanceDay(long date1, long date2) {
        long newDate2;
        String dateStr1 = DateUtils.getDateStrByFormat(new Date(date1 * 1000L), DEFAULT_DAY_PATTERN);
        String dateStr2 = DateUtils.getDateStrByFormat(new Date(date2 * 1000L), DEFAULT_DAY_PATTERN);
        Date date3 = DateUtils.getDateByFormat(dateStr1, DEFAULT_DAY_PATTERN);
        Date date4 = DateUtils.getDateByFormat(dateStr2, DEFAULT_DAY_PATTERN);
        long newDate1 = DateUtils.convertTimeStamp(date3);
        long diff = newDate1 >= (newDate2 = DateUtils.convertTimeStamp(date4)) ? newDate1 - newDate2 : newDate2 - newDate1;
        return diff / 86400L;
    }

    public static int getDistanceSecond(long date1, long date2) {
        long diff = date1 - date2;
        double diffDouble = diff / 1000L;
        return (int)diffDouble;
    }

    public static Integer getAge(Date birthday) {
        if (birthday == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int yearNow = calendar.get(1);
        calendar.setTime(birthday);
        int yearBirth = calendar.get(1);
        if (yearNow - yearBirth < 0) {
            return null;
        }
        return yearNow - yearBirth;
    }

    public static int getDayCount(Date startDate, Date endDate) {
        if (!startDate.before(endDate)) {
            return 0;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        int startDayCount = (int)calendar.getTimeInMillis() / 86400000;
        calendar.setTime(endDate);
        int endDayCount = (int)calendar.getTimeInMillis() / 86400000;
        return endDayCount - startDayCount;
    }

    public static String getWeekDayStr(Integer weekDay) {
        String str = "\u5468";
        switch (weekDay) {
            case 1: {
                str = str + "\u4e00";
                break;
            }
            case 2: {
                str = str + "\u4e8c";
                break;
            }
            case 3: {
                str = str + "\u4e09";
                break;
            }
            case 4: {
                str = str + "\u56db";
                break;
            }
            case 5: {
                str = str + "\u4e94";
                break;
            }
            case 6: {
                str = str + "\u516d";
                break;
            }
            case 7: {
                str = str + "\u65e5";
            }
        }
        return str;
    }

    public static String getDayTypeStr(Integer dayType) {
        String str = "";
        switch (dayType) {
            case 1: {
                str = str + "\u4e0a\u5348";
                break;
            }
            case 2: {
                str = str + "\u4e0b\u5348";
                break;
            }
            case 3: {
                str = str + "\u665a\u4e0a";
            }
        }
        return str;
    }

    public static boolean isToday(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int startDayCount = (int)calendar.getTimeInMillis() / 86400000;
        calendar.setTime(date);
        int endDayCount = (int)calendar.getTimeInMillis() / 86400000;
        return endDayCount == startDayCount;
    }

    public static Date getDayByDateDistance(Date date, int distanceDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, distanceDay);
        Date lastDay = calendar.getTime();
        return lastDay;
    }

    public static Date getTimeByTimeAndDiffSecond(Date date, int second) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(13, second);
        Date lastDay = calendar.getTime();
        return lastDay;
    }

    public static int getCurrentTime() {
        return Long.valueOf(new Date().getTime() / 1000L).intValue();
    }

    public static String getDateStrByTimeInt(Integer time) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        Long timeLong = Long.parseLong(time + "");
        Date dt = new Date(timeLong * 1000L);
        String sDateTime = sdf.format(dt);
        return sDateTime.toString();
    }

    public static Date increaseDate(Date time, int unit, int value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        calendar.set(unit, calendar.get(unit) + value);
        return calendar.getTime();
    }

    public static Date increaseDate(Date time, int value) {
        return DateUtils.increaseDate(time, 12, value);
    }

    public static boolean isOverlap(Date dt1Start, Date dt1End, Date dt2Start, Date dt2End) {
        if (dt1Start == null || dt1End == null || dt2Start == null || dt2End == null) {
            throw new IllegalArgumentException("param error");
        }
        long dt1StartLong = dt1Start.getTime();
        long dt1EndLong = dt1End.getTime();
        long dt2StartLong = dt2Start.getTime();
        long dt2EndLong = dt2End.getTime();
        if (dt1StartLong >= dt1EndLong) {
            throw new IllegalArgumentException("param error,param1 must before param2");
        }
        if (dt2StartLong >= dt2EndLong) {
            throw new IllegalArgumentException("param error,param3 must before param4");
        }
        if (dt1EndLong <= dt2StartLong) {
            return false;
        }
        return dt1StartLong < dt2EndLong;
    }

    public static boolean isDateBetween(Date start, Date end, Date paramDate) {
        if (start == null || end == null || paramDate == null) {
            throw new IllegalArgumentException("param error");
        }
        long startLong = start.getTime();
        long endLong = end.getTime();
        long paramLong = paramDate.getTime();
        if (paramLong < startLong) {
            return false;
        }
        return paramLong <= endLong;
    }

    public static boolean equalIsDateMoreThanAnother(Date date1, Date date2) {
        return date1.getTime() >= date2.getTime();
    }

    public static boolean isDateExpired(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getTime().before(new Date());
    }

    public static Date getTodayStartTime(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        return c.getTime();
    }

    public static Date getTodayEndTime(Date date) {
        if (date == null) {
            date = new Date();
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        return c.getTime();
    }
}

