/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.tag.bean.ComboTreeModel;
import com.biz.eisp.base.common.tag.util.oConvertUtils;
import com.biz.eisp.base.common.util.ReflectHelper;
import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import com.biz.eisp.base.core.redis.util.RedisUtils;
import com.biz.eisp.base.utils.DBConfigUtil;
import com.biz.eisp.mdm.org.util.TmOrgTreeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ComboxTreeUtil
implements Serializable {
    private static DBConfigUtil dbConfigUtil;
    private static final long serialVersionUID = 1L;
    public static final HashMap<String, Long> versionMap;
    public static ConcurrentHashMap<String, List<ComboTree>> currMap;

    @Autowired
    public static void setDbConfigUtil(DBConfigUtil dbConfigUtil) {
        ComboxTreeUtil.dbConfigUtil = dbConfigUtil;
    }

    public static List<ComboTree> getComboTrees() {
        IRedisCacheService redisCacheService = RedisUtils.getIRedisCacheService();
        if (redisCacheService != null) {
            Long now = redisCacheService.incrBy(dbConfigUtil.getJdbcUserName() + "_orgTree_version", 0L);
            Long old = versionMap.get(dbConfigUtil.getJdbcUserName() + "_orgTree_version");
            if (now.intValue() != old.intValue()) {
                versionMap.put(dbConfigUtil.getJdbcUserName() + "_orgTree_version", now);
                try {
                    List<ComboTree> orgVos = redisCacheService.getMapValues(dbConfigUtil.getJdbcUserName() + "_orgTree", ComboTree.class);
                    currMap.put(dbConfigUtil.getJdbcUserName() + "_orgTree", TmOrgTreeUtil.buildTree(orgVos));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        List<ComboTree> comboTrees = currMap.get(dbConfigUtil.getJdbcUserName() + "_orgTree");
        return comboTrees;
    }

    public static List<ComboTree> getComboxByObj(List<ComboTree> comboTrees, ComboTreeModel comboTreeModel, Object obj) {
        ArrayList<ComboTree> trees = new ArrayList<ComboTree>();
        ReflectHelper reflectHelper = new ReflectHelper(obj);
        String id = oConvertUtils.getString(reflectHelper.getMethodValue(comboTreeModel.getIdField()));
        HashSet<String> tmpSet = new HashSet<String>();
        block0: for (ComboTree ct : comboTrees) {
            ComboTree tmp = null;
            if (ct != null && ct.getId().equals(id)) {
                tmp = ct;
                if (tmpSet.contains(tmp.getId())) break;
                trees.add(tmp);
                tmpSet.add(tmp.getId());
                break;
            }
            List<ComboTree> children = ct.getChildren();
            for (ComboTree chir : children) {
                tmp = ComboxTreeUtil.sementTrees(chir, id);
                if (tmp == null) continue;
                if (tmpSet.contains(tmp.getId())) continue block0;
                trees.add(tmp);
                tmpSet.add(tmp.getId());
                continue block0;
            }
        }
        return trees;
    }

    private static ComboTree sementTrees(ComboTree ct, String id) {
        boolean b = false;
        ComboTree tmp = null;
        if (ct != null && ct.getId().equals(id)) {
            b = true;
            tmp = ct;
        } else {
            List<ComboTree> children = ct.getChildren();
            if (children != null && children.size() > 0) {
                ComboTree comboTree;
                Iterator<ComboTree> iterator = children.iterator();
                while (iterator.hasNext() && (tmp = ComboxTreeUtil.sementTrees(comboTree = iterator.next(), id)) == null) {
                }
            } else {
                tmp = null;
            }
        }
        return tmp;
    }

    static {
        versionMap = new HashMap();
        currMap = new ConcurrentHashMap();
    }
}

