/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.common.util;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.CustomerClientHolder;
import com.biz.eisp.base.common.util.JSONHelper;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.common.util.TokenUtil;
import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import com.biz.eisp.base.core.service.BaseService;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.util.DBTypeUtil;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import com.biz.eisp.mdm.org.service.TmOrgService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.role.vo.TmRoleVo;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import com.biz.eisp.mdm.web.pojo.Client;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.springframework.stereotype.Component;

@Component
public class ResourceConfigUtils {
    public static String getRequestPath(HttpServletRequest request) {
        String requestPath = request.getRequestURI();
        requestPath = requestPath.substring(request.getContextPath().length() + 1);
        return requestPath;
    }

    public static String getParameter(String field) {
        HttpServletRequest request = ContextHolderUtils.getRequest();
        return request.getParameter(field);
    }

    public static final TmUserEntity getSessionUserName() {
        Client client = ResourceConfigUtils.getClient();
        if (client != null) {
            return client.getUser();
        }
        return null;
    }

    public static final TmCustomerEntity getSessionCustomer() {
        Client client = ResourceConfigUtils.getClient();
        if (client != null) {
            return client.getCustomerEntity();
        }
        return null;
    }

    public static final TmPositionVo getCurrPosition() {
        Client client = ResourceConfigUtils.getClient();
        if (client != null) {
            return client.getPosition();
        }
        return null;
    }

    public static final TmOrgEntity getCurrOrg() {
        Client client = ResourceConfigUtils.getClient();
        if (client != null) {
            return client.getOrg();
        }
        return null;
    }

    public static final TmOrgEntity getCurrOrgByType(String orgType) {
        Client client = ResourceConfigUtils.getClient();
        if (client != null) {
            if (client.getOrg() == null) {
                return new TmOrgEntity();
            }
            String currOrgId = client.getOrg().getId();
            TmOrgService tmOrgService = (TmOrgService)ApplicationContextUtils.getContext().getBean("tmOrgService");
            String sql = "select t.id from tm_org t where t.org_type = ?  start with t.id = ? connect by id = prior parent_id";
            List<Map<String, Object>> mapList = tmOrgService.findForMapList(sql, orgType, currOrgId);
            if (CollectionUtil.listNotEmptyNotSizeZero(mapList)) {
                return tmOrgService.get(TmOrgEntity.class, (Serializable)((Object)((String)mapList.get(0).get("id"))));
            }
        }
        return new TmOrgEntity();
    }

    public static final TmCustomerOrgEntity getCurrCustomerOrg() {
        Client client = ResourceConfigUtils.getClient();
        if (client != null) {
            return client.getCustomerOrg();
        }
        return null;
    }

    public static TmUserVo getSessionTmUserVo() {
        TmUserService tmUserService = (TmUserService)ApplicationContextUtils.getContext().getBean("tmUserService");
        TmUserEntity tmUserEntity = ResourceConfigUtils.getSessionUserName();
        TmUserVo tmUserVo = new TmUserVo();
        tmUserVo.setUserName(tmUserEntity.getUserName());
        return tmUserService.getTmUser(tmUserVo);
    }

    public static List<TmUserVo> getSessionTmUserList() {
        TmUserService tmUserService = (TmUserService)ApplicationContextUtils.getContext().getBean("tmUserService");
        TmUserEntity tmUserEntity = ResourceConfigUtils.getSessionUserName();
        TmUserVo tmUserVo = new TmUserVo();
        tmUserVo.setUserName(tmUserEntity.getUserName());
        return tmUserService.getTmUserList(tmUserVo);
    }

    public static final String getTmRoleString() {
        if (StringUtil.isNotEmpty(ResourceConfigUtils.getCurrPosition())) {
            BaseService baseService = (BaseService)ApplicationContextUtils.getContext().getBean("baseService");
            String positionId = ResourceConfigUtils.getCurrPosition().getId();
            StringBuffer roleBuffer = new StringBuffer();
            String sql = "SELECT TR.ROLE_NAME AS roleName,TR.ROLE_CODE AS roleCode,TR.ID AS id FROM TM_ROLE TR JOIN TM_R_POSITION_ROLE TRPR ON TR.ID=TRPR.ROLE_ID  WHERE TRPR.POSITION_ID = ?";
            List<TmRoleVo> tmRoleVos = baseService.findBySql(TmRoleVo.class, sql, positionId);
            if (CollectionUtil.listNotEmptyNotSizeZero(tmRoleVos)) {
                for (TmRoleVo tmRoleVo : tmRoleVos) {
                    if (roleBuffer.length() > 0) {
                        roleBuffer.append(",");
                    }
                    roleBuffer.append(tmRoleVo.getRoleCode());
                }
            }
            return roleBuffer.toString();
        }
        return null;
    }

    public static final String getCreateName() {
        Client client = ResourceConfigUtils.getClient();
        if (client != null) {
            TmUserEntity user = client.getUser();
            TmPositionVo position = client.getPosition();
            if (user == null || position == null) {
                return null;
            }
            return user.getFullName() + "(" + position.getPositionName() + ")";
        }
        return null;
    }

    public static final String getJdbcUrl() {
        return DBTypeUtil.getDBType().toLowerCase();
    }

    public static Client getClient() {
        Client customerClient = CustomerClientHolder.getClient();
        if (customerClient != null) {
            return customerClient;
        }
        HttpSession session = ContextHolderUtils.getSession();
        String tokenstr = TokenUtil.getTokenStr(session);
        Client client = new Client();
        if (StringUtil.isNotEmpty((String)tokenstr)) {
            client = TokenUtil.tokenMap.get(tokenstr);
        } else {
            Object ob = session.getAttribute(session.getId());
            try {
                if (ob != null) {
                    client = (Client)ob;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return client;
    }

    public static void setClient(Client client) {
        try {
            HttpSession session = ContextHolderUtils.getSession();
            session.setAttribute(ContextHolderUtils.getSession().getId(), (Object)client);
        }
        catch (Exception e) {
            throw new BusinessException("\u767b\u5f55\u8ba4\u8bc1\u7f13\u5b58\u5931\u8d25\u8bf7\u91cd\u65b0\u5c1d\u8bd5!");
        }
    }

    public static void setClient(Client client, IRedisCacheService redisCacheService) {
        try {
            HttpSession session = ContextHolderUtils.getSession();
            String tokenstr = TokenUtil.getTokenStr(session);
            if (StringUtil.isNotEmpty((String)tokenstr)) {
                TokenUtil.saveTokenString(client, session, redisCacheService);
            } else {
                session.setAttribute(ContextHolderUtils.getSession().getId(), (Object)client);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u767b\u5f55\u8ba4\u8bc1\u7f13\u5b58\u5931\u8d25\u8bf7\u91cd\u65b0\u5c1d\u8bd5!");
        }
    }

    public static void addString(String key, String value) {
        HttpSession session = ContextHolderUtils.getSession();
        session.setAttribute(key + session.getId(), (Object)value);
    }

    public static String getString(String key) {
        HttpSession session = ContextHolderUtils.getSession();
        Object ob = session.getAttribute(key + session.getId());
        return ob != null ? ob.toString() : "";
    }

    public static Client getClientForLogin() {
        HttpSession session = ContextHolderUtils.getSession();
        Object ob = session.getAttribute(session.getId());
        Client client = new Client();
        try {
            if (ob != null) {
                client = JSONHelper.toBean(ob, Client.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return client;
    }
}

