/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.core.dao.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.dao.BaseDao;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.importer.PersisterHolder;
import com.biz.eisp.base.interfacedao.common.InterfaceDaoUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class BaseDaoImpl<T, PK extends Serializable>
implements BaseDao {
    @Autowired
    private SessionFactory sessionFactory;
    @Autowired
    @Qualifier(value="jdbcTemplate")
    private JdbcTemplate jdbcTemplate;

    @Override
    public Session getSession() {
        if (PersisterHolder.getHibernatePersister() != null) {
            return PersisterHolder.getHibernatePersister().getSession();
        }
        return this.sessionFactory.getCurrentSession();
    }

    @Override
    public <T> Serializable save(T entity) {
        return this.getSession().save(entity);
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        this.getSession().saveOrUpdate(entity);
    }

    @Override
    public <T> void delete(T entity) {
        this.getSession().delete(entity);
    }

    @Override
    public <T> void batchSave(List<T> entitys) {
        for (int i = 0; i < entitys.size(); ++i) {
            this.getSession().save(entitys.get(i));
            if (i % 50 != 0) continue;
            this.getSession().flush();
            this.getSession().clear();
        }
        this.getSession().flush();
        this.getSession().clear();
    }

    @Override
    public <T> T get(Class<T> clazz, Serializable id) {
        return (T)this.getSession().get(clazz, id);
    }

    @Override
    public <T> List<T> findByProperty(Class<T> clazz, String propertyName, Object value) {
        return this.createCriteria(clazz, new Criterion[]{Restrictions.eq((String)propertyName, (Object)value)}).list();
    }

    @Override
    public <T> List<T> findByPropertyisOrder(Class<T> clazz, String propertyName, Object value, boolean isAsc, String isAscForpropertyName) {
        return this.findByCriteria(clazz, isAsc, isAscForpropertyName, new Criterion[]{Restrictions.eq((String)propertyName, (Object)value)});
    }

    @Override
    public <T> T findUniqueByProperty(Class<T> clazz, String propertyName, Object value) {
        return (T)this.createCriteria(clazz, new Criterion[]{Restrictions.eq((String)propertyName, (Object)value)}).uniqueResult();
    }

    @Override
    public <T> List<T> loadAll(Class<T> clazz) {
        Criteria criteria = this.createCriteria(clazz, new Criterion[0]);
        return criteria.list();
    }

    @Override
    public <T> void deleteEntityById(Class<T> clazz, Serializable id) {
        this.delete(this.get(clazz, id));
    }

    @Override
    public <T> void deleteAllEntity(Collection<T> entities) {
        int i = 0;
        for (T entity : entities) {
            this.getSession().delete(entity);
            if (i % 50 != 0) continue;
            this.getSession().flush();
            this.getSession().clear();
        }
        this.getSession().flush();
        this.getSession().clear();
    }

    @Override
    public <T> void updateEntity(T entity) {
        this.getSession().update(entity);
    }

    @Override
    public Integer executeSql(String sql, Object ... params) {
        SQLQuery q = this.getSession().createSQLQuery(sql);
        this.addParams((Query)q, params);
        return q.executeUpdate();
    }

    @Override
    public <T> List<T> findByCriteria(Class<T> clazz, boolean isAsc, String isAscForpropertyName, Criterion ... criterions) {
        Criteria criteria = this.createCriteria(clazz, criterions);
        if (isAsc) {
            criteria.addOrder(Order.asc((String)isAscForpropertyName));
        } else {
            criteria.addOrder(Order.desc((String)isAscForpropertyName));
        }
        return criteria.list();
    }

    @Override
    public <T> List<T> findByCriteria(Class<T> clazz, Criterion ... criterions) {
        Criteria criteria = this.createCriteria(clazz, criterions);
        return criteria.list();
    }

    @Override
    public <T> List<T> findByCriteria(Class<T> clazz, Page page, List<Criterion> criterions) {
        Criteria criteria = this.getSession().createCriteria(clazz);
        if (CollectionUtil.listNotEmpty(criterions)) {
            for (Criterion cn : criterions) {
                criteria.add(cn);
            }
        }
        int pageNo = page.getPageNo();
        int pageSize = page.getInt(Page.ROWS);
        criteria.setFirstResult(pageNo);
        criteria.setMaxResults(pageSize);
        return criteria.list();
    }

    private <T> Criteria createCriteria(Class<T> clazz, Criterion ... criterions) {
        Criteria criteria = this.getSession().createCriteria(clazz);
        for (Criterion c : criterions) {
            if (!StringUtil.isNotEmpty(c)) continue;
            criteria.add(c);
        }
        return criteria;
    }

    public String makeCountSql(String sql) {
        if (StringUtils.isEmpty((Object)sql)) {
            throw new BusinessException("sql \u8bed\u53e5\u4e3a\u7a7a");
        }
        int selectIndex = sql.trim().toLowerCase().indexOf("from");
        sql = "SELECT COUNT(*) AS countVal " + sql.substring(selectIndex);
        return sql;
    }

    private void addParams(Query query, Object ... params) {
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] instanceof Collection) {
                    query.setParameterList("param" + i, (Collection)params[i]);
                    continue;
                }
                if (params[i] instanceof Object[]) {
                    query.setParameterList("param" + i, (Object[])params[i]);
                    continue;
                }
                query.setParameter(i, params[i]);
            }
        }
    }

    @Override
    public List<Map<String, Object>> findForMapList(String sql, Object ... objs) {
        return this.jdbcTemplate.queryForList(sql, objs);
    }

    @Override
    public Map<String, Object> findForMap(String sql, Object ... objs) {
        return this.jdbcTemplate.queryForMap(sql, objs);
    }

    @Override
    public Long getCountForJdbcParam(String sql, Object ... params) {
        return (Long)this.jdbcTemplate.queryForObject(sql, params, Long.class);
    }

    @Override
    public <T> List<T> findByHql(String hql, Object ... params) {
        Query q = this.getSession().createQuery(hql);
        this.addParams(q, params);
        q.setCacheable(true);
        return q.list();
    }

    @Override
    public <T> List<T> findByHql(String hql, Page page, Object ... params) {
        String onHql = this.makeCountSql(hql);
        Query query = this.getSession().createQuery(onHql);
        this.addParams(query, params);
        long count = (Long)query.uniqueResult();
        page.put(Page.TOTAL, String.valueOf(count));
        Query query1 = this.getSession().createQuery(hql);
        this.addParams(query1, params);
        int pageNo = page.getPageNo();
        int pageSize = page.getInt(Page.ROWS);
        query1.setFirstResult(pageNo);
        query1.setMaxResults(pageSize);
        return query1.list();
    }

    @Override
    public <T> T getUniqueBySql(Class<T> clazz, String sql, Object ... params) {
        BeanPropertyRowMapper rm = BeanPropertyRowMapper.newInstance(clazz);
        return (T)this.jdbcTemplate.queryForObject(sql, (RowMapper)rm, params);
    }

    @Override
    public <T> List<T> findBySql(Class<T> clazz, String sql, Object ... params) {
        BeanPropertyRowMapper rm = BeanPropertyRowMapper.newInstance(clazz);
        return this.jdbcTemplate.query(sql, (RowMapper)rm, params);
    }

    @Override
    public <T> List<T> findBySql(Class<T> clazz, String sql, Page page, Object ... params) {
        String countSql = this.makeCountSql(sql);
        Integer count = (Integer)this.jdbcTemplate.queryForObject(countSql, Integer.class, params);
        page.put(Page.TOTAL, String.valueOf(count));
        int pages = page.getPageNo();
        int rows = page.getInt(Page.ROWS);
        sql = InterfaceDaoUtil.createPageSql("oracle", sql, pages, rows);
        BeanPropertyRowMapper rm = BeanPropertyRowMapper.newInstance(clazz);
        return this.jdbcTemplate.query(sql, (RowMapper)rm, params);
    }

    @Override
    public <T> T getUniqueByHql(Class<T> clazz, String hql, Object ... params) {
        Query query = this.getSession().createQuery(hql);
        this.addParams(query, params);
        return (T)query.uniqueResult();
    }

    @Override
    public void updateBySql(String sql, Object ... param) {
        this.jdbcTemplate.update(sql, param);
    }

    @Override
    public int callableStatementByName(String proc, List<String> list) {
        StringBuffer bufProc = new StringBuffer();
        bufProc.append("{call " + proc);
        int length = list.size();
        bufProc.append(" (");
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                bufProc.append(",");
            }
            bufProc.append("?");
        }
        bufProc.append(")}");
        SQLQuery query = this.getSession().createSQLQuery(bufProc.toString());
        for (int i = 0; i < list.size(); ++i) {
            query.setString(i, list.get(i));
        }
        return query.executeUpdate();
    }
}

