/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.importer.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.util.ContextHolderUtils;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.core.redis.cache.impl.RedisService;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.importer.ImpInfo;
import com.biz.eisp.base.importer.ImportMonitor;
import com.biz.eisp.base.importer.ImportMonitorMap;
import com.biz.eisp.base.importer.Importer;
import com.biz.eisp.base.importer.ImporterFactory;
import com.biz.eisp.base.utils.DateUtils;
import com.biz.eisp.base.utils.ZipUtils;
import com.biz.eisp.mdm.user.entity.TmUserEntity;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/importController"})
public class ImportController
extends BaseController {
    @Autowired
    private RedisService redisService;
    private Map<String, ImportMonitor> map = ImportMonitorMap.getInstance();
    private final boolean isDistributed = false;

    @RequestMapping(value={"importData"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView importData(HttpServletRequest request) {
        String impName = request.getParameter("impName");
        Object hiddenTemplete = request.getParameter("hiddenTemplete");
        if (hiddenTemplete == null || hiddenTemplete.equals("undefined")) {
            hiddenTemplete = false;
        }
        request.setAttribute("impName", (Object)impName);
        request.setAttribute("hiddenTemplete", hiddenTemplete);
        request.setAttribute("sId", (Object)(ResourceConfigUtils.getSessionTmUserVo().getUserName() + System.currentTimeMillis()));
        request.setAttribute("key", (Object)(ResourceConfigUtils.getSessionTmUserVo().getUserName() + System.currentTimeMillis()));
        return new ModelAndView("com/biz/eisp/importer/importData");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"save"}, method={RequestMethod.GET, RequestMethod.POST})
    public void save(HttpServletRequest request, HttpServletResponse response) {
        Map<String, Object> params;
        String test = request.getParameter("test");
        String impName = request.getParameter("impName");
        this.cleanFiles(impName);
        String configFile = impName + ".xml";
        String key = request.getParameter("key");
        String mode = request.getParameter("mode");
        String type = request.getParameter("type");
        String zip = request.getParameter("zip");
        FileInputStream is = null;
        Importer imp = null;
        MultipartFile importFile = null;
        MultipartHttpServletRequest multipartRequest = null;
        if (request instanceof MultipartHttpServletRequest) {
            multipartRequest = (MultipartHttpServletRequest)request;
            params = multipartRequest.getFileMap();
            importFile = (MultipartFile)params.get("Filedata");
        }
        try {
            params = this.initParams(request);
            ContextHolderUtils.setCustomerSession(request.getSession());
            imp = "2".equals(mode) ? ImporterFactory.createImportThreadWrapper(ImporterFactory.createDelayImporter(configFile, params), request.getSession(), response) : ImporterFactory.createImportThreadWrapper(ImporterFactory.createImporter(configFile, params), request.getSession(), response);
            if ("1".equals(request.getParameter("template"))) {
                imp.template(response);
                return;
            }
            String file = null;
            TmUserEntity user = ResourceConfigUtils.getSessionUserName();
            String filedir = System.getProperty("java.io.tmpdir");
            String fileName = filedir + "/" + impName + "_" + user.getUserName() + "_" + System.currentTimeMillis();
            file = fileName + ".sub";
            new File(file).getParentFile().mkdirs();
            if ("1".equals(zip)) {
                String gzFile = fileName + ".zip";
                ZipUtils.createFile(importFile.getInputStream(), gzFile);
                ZipUtils.unzipFirstEntry(gzFile, file);
            } else if ("2".equals(zip)) {
                String gzFile = fileName + ".gz";
                ZipUtils.createFile(importFile.getInputStream(), gzFile);
                ZipUtils.ungzFirstEntry(gzFile, file);
            } else {
                ZipUtils.createFile(importFile.getInputStream(), file);
            }
            is = new FileInputStream(file);
            if ("1".equals(test)) {
                if ("xls".equals(type)) {
                    imp.test(ImporterFactory.getExcelDataIterator(configFile, is));
                } else {
                    imp.test(ImporterFactory.getTextDataIterator((InputStream)is, type.charAt(0), ImporterFactory.getTextFileCharset(file)));
                }
                ((ImportMonitor)((Object)imp)).toContainer(this.map, key);
                this.renderText(response, key, true);
            } else if (!"2".equals(mode)) {
                if ("xls".equals(type)) {
                    imp.imp(ImporterFactory.getExcelDataIterator(configFile, is), request.getSession());
                } else {
                    imp.imp(ImporterFactory.getTextDataIterator((InputStream)is, type.charAt(0), ImporterFactory.getTextFileCharset(file)), request.getSession());
                }
                ((ImportMonitor)((Object)imp)).toContainer(this.map, key);
                this.renderText(response, key, true);
            }
        }
        catch (Throwable var23) {
            var23.printStackTrace();
            String cfr_ignored_0 = "\u5bfc\u5165\u5931\u8d25" + "\uff01" + var23.getMessage();
            this.renderText(response, "\u5bfc\u5165\u5931\u8d25", false);
        }
    }

    @ResponseBody
    @RequestMapping(value={"info"}, method={RequestMethod.GET, RequestMethod.POST})
    public AjaxJson info(String keyname) {
        AjaxJson j = new AjaxJson();
        String mess = "";
        boolean isEnd = false;
        ImportMonitor mon = this.map.get(keyname);
        if (mon != null && mon.getImpState() != null) {
            String state = mon.getImpState();
            if (state.equals("R")) {
                int size = mon.getSize();
                int index = mon.getIndex();
                mess = " " + "\u5bfc\u5165\u8fdb\u5ea6:" + (size == -1 ? "..." : "\u5171" + Integer.valueOf(size - 1) + "\u6761\u6570\u636e\uff0c\u6b63\u5728\u5bfc\u5165\u7b2c") + (index == -1 ? "..." : Integer.valueOf(index) + "\u6761\u6570\u636e...");
            } else if (state.equals("S")) {
                ImpInfo info = mon.getImpInfo();
                String messKey = mon.isTest() ? "\u6d4b\u8bd5\u6210\u529f" : "\u5bfc\u5165\u6210\u529f";
                messKey = this.format("\u5bfc\u5165\u6210\u529f\uff01\u6210\u529f\u884c\u6570{0}", info.getSuccNum());
                mess = "SUCCESS" + messKey;
                if (StringUtils.isNotBlank((String)info.getMessages())) {
                    mess = mess + "<p/>";
                    mess = mess + "[" + "\u5ffd\u7565\u9519\u8bef\u4fe1\u606f" + "]" + "<br/>";
                    mess = mess + info.getMessages();
                }
                isEnd = true;
            } else if (state.equals("E")) {
                mess = "ERROR" + "\u5bfc\u5165\u5931\u8d25" + "\uff01!";
                mess = mess + "</p>";
                mess = mess + "[" + "\u5bfc\u5165\u5931\u8d25\u4fe1\u606f" + "]" + "</br>";
                mess = mess + mon.getErrInfo();
                isEnd = true;
            }
        }
        j.setMsg(mess);
        j.setSuccess(isEnd);
        return j;
    }

    private String format(String str, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            str = null == args[i] ? str.replace("{" + i + "}", "null") : str.replace("{" + i + "}", args[i].toString());
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderText(HttpServletResponse response, String mess, boolean flag) {
        response.setContentType("text/html;charset=utf-8");
        JSONObject obj = new JSONObject();
        obj.put("success", (Object)flag);
        obj.put("result", (Object)true);
        obj.put("message", (Object)mess);
        try (PrintWriter out = null;){
            out = response.getWriter();
            out.write(obj.toJSONString());
        }
    }

    private byte[] toBytes(InputStream is) throws IOException {
        int n;
        ByteArrayOutputStream baout = new ByteArrayOutputStream();
        int cachesize = 2048;
        byte[] b = new byte[2048];
        while ((n = is.read(b)) != -1) {
            baout.write(b, 0, n);
        }
        return baout.toByteArray();
    }

    private Map<String, Object> initParams(HttpServletRequest request) {
        TmUserEntity user = ResourceConfigUtils.getSessionUserName();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("_user", user);
        Date date = new Date();
        params.put("_currDate", DateUtils.formatDate(date, "yyyy-MM-dd"));
        params.put("_currTime", DateUtils.formatDate(date, "yyyy-MM-dd HH:mm:ss"));
        params.put("_currMillis", date.getTime() + "");
        params.put("_uuid", UUID.randomUUID().toString());
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            params.put(name, request.getParameter(name));
        }
        return params;
    }

    private void cleanFiles(String impName) {
        try {
            File[] files;
            String fn = impName;
            if (fn.indexOf(47) != -1) {
                fn = fn.substring(fn.lastIndexOf(47) + 1);
            }
            final String fileName = fn;
            String filepath = System.getProperty("java.io.tmpdir") + "/" + impName;
            String filedir = filepath.substring(0, filepath.lastIndexOf(47));
            long fd = 432000000L;
            final long tm = System.currentTimeMillis() - 432000000L;
            File file = new File(filedir);
            for (File f : files = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().startsWith(fileName) && file.lastModified() < tm;
                }
            })) {
                f.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

