/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.interfacedao.aop;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.ResultType;
import com.biz.eisp.base.interfacedao.annotation.Sql;
import com.biz.eisp.base.interfacedao.common.FreemarkerParseFactory;
import com.biz.eisp.base.interfacedao.common.InterfaceDaoUtil;
import com.biz.eisp.base.interfacedao.interceptor.EmptyInterceptor;
import com.biz.eisp.mdm.authobj.util.AuthObjHandler;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ognl.Ognl;
import ognl.OgnlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class InterfaceDaoHandler
implements InvocationHandler {
    private static final Logger logger = LoggerFactory.getLogger(InterfaceDaoHandler.class);
    public static final String INFO_METHOD_MODIFY = "insert,add,create,update,modify,store,delete,remove";
    public static final String INFO_METHOD_BATCH = "batch";
    private static final String PAGE = "page";
    private static final String SQL = "sql";
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    private String keyType = "origin";
    private boolean formatSql = false;
    private boolean showSql = false;
    private String dbType;
    private EmptyInterceptor emptyInterceptor;

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object returnObj;
        block3: {
            returnObj = null;
            String templateSql = null;
            HashMap<String, Object> sqlParamsMap = new HashMap<String, Object>();
            templateSql = this.installDaoMetaData(method, sqlParamsMap, args);
            String executeSql = this.parseSqlTemplate(method, templateSql, sqlParamsMap);
            Map<String, Object> sqlMap = this.installPlaceholderSqlParam(executeSql, sqlParamsMap);
            try {
                Page page = (Page)sqlParamsMap.get(PAGE);
                returnObj = this.getReturnResultType(this.dbType, page, method, executeSql, sqlMap);
            }
            catch (Exception e) {
                returnObj = null;
                if (e instanceof EmptyResultDataAccessException) break block3;
                e.printStackTrace();
                throw e;
            }
        }
        if (this.showSql) {
            // empty if block
        }
        return returnObj;
    }

    private String installDaoMetaData(Method method, Map<String, Object> sqlParamsMap, Object[] args) throws Exception {
        Sql sql;
        boolean hasArguments;
        String templateSql = null;
        if (this.emptyInterceptor != null && args != null && args.length == 1) {
            String methodName = method.getName();
            Object obj = args[0];
            Field[] fields = obj.getClass().getDeclaredFields();
            if (methodName.startsWith("insert") && this.emptyInterceptor != null) {
                this.emptyInterceptor.onInsert(fields, obj);
            }
            if (methodName.startsWith("update") && this.emptyInterceptor != null) {
                this.emptyInterceptor.onUpdate(fields, obj);
            }
        }
        if (hasArguments = method.isAnnotationPresent(Arguments.class)) {
            Arguments arguments = method.getAnnotation(Arguments.class);
            if (arguments.value().length != args.length) {
                throw new BusinessException("\u6ce8\u91ca\u6807\u7b7e@Arguments\u53c2\u6570\u6570\u76ee\uff0c\u4e0e\u65b9\u6cd5\u53c2\u6570\u6570\u76ee\u4e0d\u76f8\u7b49~");
            }
            int argsNum = 0;
            for (String v : arguments.value()) {
                if (v.equalsIgnoreCase(PAGE)) {
                    Class<?>[] params = method.getParameterTypes();
                    for (int j = 0; j < params.length; ++j) {
                        String paramName = params[j].getName();
                        if (paramName.indexOf(PAGE) == -1) continue;
                        Class<Page> clazz = Class.forName(paramName);
                        Class<Page> supClazz = clazz.getSuperclass();
                        if (clazz.isAssignableFrom(Page.class) || supClazz.isAssignableFrom(Page.class)) continue;
                        throw new BusinessException("\u53c2\u6570page\u5fc5\u987b\u662fcom.biz.eisp.base.core.page.Page\u5bf9\u8c61\u5b9e\u4f8b");
                    }
                }
                if (v.equalsIgnoreCase(SQL)) {
                    templateSql = (String)args[argsNum];
                }
                sqlParamsMap.put(v, args[argsNum]);
                ++argsNum;
            }
        } else if (args != null && args.length >= 0) {
            String[] params = InterfaceDaoUtil.getMethodParameterNamesByAnnotation(method);
            if (params == null || params.length == 0) {
                throw new BusinessException("\u65b9\u6cd5\u53c2\u6570\u6570\u76ee>=2\uff0c\u5fc5\u987b\u4f7f\u7528\uff1a\u65b9\u6cd5\u6807\u7b7e@Arguments \u6216  \u53c2\u6570\u6807\u7b7e@param");
            }
            if (params.length != args.length) {
                throw new BusinessException("\u65b9\u6cd5\u53c2\u6570\u6570\u76ee\u4e0e\u914d\u7f6e\u53c2\u6570\u6570\u76ee\u4e0d\u76f8\u7b49");
            }
            int args_num = 0;
            for (String v : params) {
                if (v == null) {
                    throw new BusinessException("Dao\u63a5\u53e3\u5b9a\u4e49\uff0c\u6240\u6709\u53c2\u6570\u5fc5\u987b\u4f7f\u7528@param\u6807\u7b7e~");
                }
                if (StringUtil.equals(v, SQL)) {
                    templateSql = (String)args[args_num];
                }
                Class<?>[] param = method.getParameterTypes();
                for (int j = 0; j < param.length; ++j) {
                    if (!v.equalsIgnoreCase(PAGE)) continue;
                    Class<Page> obj = Class.forName(param[j].getName());
                    Class<Page> supClazz = obj.getSuperclass();
                    if (obj.isAssignableFrom(Page.class) || supClazz.isAssignableFrom(Page.class)) continue;
                    throw new BusinessException("\u53c2\u6570page\u5fc5\u987b\u662fcom.biz.eisp.base.core.page.Page\u5bf9\u8c61\u5b9e\u4f8b");
                }
                sqlParamsMap.put(v, args[args_num]);
                ++args_num;
            }
        }
        if (method.isAnnotationPresent(Sql.class) && StringUtil.isNotEmpty((String)(sql = method.getAnnotation(Sql.class)).value())) {
            templateSql = sql.value();
        }
        return templateSql;
    }

    private String parseSqlTemplate(Method method, String templateSql, Map<String, Object> sqlParamsMap) {
        String executeSql = null;
        if (StringUtil.isNotEmpty((String)templateSql)) {
            executeSql = FreemarkerParseFactory.parseTemplateContent(templateSql, sqlParamsMap);
        } else {
            String sqlTempletPath = method.getDeclaringClass().getName().replace(".", "/").replace("/dao/", "/sql/") + "_" + method.getName() + ".sql";
            if (!FreemarkerParseFactory.isExistTemplate(sqlTempletPath)) {
                sqlTempletPath = method.getDeclaringClass().getName().replace(".", "/") + "_" + method.getName() + ".sql";
            }
            executeSql = FreemarkerParseFactory.parseTemplate(sqlTempletPath, sqlParamsMap);
        }
        executeSql = AuthObjHandler.executeAuthHandle(executeSql);
        return executeSql;
    }

    private Map<String, Object> installPlaceholderSqlParam(String executeSql, Map sqlParamsMap) throws OgnlException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String regex = ":[ tnx0Bfr]*[0-9a-z.A-Z_]+";
        Pattern pattern = Pattern.compile(regex);
        Matcher marcher = pattern.matcher(executeSql);
        while (marcher.find()) {
            String ognlKey = marcher.group().replace(":", "").trim();
            map.put(ognlKey, Ognl.getValue((String)ognlKey, (Object)sqlParamsMap));
        }
        return map;
    }

    private Object getReturnResultType(String dbType, Page page, Method method, String executeSql, Map<String, Object> paramMap) throws Exception {
        String methodName;
        block25: {
            block24: {
                methodName = method.getName();
                if (this.checkIsNotSearch(methodName, INFO_METHOD_MODIFY)) break block24;
                if (!this.checkIsNotSearch(executeSql, INFO_METHOD_MODIFY)) break block25;
            }
            if (paramMap != null) {
                return this.namedParameterJdbcTemplate.update(executeSql, paramMap);
            }
            return this.jdbcTemplate.update(executeSql);
        }
        if (this.checkIsNotSearch(methodName, INFO_METHOD_BATCH)) {
            return this.batchUpdate(executeSql);
        }
        Class<Object> returnType = method.getReturnType();
        if (returnType.isAssignableFrom(Page.class) && !returnType.isAssignableFrom(Map.class)) {
            throw new BusinessException("Page\u5bf9\u8c61\u4e0d\u80fd\u76f4\u63a5\u8fd4\u56de\uff0c\u5206\u9875\u8bf7\u4f7f\u7528list\u8fd4\u56de");
        }
        if (returnType.isPrimitive()) {
            Number number = (Number)this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, BigDecimal.class);
            if ("int".equals(returnType.getCanonicalName())) {
                return number.intValue();
            }
            if ("long".equals(returnType.getCanonicalName())) {
                return number.longValue();
            }
            if ("double".equals(returnType.getCanonicalName())) {
                return number.doubleValue();
            }
        } else {
            if (returnType.isAssignableFrom(List.class)) {
                if (page != null) {
                    int pages = page.getPageNo();
                    int rows = page.getInt(Page.ROWS);
                    if (pages >= 0 && rows != 0) {
                        if (paramMap != null) {
                            page.put(Page.TOTAL, this.namedParameterJdbcTemplate.queryForObject(this.getCountSql(executeSql), paramMap, String.class));
                        } else {
                            page.put(Page.TOTAL, this.jdbcTemplate.queryForObject(this.getCountSql(executeSql), String.class));
                        }
                        executeSql = InterfaceDaoUtil.createPageSql(dbType, executeSql, pages, rows);
                    }
                }
                RowMapper<?> resultType = this.getListRealType(method);
                List list = paramMap != null ? this.namedParameterJdbcTemplate.query(executeSql, paramMap, resultType) : this.jdbcTemplate.query(executeSql, resultType);
                return list;
            }
            if (returnType.isAssignableFrom(Map.class)) {
                if (paramMap != null) {
                    return this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, (RowMapper)new ColumnMapRowMapper());
                }
                return this.jdbcTemplate.queryForObject(executeSql, (RowMapper)new ColumnMapRowMapper());
            }
            if (returnType.isAssignableFrom(String.class)) {
                if (paramMap != null) {
                    return this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, String.class);
                }
                return this.jdbcTemplate.queryForObject(executeSql, String.class);
            }
            if (InterfaceDaoUtil.isWrapClass(returnType)) {
                if (paramMap != null) {
                    return this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, returnType);
                }
                return this.jdbcTemplate.queryForObject(executeSql, returnType);
            }
            BeanPropertyRowMapper rm = BeanPropertyRowMapper.newInstance(returnType);
            if (paramMap != null) {
                return this.namedParameterJdbcTemplate.queryForObject(executeSql, paramMap, (RowMapper)rm);
            }
            return this.jdbcTemplate.queryForObject(executeSql, (RowMapper)rm);
        }
        return null;
    }

    private boolean checkIsNotSearch(String head, String target) {
        String[] keys;
        for (String s : keys = target.split(",")) {
            if (!head.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private void addResultArray(int[] result, int index, int[] arr) {
        for (int result[index - length + i] : arr) {
        }
    }

    private int[] batchUpdate(String executeSql) {
        String[] sqls = executeSql.split(";");
        if (sqls.length < 100) {
            return this.jdbcTemplate.batchUpdate(sqls);
        }
        int[] result = new int[sqls.length];
        ArrayList<String> sqlList = new ArrayList<String>();
        for (int i = 0; i < sqls.length; ++i) {
            sqlList.add(sqls[i]);
            if (i % 100 != 0) continue;
            this.addResultArray(result, i + 1, this.jdbcTemplate.batchUpdate(sqlList.toArray(new String[0])));
            sqlList.clear();
        }
        this.addResultArray(result, sqls.length, this.jdbcTemplate.batchUpdate(sqlList.toArray(new String[0])));
        return result;
    }

    private String getCountSql(String sql) {
        return "select count(1) from (" + sql + ") tmp_count";
    }

    private RowMapper<?> getListRealType(Method method) {
        ResultType resultType = method.getAnnotation(ResultType.class);
        if (resultType != null) {
            if (resultType.value().equals(Map.class)) {
                return new ColumnMapRowMapper();
            }
            return BeanPropertyRowMapper.newInstance(resultType.value());
        }
        String genericReturnType = method.getGenericReturnType().toString();
        String realType = genericReturnType.replace("java.util.List", "").replace("<", "").replace(">", "");
        if (realType.contains("java.util.Map")) {
            return new ColumnMapRowMapper();
        }
        if (realType.length() > 0) {
            try {
                return BeanPropertyRowMapper.newInstance(Class.forName(realType));
            }
            catch (ClassNotFoundException e) {
                logger.error(e.getMessage(), e.fillInStackTrace());
                throw new RuntimeException("\u83b7\u53d6\u8fd4\u56de\u7c7b\u578b\u9519\u8bef ,class:" + realType);
            }
        }
        return new ColumnMapRowMapper();
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return this.namedParameterJdbcTemplate;
    }

    public void setNamedParameterJdbcTemplate(NamedParameterJdbcTemplate namedParameterJdbcTemplate) {
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public boolean isFormatSql() {
        return this.formatSql;
    }

    public void setFormatSql(boolean formatSql) {
        this.formatSql = formatSql;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public String getDbType() {
        return this.dbType;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public EmptyInterceptor getEmptyInterceptor() {
        return this.emptyInterceptor;
    }

    public void setEmptyInterceptor(EmptyInterceptor emptyInterceptor) {
        this.emptyInterceptor = emptyInterceptor;
    }
}

