/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.base.interfacedao.factory;

import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.factory.InterfaceDaoBeanFactory;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class InterfaceDaoClassPathMapperScanner
extends ClassPathBeanDefinitionScanner {
    private static final Logger logger = LoggerFactory.getLogger(InterfaceDaoClassPathMapperScanner.class);

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            logger.warn("Not find InterfaceDao\uff0cIn package " + Arrays.toString(basePackages));
        }
        for (BeanDefinitionHolder holder : beanDefinitions) {
            GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
            definition.getPropertyValues().add("proxy", (Object)this.getRegistry().getBeanDefinition("interfaceDaoHandler"));
            definition.getPropertyValues().add("daoInterface", (Object)definition.getBeanClassName());
            if (logger.isInfoEnabled()) {
                logger.info("Have been scanned to  InterfaceDao { " + definition.getBeanClassName().toString() + " }");
            }
            definition.setBeanClass(InterfaceDaoBeanFactory.class);
        }
        return beanDefinitions;
    }

    public InterfaceDaoClassPathMapperScanner(BeanDefinitionRegistry registry, Class<? extends Annotation> annotation) {
        super(registry, false);
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotation));
        if (!InterfaceDao.class.equals(annotation)) {
            this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(InterfaceDao.class));
        }
    }

    public InterfaceDaoClassPathMapperScanner(BeanDefinitionRegistry registry) {
        super(registry);
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }
}

