/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.administrativearea.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.administrativearea.service.TmAdministrativeAreaService;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaExcelVo;
import com.biz.eisp.mdm.administrativearea.vo.TmAdministrativeAreaVo;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmAdministrativeAreaController"})
public class TmAdministrativeAreaController
extends BaseController {
    @Autowired
    TmAdministrativeAreaService tmAdministrativeAreaService;

    @RequestMapping(value={"goTmAdministrativeAreaMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTmAdministrativeAreaMain(HttpServletRequest request) {
        request.setAttribute("extendTableName", (Object)Globals.TABLE_ADMINISTRATIVE_AREA);
        return new ModelAndView("com/biz/eisp/mdm/administrativeArea/tmAdministrativeAreaMain");
    }

    @RequestMapping(value={"goTmAdministrativeAreaSelectMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTmProductSelectMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/administrativeArea/tmAdministrativeAreaSelectMain");
    }

    @RequestMapping(value={"findTmAdministrativeAreaList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public List<TmAdministrativeAreaVo> findTmAdministrativeAreaList(TmAdministrativeAreaVo tmAdministrativeAreaVo, HttpServletRequest request) {
        List<TmAdministrativeAreaVo> voList = this.tmAdministrativeAreaService.findAdministrativeAreaList(tmAdministrativeAreaVo);
        return voList;
    }

    @RequestMapping(value={"findTmAdministrativeAreaComboTree"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public List<TmAdministrativeAreaVo> findTmAdministrativeAreaComboTree(TmAdministrativeAreaVo tmAdministrativeAreaVo, HttpServletRequest request) {
        List<TmAdministrativeAreaVo> voList = this.tmAdministrativeAreaService.findTmAdministrativeAreaComboTree(tmAdministrativeAreaVo, request.getParameter("selfId"));
        return voList;
    }

    @RequestMapping(value={"goTmAdministrativeAreaForm"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTmAdministrativeAreaForm(HttpServletRequest request, TmAdministrativeAreaVo tmAdministrativeAreaVo) {
        request.setAttribute("extendTableName", (Object)Globals.TABLE_ADMINISTRATIVE_AREA);
        String optype = request.getParameter("optype");
        request.setAttribute("optype", (Object)optype);
        if (StringUtil.isNotEmpty((String)tmAdministrativeAreaVo.getId())) {
            TmAdministrativeAreaVo vo = this.tmAdministrativeAreaService.getTmAdministrativeAreaVo(tmAdministrativeAreaVo.getId());
            request.setAttribute("tba", (Object)vo);
        }
        return new ModelAndView("com/biz/eisp/mdm/administrativeArea/tmAdministrativeAreaForm");
    }

    @RequestMapping(value={"getAreaForCombobox"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public List<ComboBox> getAreaForCombobox(HttpServletRequest request, TmAdministrativeAreaExcelVo tba) {
        try {
            String name = request.getParameter("name");
            if (StringUtil.isNotEmpty((String)name)) {
                name = URLDecoder.decode(name, "UTF-8");
                tba.setAdministrativeAreaName(name);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this.tmAdministrativeAreaService.findAdministrativeAreaCombobox(tba);
    }

    @RequestMapping(value={"saveTmAdministrativeArea"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveTmAdministrativeArea(HttpServletRequest request, TmAdministrativeAreaVo tmAdministrativeAreaVo) {
        AjaxJson j = new AjaxJson();
        try {
            EuPage page = new EuPage(request);
            this.tmAdministrativeAreaService.saveTmAdministrativeArea(tmAdministrativeAreaVo, page);
            this.tmAdministrativeAreaService.updateIsLeafColumn("tm_administrative_area");
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("administrativeAreaCode", tmAdministrativeAreaVo.getAdministrativeAreaCode());
            attributes.put("text", tmAdministrativeAreaVo.getAdministrativeAreaName());
            j.setAttributes(attributes);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(value={"deleteTmAdministrativeArea"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson deleteTmAdministrativeArea(String id) {
        try {
            this.tmAdministrativeAreaService.deleteTmAdministrativeArea(id);
            this.tmAdministrativeAreaService.updateIsLeafColumn("tm_administrative_area");
        }
        catch (Exception e) {
            return new AjaxJson("\u5220\u9664\u5931\u8d25:" + e.getMessage());
        }
        return new AjaxJson();
    }

    @RequestMapping(value={"validateAdministrativeAreaName"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ValidForm validateAdministrativeAreaName(HttpServletRequest request, TmAdministrativeAreaExcelVo tba) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        return validForm;
    }

    @RequestMapping(value={"validateAdministrativeAreaCode"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ValidForm validateAdministrativeAreaCode(HttpServletRequest request, TmAdministrativeAreaExcelVo tba) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        if (StringUtil.isNotEmpty((String)tba.getId())) {
            if (this.tmAdministrativeAreaService.validate(tba.getId(), param, "administrativeAreaCode")) {
                validForm.setStatus("n");
                validForm.setInfo("\u4e1a\u52a1\u533a\u57df\u7f16\u7801\u5df2\u5b58\u5728");
            }
        } else if (this.tmAdministrativeAreaService.validate(null, param, "administrativeAreaCode")) {
            validForm.setStatus("n");
            validForm.setInfo("\u4e1a\u52a1\u533a\u57df\u7f16\u7801\u5df2\u5b58\u5728");
        }
        return validForm;
    }

    @RequestMapping(value={"startTmAdministrativeArea"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson startTmAdministrativeArea(TmAdministrativeAreaVo tmAdministrativeAreaVo) {
        try {
            tmAdministrativeAreaVo.setEnableStatus(0);
            this.tmAdministrativeAreaService.updateAdministrativeAreaEnableStatus(tmAdministrativeAreaVo);
            return new AjaxJson();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson(e.getMessage());
        }
    }

    @RequestMapping(value={"stopTmAdministrativeArea"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson stopTmAdministrativeArea(TmAdministrativeAreaVo tmAdministrativeAreaVo) {
        try {
            tmAdministrativeAreaVo.setEnableStatus(1);
            this.tmAdministrativeAreaService.updateAdministrativeAreaEnableStatus(tmAdministrativeAreaVo);
            return new AjaxJson();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson(e.getMessage());
        }
    }

    @RequestMapping(value={"exportXls"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportXls(TmAdministrativeAreaVo tmAdministrativeAreaVo, HttpServletRequest request, HttpServletResponse response) {
        tmAdministrativeAreaVo.setExportExcel("true");
        List<TmAdministrativeAreaVo> tmAdministrativeAreaVoList = this.tmAdministrativeAreaService.findAdministrativeAreaList(tmAdministrativeAreaVo);
        this.doExportXls(response, request, tmAdministrativeAreaVoList, TmAdministrativeAreaVo.class, "\u884c\u653f\u533a\u57df\u5217\u8868");
    }
}

