/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.businessarea.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboBox;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaFormExtendService;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaMainExtendService;
import com.biz.eisp.mdm.businessarea.service.TmBusinessAreaService;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaExcelVo;
import com.biz.eisp.mdm.businessarea.vo.TmBusinessAreaVo;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmBusinessAreaController"})
public class TmBusinessAreaController
extends BaseController {
    @Autowired
    TmBusinessAreaService tmBusinessAreaService;
    @Autowired(required=false)
    private TmBusinessAreaFormExtendService tmBusinessAreaFormExtendService;
    @Autowired(required=false)
    private TmBusinessAreaMainExtendService tmBusinessAreaMainExtendService;

    @RequestMapping(value={"goTmBusinessAreaMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTmBusinessAreaMain(HttpServletRequest request) {
        request.setAttribute("extendTableName", (Object)Globals.TABLE_BUSINESS_AREA);
        if (this.tmBusinessAreaMainExtendService != null) {
            request.setAttribute("includeJSP", (Object)this.tmBusinessAreaMainExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/businessArea/tmBusinessAreaMain");
    }

    @RequestMapping(value={"goTmBusinessAreaSelectMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTmProductSelectMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/businessArea/tmBusinessAreaSelectMain");
    }

    @RequestMapping(value={"findTmBusinessAreaList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public List<TmBusinessAreaVo> findTmBusinessAreaList(TmBusinessAreaVo tmBusinessAreaVo, HttpServletRequest request) {
        List<TmBusinessAreaVo> voList = this.tmBusinessAreaService.findBusinessAreaList(tmBusinessAreaVo);
        return voList;
    }

    @RequestMapping(value={"findTmBusinessAreaComboTree"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public List<TmBusinessAreaVo> findTmBusinessAreaComboTree(TmBusinessAreaVo tmBusinessAreaVo, HttpServletRequest request) {
        List<TmBusinessAreaVo> voList = this.tmBusinessAreaService.findTmBusinessAreaComboTree(tmBusinessAreaVo, request.getParameter("selfId"));
        return voList;
    }

    @RequestMapping(value={"goTmBusinessAreaForm"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTmBusinessAreaForm(HttpServletRequest request, TmBusinessAreaVo tmBusinessAreaVo) {
        request.setAttribute("extendTableName", (Object)Globals.TABLE_BUSINESS_AREA);
        String optype = request.getParameter("optype");
        request.setAttribute("optype", (Object)optype);
        if (StringUtil.isNotEmpty((String)tmBusinessAreaVo.getId())) {
            TmBusinessAreaVo vo = this.tmBusinessAreaService.getTmBusinessAreaVo(tmBusinessAreaVo.getId());
            request.setAttribute("tba", (Object)vo);
        }
        if (this.tmBusinessAreaFormExtendService != null) {
            request.setAttribute("includeJSP", (Object)this.tmBusinessAreaFormExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/businessArea/tmBusinessAreaForm");
    }

    @RequestMapping(value={"getAreaForCombobox"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public List<ComboBox> getAreaForCombobox(HttpServletRequest request, TmBusinessAreaExcelVo tba) {
        try {
            String name = request.getParameter("name");
            if (StringUtil.isNotEmpty((String)name)) {
                name = URLDecoder.decode(name, "UTF-8");
                tba.setBusinessAreaName(name);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this.tmBusinessAreaService.findBusinessAreaCombobox(tba);
    }

    @RequestMapping(value={"saveTmBusinessArea"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveTmBusinessArea(HttpServletRequest request, TmBusinessAreaVo tmBusinessAreaVo) {
        AjaxJson j = new AjaxJson();
        try {
            EuPage page = new EuPage(request);
            this.tmBusinessAreaService.saveTmBusinessArea(tmBusinessAreaVo, page);
            this.tmBusinessAreaService.updateIsLeafColumn("tm_business_area");
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("businessAreaCode", tmBusinessAreaVo.getBusinessAreaCode());
            attributes.put("text", tmBusinessAreaVo.getBusinessAreaName());
            j.setAttributes(attributes);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25:" + e.getMessage());
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(value={"deleteTmBusinessArea"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson deleteTmBusinessArea(String id) {
        try {
            this.tmBusinessAreaService.deleteTmBusinessArea(id);
            this.tmBusinessAreaService.updateIsLeafColumn("tm_business_area");
        }
        catch (Exception e) {
            return new AjaxJson("\u5220\u9664\u5931\u8d25:" + e.getMessage());
        }
        return new AjaxJson();
    }

    @RequestMapping(value={"validateBusinessAreaName"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ValidForm validateBusinessAreaName(HttpServletRequest request, TmBusinessAreaExcelVo tba) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        return validForm;
    }

    @RequestMapping(value={"validateBusinessAreaCode"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ValidForm validateBusinessAreaCode(HttpServletRequest request, TmBusinessAreaExcelVo tba) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        if (StringUtil.isNotEmpty((String)tba.getId())) {
            if (this.tmBusinessAreaService.validate(tba.getId(), param, "businessAreaCode")) {
                validForm.setStatus("n");
                validForm.setInfo("\u4e1a\u52a1\u533a\u57df\u7f16\u7801\u5df2\u5b58\u5728");
            }
        } else if (this.tmBusinessAreaService.validate(null, param, "businessAreaCode")) {
            validForm.setStatus("n");
            validForm.setInfo("\u4e1a\u52a1\u533a\u57df\u7f16\u7801\u5df2\u5b58\u5728");
        }
        return validForm;
    }

    @RequestMapping(value={"startTmBusinessArea"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson startTmBusinessArea(TmBusinessAreaVo tmBusinessAreaVo) {
        try {
            tmBusinessAreaVo.setEnableStatus(0);
            this.tmBusinessAreaService.updateBusinessAreaEnableStatus(tmBusinessAreaVo);
            return new AjaxJson();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson(e.getMessage());
        }
    }

    @RequestMapping(value={"stopTmBusinessArea"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson stopTmBusinessArea(TmBusinessAreaVo tmBusinessAreaVo) {
        try {
            tmBusinessAreaVo.setEnableStatus(1);
            this.tmBusinessAreaService.updateBusinessAreaEnableStatus(tmBusinessAreaVo);
            return new AjaxJson();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new AjaxJson(e.getMessage());
        }
    }

    @RequestMapping(value={"exportXls"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportXls(TmBusinessAreaVo tmBusinessAreaVo, HttpServletRequest request, HttpServletResponse response) {
        tmBusinessAreaVo.setExportExcel("true");
        List<TmBusinessAreaVo> tmBusinessAreaVoList = this.tmBusinessAreaService.findBusinessAreaList(tmBusinessAreaVo);
        this.doExportXls(response, request, tmBusinessAreaVoList, TmBusinessAreaVo.class, "\u884c\u653f\u533a\u57df\u5217\u8868");
    }
}

