/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.config.service.impl;

import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.MyBeanUtils;
import com.biz.eisp.base.common.util.ResourceConfigUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.config.dao.TmCgDynamicDao;
import com.biz.eisp.mdm.config.entity.TmCgDynamicHeadEntity;
import com.biz.eisp.mdm.config.entity.TmCgDynamicItemEntity;
import com.biz.eisp.mdm.config.service.TmCgDynamicService;
import com.biz.eisp.mdm.config.vo.TmCgDynamicHeadVo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="tmCgDynamicService")
@Transactional
public class TmCgDynamicServiceImpl
extends BaseServiceImpl
implements TmCgDynamicService {
    @Autowired
    TmCgDynamicDao tmCgDynamicDao;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public List<TmCgDynamicHeadVo> findCgDynamicHeadList(TmCgDynamicHeadVo tmCgDynamicHeadVo, Page page) {
        return this.tmCgDynamicDao.findCgDynamicHeadList(tmCgDynamicHeadVo, page);
    }

    @Override
    public void deleteCgDynamicHead(String id) {
        this.deleteEntityById(TmCgDynamicHeadEntity.class, (Serializable)((Object)id));
        List<TmCgDynamicItemEntity> cgreportConfigItemOldList = this.findByProperty(TmCgDynamicItemEntity.class, "cgrheadId", id);
        this.deleteAllEntity(cgreportConfigItemOldList);
    }

    @Override
    public void saveCgDynamicHead(TmCgDynamicHeadEntity cghead, List<TmCgDynamicItemEntity> cgDynamicItemEntities) {
        this.saveOrUpdate(cghead);
        for (TmCgDynamicItemEntity cgreportConfigItem : cgDynamicItemEntities) {
            cgreportConfigItem.setCgrheadId(cghead.getId());
            this.saveOrUpdate(cgreportConfigItem);
        }
    }

    @Override
    public void updateCgDynamicHead(TmCgDynamicHeadVo cgDynamicHeadVo, List<TmCgDynamicItemEntity> cgDynamicItemEntities) {
        TmCgDynamicHeadEntity cghead = this.get(TmCgDynamicHeadEntity.class, (Serializable)((Object)cgDynamicHeadVo.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean(cgDynamicHeadVo, cghead);
            this.saveOrUpdate(cghead);
            String id0 = cghead.getId();
            List<TmCgDynamicItemEntity> cgreportConfigItemOldList = this.findByProperty(TmCgDynamicItemEntity.class, "cgrheadId", id0);
            for (TmCgDynamicItemEntity oldE : cgreportConfigItemOldList) {
                boolean isUpdate = false;
                for (TmCgDynamicItemEntity sendE : cgDynamicItemEntities) {
                    if (!oldE.getId().equals(sendE.getId())) continue;
                    try {
                        MyBeanUtils.copyBeanNotNull2Bean(sendE, oldE);
                        this.saveOrUpdate(oldE);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new BusinessException(e.getMessage());
                    }
                    isUpdate = true;
                    break;
                }
                if (isUpdate) continue;
                super.delete(oldE);
            }
            for (TmCgDynamicItemEntity cgreportConfigItem : cgDynamicItemEntities) {
                if (!StringUtil.isEmpty(cgreportConfigItem.getId())) continue;
                cgreportConfigItem.setCgrheadId(cghead.getId());
                this.save(cgreportConfigItem);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<String> getSqlFields(String sql) {
        if (StringUtil.isEmpty(sql)) {
            return null;
        }
        List<Map<String, Object>> result = this.findForMapList(sql, new Object[0]);
        if (result.size() < 1) {
            throw new BusinessException("\u8be5\u62a5\u8868sql\u6ca1\u6709\u6570\u636e");
        }
        Set<String> fieldsSet = result.get(0).keySet();
        ArrayList<String> fileds = new ArrayList<String>(fieldsSet);
        return fileds;
    }

    @Override
    public Map<String, Object> queryCgReportConfig(String id) {
        HashMap<String, Object> cgReportM = new HashMap<String, Object>();
        Map mainM = this.tmCgDynamicDao.queryCgReportMainConfig(id);
        List<Map<String, Object>> itemsM = this.tmCgDynamicDao.queryCgReportItems(id);
        cgReportM.put("main", mainM);
        cgReportM.put("items", itemsM);
        return cgReportM;
    }

    public static String eispCreatePageSql(String sql, int page, int rows) {
        int beginNum = (page - 1) * rows;
        Object[] sqlParam = new String[]{sql, beginNum + "", rows + ""};
        String jdbcUrl = ResourceConfigUtils.getJdbcUrl();
        if (StringUtil.isNotEmpty((String)jdbcUrl)) {
            if (jdbcUrl.indexOf("mysql") != -1) {
                sql = MessageFormat.format("select * from ( {0}) sel_tab00 limit {1},{2}", sqlParam);
            } else if (jdbcUrl.indexOf("postgresql") != -1) {
                sql = MessageFormat.format("select * from ( {0}) sel_tab00 limit {2} offset {1}", sqlParam);
            } else {
                int beginIndex = (page - 1) * rows;
                int endIndex = beginIndex + rows;
                sqlParam[2] = Integer.toString(beginIndex);
                sqlParam[1] = Integer.toString(endIndex);
                if (jdbcUrl.indexOf("oracle") != -1) {
                    sql = MessageFormat.format("select * from (select row_.*,rownum rownum_ from ({0}) row_ where rownum <= {1}) where rownum_>{2}", sqlParam);
                } else if (jdbcUrl.indexOf("sqlserver") != -1) {
                    sqlParam[0] = sql.substring(TmCgDynamicServiceImpl.getAfterSelectInsertPoint(sql));
                    sql = MessageFormat.format("select * from ( select row_number() over(order by tempColumn) tempRowNumber, * from (select top {1} tempColumn = 0, {0}) t ) tt where tempRowNumber > {2}", sqlParam);
                }
            }
        } else {
            throw new BusinessException("\u6ca1\u6709\u83b7\u53d6\u5230\u6570\u636e\u5e93\u7c7b\u578b");
        }
        return sql;
    }

    private static int getAfterSelectInsertPoint(String sql) {
        int selectIndex = sql.toLowerCase().indexOf("select");
        int selectDistinctIndex = sql.toLowerCase().indexOf("select distinct");
        return selectIndex + (selectDistinctIndex == selectIndex ? 15 : 6);
    }

    public List<Map<String, Object>> findForJdbc(String sql, int page, int rows) {
        sql = TmCgDynamicServiceImpl.eispCreatePageSql(sql, page, rows);
        return this.jdbcTemplate.queryForList(sql);
    }

    public List<Map<String, Object>> findForJdbc(String sql, Object ... objs) {
        return this.jdbcTemplate.queryForList(sql, objs);
    }

    @Override
    public List<Map<String, Object>> queryByCgReportSql(String sql, Map params, int page, int rows) {
        String querySql = this.getFullSql(sql, params);
        List<Map<String, Object>> result = null;
        result = page == -1 && rows == -1 ? this.findForJdbc(querySql, new Object[0]) : this.findForJdbc(querySql, page, rows);
        return result;
    }

    private String getFullSql(String sql, Map params) {
        StringBuilder sqlB = new StringBuilder();
        sqlB.append("SELECT t.* FROM ( ");
        sqlB.append(sql + " ");
        sqlB.append(") t ");
        if (params.size() >= 1) {
            sqlB.append("WHERE 1=1  ");
            Iterator it = params.keySet().iterator();
            while (it.hasNext()) {
                String key = String.valueOf(it.next());
                String value = String.valueOf(params.get(key));
                if (StringUtil.isEmpty(value) || "null".equals(value)) continue;
                sqlB.append(" AND ");
                sqlB.append(" " + key + value);
            }
        }
        return sqlB.toString();
    }

    @Override
    public long countQueryByCgReportSql(String sql, Map params) {
        String querySql = this.getFullSql(sql, params);
        querySql = "SELECT COUNT(*) as countrow FROM (" + querySql + ") t2";
        List list = this.jdbcTemplate.queryForList(querySql);
        if (CollectionUtil.listNotEmpty(list)) {
            BigDecimal countrow = (BigDecimal)((Map)list.get(0)).get("countrow");
            return countrow.longValue();
        }
        return 0L;
    }
}

