/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.custorg.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.custorg.entity.TmCustomerOrgEntity;
import com.biz.eisp.mdm.custorg.service.TmCustOrgBackExtendService;
import com.biz.eisp.mdm.custorg.service.TmCustOrgFormExtendService;
import com.biz.eisp.mdm.custorg.service.TmCustOrgMainExtendService;
import com.biz.eisp.mdm.custorg.service.TmCustOrgService;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgBusinessVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgCustomerVo;
import com.biz.eisp.mdm.custorg.vo.TmCustOrgTerminalVo;
import com.biz.eisp.mdm.custorg.vo.TmCustomerOrgVo;
import com.biz.eisp.mdm.org.entity.TmOrgEntity;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmCustOrgController"})
public class TmCustOrgController
extends BaseController {
    @Autowired
    private TmCustOrgService tmCustOrgService;
    @Autowired(required=false)
    private TmCustOrgFormExtendService tmCustOrgFormExtendService;
    @Autowired(required=false)
    private TmCustOrgMainExtendService tmCustOrgMainExtendService;
    @Autowired(required=false)
    private TmCustOrgBackExtendService tmCustOrgBackExtendService;

    @RequestMapping(value={"goOrgMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goOrgMain(HttpServletRequest request) {
        request.setAttribute("extendTableName", (Object)Globals.TABLE_CUSTOMER_ORG);
        if (this.tmCustOrgMainExtendService != null) {
            request.setAttribute("includeJSP", (Object)this.tmCustOrgMainExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmCustOrgMain");
    }

    @RequestMapping(value={"goBusiness"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goBusiness(HttpServletRequest request) {
        String custOrgId = OConvertUtils.getString(request.getParameter("custOrgId"));
        if (StringUtil.isNotEmpty((String)custOrgId)) {
            request.setAttribute("custOrgId", (Object)custOrgId);
        }
        return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmCustOrgBusinessMain");
    }

    @RequestMapping(value={"goTmBusinessCheckedMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTmBusinessCheckedMain(TmCustOrgBusinessVo tmCustOrgBusinessVo, HttpServletRequest request) {
        request.setAttribute("custOrgId", (Object)(StringUtil.isNotEmpty((String)tmCustOrgBusinessVo.getCustOrgId()) ? tmCustOrgBusinessVo.getCustOrgId() : "-1"));
        return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmBusinessCheckedMain");
    }

    @RequestMapping(value={"goCustOrgForm"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goCustOrgForm(HttpServletRequest request, TmCustomerOrgVo tmCustomerOrgVo) {
        String optype = request.getParameter("optype");
        request.setAttribute("optype", (Object)optype);
        request.setAttribute("extendTableName", (Object)Globals.TABLE_CUSTOMER_ORG);
        if (StringUtil.isNotEmpty((String)tmCustomerOrgVo.getId())) {
            TmCustomerOrgVo vo = this.tmCustOrgService.getTmCustOrg(tmCustomerOrgVo.getId());
            request.setAttribute("custOrg", (Object)vo);
        }
        if (this.tmCustOrgFormExtendService != null) {
            request.setAttribute("includeJSP", (Object)this.tmCustOrgFormExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmCustOrgForm");
    }

    @RequestMapping(value={"goCustOrgTerminal"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goCustOrgTerminal(HttpServletRequest request) {
        String id = request.getParameter("id");
        request.setAttribute("custOrgId", (Object)id);
        return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmCustOrgTerminalMain");
    }

    @RequestMapping(value={"goCustOrgCustomer"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goCustOrgCustomer(HttpServletRequest request) {
        String id = request.getParameter("id");
        request.setAttribute("custOrgId", (Object)id);
        return new ModelAndView("com/biz/eisp/mdm/tmCustOrg/tmCustOrgCustomerMain");
    }

    @RequestMapping(value={"findNotRefBusinessGrid"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findNotRefBusinessList(TmCustOrgBusinessVo businessVo, HttpServletRequest request) {
        TmOrgEntity tmOrgEntity;
        EuPage page = new EuPage(request);
        if (StringUtil.isNotEmpty((String)businessVo.getOrgName()) && StringUtil.isNotEmpty(tmOrgEntity = this.tmCustOrgService.get(TmOrgEntity.class, (Serializable)((Object)businessVo.getOrgName())))) {
            businessVo.setOrgName(tmOrgEntity.getOrgName());
        }
        List<TmCustOrgBusinessVo> businessList = this.tmCustOrgService.findNotRefBusinessGrid(businessVo, page);
        return new DataGrid(businessList, page);
    }

    @RequestMapping(value={"findRefBusinessGrid"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public List<TmCustOrgBusinessVo> findRefBusinessList(TmCustOrgBusinessVo businessVo, HttpServletRequest request) {
        List<TmCustOrgBusinessVo> businessList = this.tmCustOrgService.findRefBusinessGrid(businessVo);
        return businessList;
    }

    @RequestMapping(value={"findTmCustomerOrgList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public List<TmCustomerOrgVo> findTmCustomerOrgList(HttpServletRequest request, TmCustomerOrgVo custOrgVo) {
        List<TmCustomerOrgVo> voList = this.tmCustOrgService.findTmCustomerOrgList(custOrgVo);
        return voList;
    }

    @RequestMapping(value={"findCustmerGrid"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findCustmerList(TmCustOrgCustomerVo tmCustOrgCustomerVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmCustOrgCustomerVo> customerList = this.tmCustOrgService.findTmCustomerByCustOrg(tmCustOrgCustomerVo, page);
        return new DataGrid(customerList, page);
    }

    @RequestMapping(value={"findTerminalGrid"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findTerminalList(TmCustOrgTerminalVo tmCustOrgTerminalVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        List<TmCustOrgTerminalVo> terminalList = this.tmCustOrgService.findTmTerminalByCustOrg(tmCustOrgTerminalVo, page);
        return new DataGrid(terminalList, page);
    }

    @RequestMapping(value={"getParentCustOrg"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public List<ComboTree> getParentOrg(HttpServletRequest request, ComboTree comboTree, TmCustomerOrgVo custOrgVo) {
        return this.tmCustOrgService.getParentCustOrgs(request, comboTree);
    }

    @RequestMapping(value={"saveOrUpdateCustOrg"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveOrUpdateOrg(HttpServletRequest request, TmCustomerOrgVo custOrgVo) {
        AjaxJson j = new AjaxJson();
        try {
            EuPage page = new EuPage(request);
            String id = this.tmCustOrgService.saveOrUpdateCustOrg(custOrgVo, page);
            this.tmCustOrgService.updateIsLeafColumn(Globals.TABLE_CUSTOMER_ORG);
            if (null != this.tmCustOrgBackExtendService) {
                this.tmCustOrgBackExtendService.afterSaveOrUpdateCustOrg(id);
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("custOrgCode", custOrgVo.getCustOrgCode());
            attributes.put("customerOrgName", custOrgVo.getCustomerOrgName());
            j.setAttributes(attributes);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25\uff1a" + e.getMessage());
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(value={"delCustOrg"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson delCustOrg(String ids) {
        AjaxJson j = this.tmCustOrgService.delCustOrg(ids);
        if (null != this.tmCustOrgBackExtendService) {
            this.tmCustOrgBackExtendService.afterDelCustOrg(ids);
        }
        return j;
    }

    @RequestMapping(value={"removeCustOrgBusiness"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson removeCustOrgBusiness(HttpServletRequest request) {
        String id = request.getParameter("id");
        String custOrgId = request.getParameter("custOrgId");
        AjaxJson ajaxJson = this.tmCustOrgService.removeCustOrgBusiness(id, custOrgId);
        if (null != this.tmCustOrgBackExtendService) {
            this.tmCustOrgBackExtendService.afterRemoveCustOrgBusiness(id, custOrgId);
        }
        return ajaxJson;
    }

    @RequestMapping(value={"addCustOrgBusiness"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson addCustOrgBusiness(HttpServletRequest request) {
        String id = request.getParameter("id");
        String custOrgId = request.getParameter("custOrgId");
        AjaxJson json = this.tmCustOrgService.addCustOrgBusiness(id, custOrgId);
        if (null != this.tmCustOrgBackExtendService) {
            this.tmCustOrgBackExtendService.afterAddCustOrgBusiness(id, custOrgId);
        }
        return json;
    }

    @RequestMapping(value={"validateCustOrgCode"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ValidForm validateOrgCode(TmCustomerOrgVo custOrgVo, HttpServletRequest request) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        SimpleExpression cr = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        if (StringUtil.isNotEmpty((String)custOrgVo.getId())) {
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)custOrgVo.getId());
            SimpleExpression cr3 = Restrictions.eq((String)"custOrgCode", (Object)param);
            List<TmCustomerOrgEntity> tmOrgByCodes = this.tmCustOrgService.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr, cr3, cr2});
            if (!CollectionUtils.isEmpty(tmOrgByCodes)) {
                validForm.setStatus("n");
                validForm.setInfo("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728");
            }
        } else {
            List<TmCustomerOrgEntity> tmOrgByCodes = this.tmCustOrgService.findByProperty(TmCustomerOrgEntity.class, "custOrgCode", param);
            if (!CollectionUtils.isEmpty(tmOrgByCodes)) {
                validForm.setStatus("n");
                validForm.setInfo("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728");
            }
        }
        return validForm;
    }

    @RequestMapping(value={"validateCustOrgName"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ValidForm validateOrgName(TmCustomerOrgVo custOrgVo, HttpServletRequest request) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        ValidForm validForm = new ValidForm();
        SimpleExpression cr = Restrictions.eq((String)"enableStatus", (Object)Globals.ZERO);
        if (StringUtil.isNotEmpty((String)custOrgVo.getId())) {
            SimpleExpression cr1 = Restrictions.eq((String)"customerOrgName", (Object)param);
            SimpleExpression cr2 = Restrictions.ne((String)"id", (Object)custOrgVo.getId());
            List<TmCustomerOrgEntity> tmOrgs = this.tmCustOrgService.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr, cr1, cr2});
            if (!CollectionUtils.isEmpty(tmOrgs)) {
                validForm.setStatus("n");
                validForm.setInfo("\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728");
            }
        } else {
            SimpleExpression cr3 = Restrictions.eq((String)"customerOrgName", (Object)param);
            List<TmCustomerOrgEntity> tmOrgs = this.tmCustOrgService.findByCriteria(TmCustomerOrgEntity.class, new Criterion[]{cr, cr3});
            if (!CollectionUtils.isEmpty(tmOrgs)) {
                validForm.setStatus("n");
                validForm.setInfo("\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728");
            }
        }
        return validForm;
    }

    @RequestMapping(value={"getParentCustOrgs"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public List<ComboTree> getParentOrgs(HttpServletRequest request, ComboTree comboTree, TmCustomerOrgVo custOrgVo) {
        return this.tmCustOrgService.getParentCustOrg(request, comboTree);
    }

    @RequestMapping(value={"exportXls"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportXls(TmCustomerOrgVo custOrgVo, HttpServletRequest request, HttpServletResponse response) {
        custOrgVo.setExportExcel("true");
        List<TmCustomerOrgVo> custOrgVoList = this.tmCustOrgService.findTmCustomerOrgList(custOrgVo);
        this.doExportXls(response, request, custOrgVoList, TmCustomerOrgVo.class, "\u5ba2\u6237\u7ec4\u7ec7\u5217\u8868");
    }
}

