/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.custuser.service.impl;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.importer.ImpEventHandler;
import com.biz.eisp.base.importer.validator.ValidateException;
import com.biz.eisp.base.importer.validator.ValidatorFactory;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.config.entity.TmMdmTableConfigEntity;
import com.biz.eisp.mdm.config.util.DynamicConfigUtil;
import com.biz.eisp.mdm.customer.entity.TmCustomerEntity;
import com.biz.eisp.mdm.custuser.entity.TmRUserCustomerEntity;
import com.biz.eisp.mdm.custuser.service.TmCustUserBackExtendService;
import com.biz.eisp.mdm.custuser.service.TmCustUserService;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class TmCustUserEventHandler
extends ImpEventHandler<TmUserVo> {
    private TmCustUserService tmUserService = (TmCustUserService)ApplicationContextUtils.getContext().getBean("tmCustUserService");
    private TmCustUserBackExtendService tmCustUserBackExtendService;
    private List<String> saveIdList;

    public TmCustUserEventHandler() {
        String[] beanNamesForBackExtendService = ApplicationContextUtils.getContext().getBeanNamesForType(TmCustUserBackExtendService.class);
        if (beanNamesForBackExtendService.length > 0) {
            this.tmCustUserBackExtendService = (TmCustUserBackExtendService)ApplicationContextUtils.getContext().getBean(beanNamesForBackExtendService[0], TmCustUserBackExtendService.class);
        }
        this.saveIdList = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public void endRow(Map<String, Object> row, TmUserVo bean) throws ValidateException {
        bean.setPassword("123456");
        bean.setUserType(Globals.CUST_USER);
        try {
            EuPage page = new EuPage();
            String id = this.tmUserService.saveTmUser(bean, page);
            this.saveIdList.add(id);
        }
        catch (Exception e) {
            this.addError("\u7b2c" + this.getRowNumber() + "\u884c\u9047\u5230\u9519\u8bef:" + e.getMessage());
            e.printStackTrace();
        }
        this.setSuccNum(this.getSuccNum() + 1);
    }

    @Override
    public void validate(Map<String, Object> row) throws ValidateException {
        Object roleCode;
        List cfList = (List)DynamicConfigUtil.allTableConfigImpColumn.get(this.tableName.toUpperCase());
        for (TmMdmTableConfigEntity tableConfig : cfList) {
            String hql;
            List result;
            Object fieldValue;
            String errorMsg = ValidatorFactory.validateDynamicImplData(tableConfig, fieldValue = row.get(tableConfig.getField()));
            if (StringUtil.isNotEmpty((String)errorMsg)) {
                this.addError("\u7b2c" + this.getRowNumber() + "\u884c:" + errorMsg);
            }
            if (!StringUtil.equals("userName", tableConfig.getField()) || (result = this.tmUserService.findByHql(hql = " from TmUserEntity where userType=0 and userName=?", fieldValue)) == null || result.size() <= 0) continue;
            this.addError("\u7b2c" + this.getRowNumber() + "\u884c,\u767b\u5f55\u8d26\u53f7" + fieldValue + "\u5df2\u5b58\u5728\u6216\u51fa\u73b0\u91cd\u590d");
        }
        Object customerCode = row.get("custId");
        if (StringUtil.isNotEmpty(customerCode)) {
            TmCustomerEntity entity = this.tmUserService.findUniqueByProperty(TmCustomerEntity.class, "customerCode", customerCode);
            if (entity == null || StringUtil.isEmpty(entity.getId())) {
                this.addError("\u7b2c" + this.getRowNumber() + "\u884c,\u5ba2\u6237\u7f16\u7801" + customerCode + "\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
            } else {
                List<TmRUserCustomerEntity> lists;
                if (entity.getEnableStatus() == 1) {
                    this.addError("\u5ba2\u6237\u4fe1\u606f[" + customerCode + "]\u5df2\u505c\u7528");
                }
                if ((lists = this.tmUserService.findByProperty(TmRUserCustomerEntity.class, "tmCustomer.id", entity.getId())) != null && lists.size() > 0) {
                    this.addError("\u7b2c" + this.getRowNumber() + "\u884c,\u5ba2\u6237" + customerCode + "\u5df2\u7ed1\u5b9a\u7528\u6237");
                } else {
                    row.put("custId", entity.getId());
                }
            }
        }
        if (StringUtil.isNotEmpty(roleCode = row.get("roleIds"))) {
            String[] roles = roleCode.toString().split(",");
            String roleIds = "";
            ArrayList<String> list = new ArrayList<String>();
            for (String role : roles) {
                TmRoleEntity entity = this.tmUserService.findUniqueByProperty(TmRoleEntity.class, "roleCode", role);
                if (entity == null) {
                    this.addError("\u7b2c" + this.getRowNumber() + "\u884c,\u89d2\u8272\u7f16\u7801" + role + "\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728");
                }
                if (list.contains(role)) {
                    this.addError("\u7b2c" + this.getRowNumber() + "\u884c,\u89d2\u8272\u7f16\u7801" + role + "\u5b58\u5728\u91cd\u590d\u9879");
                }
                list.add(role);
                if (!StringUtil.isNotEmpty(entity)) continue;
                roleIds = roleIds + entity.getId() + ",";
            }
            if (StringUtil.isNotEmpty((String)roleIds)) {
                row.put("roleIds", roleIds.substring(0, roleIds.length() - 1));
            }
        }
    }

    @Override
    public void impEnd() {
        if (null != this.tmCustUserBackExtendService) {
            this.tmCustUserBackExtendService.afterImportCustUser(this.saveIdList);
        }
    }
}

