/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.dict.util;

import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.redis.cache.IRedisCacheService;
import com.biz.eisp.base.core.redis.cache.IRedisDictCacheService;
import com.biz.eisp.base.core.redis.util.RedisUtils;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.base.utils.DBConfigUtil;
import com.biz.eisp.mdm.dict.vo.TmDictDataVo;
import com.biz.eisp.mdm.dict.vo.TmDictTypeVo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class DictUtil {
    private static DBConfigUtil dbConfigUtil = (DBConfigUtil)ApplicationContextUtils.getContext().getBean(DBConfigUtil.class);
    public static final HashMap<String, Long> versionMap = new HashMap();
    public static Map<String, TmDictTypeVo> allDictType = new HashMap<String, TmDictTypeVo>();
    public static Map<String, List<TmDictDataVo>> allDictData = new HashMap<String, List<TmDictDataVo>>();

    public static List<TmDictDataVo> getDictList(String typCode) {
        ArrayList<TmDictDataVo> dictList = new ArrayList();
        IRedisCacheService redisCacheService = RedisUtils.getIRedisCacheService();
        if (redisCacheService != null) {
            Long now = redisCacheService.incrBy(dbConfigUtil.getJdbcUserName() + "_dict_version", 0L);
            Long old = versionMap.get(dbConfigUtil.getJdbcUserName() + "_dict_version");
            if (old == null) {
                old = -1L;
            }
            if (now.intValue() != old.intValue()) {
                versionMap.put(dbConfigUtil.getJdbcUserName() + "_dict_version", now);
                try {
                    List<TmDictTypeVo> typeVos = redisCacheService.getMapValues(dbConfigUtil.getJdbcUserName() + "_dict_json_type", TmDictTypeVo.class);
                    if (CollectionUtils.isEmpty(typeVos)) {
                        allDictType.clear();
                        allDictData.clear();
                        for (int i = 0; i < typeVos.size(); ++i) {
                            allDictType.put(typeVos.get(i).getDictTypeCode(), typeVos.get(i));
                            List<TmDictDataVo> vos = redisCacheService.getMapValues(dbConfigUtil.getJdbcUserName() + "_dict_json_data" + typeVos.get(i).getDictTypeCode(), TmDictDataVo.class);
                            allDictData.put(typeVos.get(i).getDictTypeCode(), vos);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        dictList = allDictData.get(typCode);
        return dictList;
    }

    public static String getDictDataValueByCode(String typeCode, String dataCode) {
        String dataValue = "";
        IRedisDictCacheService redisDictCacheService = RedisUtils.getIRedisDictCacheService();
        if (redisDictCacheService != null) {
            dataValue = redisDictCacheService.getDictDataValueByCode(typeCode, dataCode);
        } else {
            List<TmDictDataVo> dictDatas = DictUtil.getDictList(typeCode);
            if (CollectionUtil.listNotEmptyNotSizeZero(dictDatas)) {
                for (TmDictDataVo tmDictDataVo : dictDatas) {
                    if (!dataCode.equals(tmDictDataVo.getDictCode())) continue;
                    dataValue = tmDictDataVo.getDictValue();
                }
            }
        }
        return dataValue;
    }

    public static String getDictCodeByValue(String typeCode, String dataValue) {
        String dataCode = "";
        IRedisDictCacheService redisDictCacheService = RedisUtils.getIRedisDictCacheService();
        if (redisDictCacheService != null) {
            dataCode = redisDictCacheService.getDictCodeByValue(typeCode, dataValue);
        } else {
            List<TmDictDataVo> dictDatas = DictUtil.getDictList(typeCode);
            if (CollectionUtil.listNotEmptyNotSizeZero(dictDatas)) {
                for (TmDictDataVo tmDictDataVo : dictDatas) {
                    if (!dataValue.trim().equals(tmDictDataVo.getDictValue())) continue;
                    dataCode = tmDictDataVo.getDictCode();
                }
            }
        }
        return dataCode;
    }

    public static String getDictDatasByCodes(String typeCode, String dataValues) {
        String dataCodes = "";
        IRedisDictCacheService redisDictCacheService = RedisUtils.getIRedisDictCacheService();
        if (redisDictCacheService != null) {
            dataCodes = redisDictCacheService.getDictDatasByCodes(typeCode, dataValues);
        } else if (StringUtil.isNotEmpty((String)dataValues)) {
            if (dataValues.indexOf(",") != -1) {
                for (String value : dataValues.split(",")) {
                    if (StringUtil.isNotEmpty((String)dataCodes)) {
                        dataCodes = dataCodes + ",";
                    }
                    dataCodes = dataCodes + DictUtil.getDictDataValueByCode(typeCode, value);
                }
            } else {
                dataCodes = dataCodes + DictUtil.getDictDataValueByCode(typeCode, dataValues);
            }
        }
        return dataCodes;
    }

    public static TmDictDataVo getDicData(String typeCode, String dataCode) {
        TmDictDataVo data = null;
        IRedisDictCacheService redisDictCacheService = RedisUtils.getIRedisDictCacheService();
        if (redisDictCacheService != null) {
            data = redisDictCacheService.getDicData(typeCode, dataCode);
        } else {
            List<TmDictDataVo> dictDatas = DictUtil.getDictList(typeCode);
            if (CollectionUtil.listNotEmptyNotSizeZero(dictDatas)) {
                for (TmDictDataVo tmDictDataVo : dictDatas) {
                    if (!dataCode.equals(tmDictDataVo.getDictCode())) continue;
                    data = tmDictDataVo;
                }
            }
        }
        return data;
    }

    public static String getDicDataValue(String typeCode, String dataCode) {
        String dataVal = null;
        IRedisDictCacheService redisDictCacheService = RedisUtils.getIRedisDictCacheService();
        if (redisDictCacheService != null) {
            dataVal = redisDictCacheService.getDicDataValue(typeCode, dataCode);
        } else {
            List<TmDictDataVo> dictDatas = DictUtil.getDictList(typeCode);
            if (CollectionUtil.listNotEmptyNotSizeZero(dictDatas)) {
                for (TmDictDataVo tmDictDataEntity : dictDatas) {
                    if (!dataCode.equals(tmDictDataEntity.getDictCode())) continue;
                    dataVal = tmDictDataEntity.getDictValue();
                }
            }
        }
        return dataVal;
    }
}

