/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.function.entity;

import com.biz.eisp.base.common.identity.IdEntity;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Proxy;

@Entity
@Table(name="tm_function")
@Proxy(lazy=false)
@JsonIgnoreProperties(value={"hibernateLazyInitializer"})
public class TmFunctionEntity
extends IdEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String functionName;
    private Short functionLevel;
    private String functionUrl;
    private Integer functionOrder;
    private Date createDate;
    private String createName;
    private Date updateDate;
    private String updateName;
    private String headString;
    private Integer status;
    private TmFunctionEntity tmFunction;
    private TmIconEntity tmIcon;
    private List<TmFunctionEntity> tmFunctionList = new ArrayList<TmFunctionEntity>();
    private Integer isSystem;

    @Column(name="create_date", nullable=true)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @Column(name="create_name", nullable=true, length=32)
    public String getCreateName() {
        return this.createName;
    }

    @Column(name="status")
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    @Column(name="update_date", nullable=true)
    public Date getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Date updateDate) {
        this.updateDate = updateDate;
    }

    @Column(name="update_name", nullable=true)
    public String getUpdateName() {
        return this.updateName;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }

    @Column(name="function_name", nullable=false)
    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    @Column(name="function_level")
    public Short getFunctionLevel() {
        return this.functionLevel;
    }

    public void setFunctionLevel(Short functionLevel) {
        this.functionLevel = functionLevel;
    }

    @Column(name="function_url")
    public String getFunctionUrl() {
        return this.functionUrl;
    }

    public void setFunctionUrl(String functionUrl) {
        this.functionUrl = functionUrl;
    }

    @Column(name="function_order")
    public Integer getFunctionOrder() {
        return this.functionOrder;
    }

    public void setFunctionOrder(Integer functionOrder) {
        this.functionOrder = functionOrder;
    }

    @Column(name="headstring")
    public String getHeadString() {
        return this.headString;
    }

    public void setHeadString(String headString) {
        this.headString = headString;
    }

    public boolean hasSubFunction(Map<Integer, List<TmFunctionEntity>> map) {
        if (map.containsKey(this.getFunctionLevel() + 1)) {
            return this.hasSubFunction(map.get(this.getFunctionLevel() + 1));
        }
        return false;
    }

    public boolean hasSubFunction(List<TmFunctionEntity> functions) {
        for (TmFunctionEntity f : functions) {
            if (!f.getTmFunction().getId().equals(this.getId())) continue;
            return true;
        }
        return false;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="icon_id")
    public TmIconEntity getTmIcon() {
        return this.tmIcon;
    }

    public void setTmIcon(TmIconEntity tmIcon) {
        this.tmIcon = tmIcon;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="parent_id")
    public TmFunctionEntity getTmFunction() {
        return this.tmFunction;
    }

    public void setTmFunction(TmFunctionEntity tmFunction) {
        this.tmFunction = tmFunction;
    }

    @Fetch(value=FetchMode.SUBSELECT)
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="tmFunction")
    public List<TmFunctionEntity> getTmFunctionList() {
        return this.tmFunctionList;
    }

    public void setTmFunctionList(List<TmFunctionEntity> tmFunctionList) {
        this.tmFunctionList = tmFunctionList;
    }

    @Column(name="is_system")
    public Integer getIsSystem() {
        return this.isSystem;
    }

    public void setIsSystem(Integer isSystem) {
        this.isSystem = isSystem;
    }
}

