/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.operation.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.icon.entity.TmIconEntity;
import com.biz.eisp.mdm.operation.entity.TmOperationEntity;
import com.biz.eisp.mdm.operation.service.OperationService;
import com.biz.eisp.mdm.operation.transformer.TmOperationEntityToTmOperationVo;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/operationController"})
public class OperationController
extends BaseController {
    @Autowired
    private OperationService operationService;

    @RequestMapping(value={"operationList"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView operationList(HttpServletRequest request, String functionId) {
        request.setAttribute("functionId", (Object)functionId);
        return new ModelAndView("com/biz/eisp/mdm/operation/operationList");
    }

    @RequestMapping(value={"operation"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView operation(HttpServletRequest request, String functionId, TmOperationEntity operation) {
        if (StringUtil.isNotEmpty((String)operation.getId())) {
            operation = this.operationService.get(TmOperationEntity.class, (Serializable)((Object)operation.getId()));
        }
        request.setAttribute("operation", (Object)operation);
        List<TmIconEntity> iconlist = this.operationService.findByProperty(TmIconEntity.class, "iconType", 20);
        request.setAttribute("iconlist", iconlist);
        request.setAttribute("functionId", (Object)functionId);
        return new ModelAndView("com/biz/eisp/mdm/operation/operation");
    }

    @RequestMapping(value={"operationGrid"}, method={RequestMethod.GET, RequestMethod.POST})
    public void operationGrid(String functionId, HttpServletRequest request, HttpServletResponse response) {
        List<TmOperationEntity> result = this.operationService.getOperationList(functionId);
        List voList = Lists.transform(result, (Function)new TmOperationEntityToTmOperationVo());
        super.datagridReturn(response, voList);
    }

    @RequestMapping(value={"saveOperation"}, method={RequestMethod.GET, RequestMethod.POST})
    public void saveFunction(HttpServletRequest request, HttpServletResponse response, TmOperationEntity operation) {
        String msg = this.operationService.saveOperation(operation);
        this.message = StringUtil.isNotEmpty((String)msg) ? msg : this.message;
        this.sendResponse(response);
    }

    @RequestMapping(value={"deleteOperation"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public JSONObject deleteOperation(HttpServletRequest request, HttpServletResponse response, String id) {
        try {
            TmOperationEntity operation = this.operationService.get(TmOperationEntity.class, (Serializable)((Object)id));
            this.operationService.delete(operation);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff01";
        }
        return this.returnJson();
    }
}

