/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.role.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ComboTree;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.mdm.authobj.service.TmFunAuthService;
import com.biz.eisp.mdm.authobj.vo.TmFunctionAuthVo;
import com.biz.eisp.mdm.dict.vo.TmDictDataAuVo;
import com.biz.eisp.mdm.function.service.TmFunctionService;
import com.biz.eisp.mdm.operation.entity.TmOperationEntity;
import com.biz.eisp.mdm.role.entity.TmRoleEntity;
import com.biz.eisp.mdm.role.service.TmRoleService;
import com.biz.eisp.mdm.role.vo.TmRoleInfoExportVo;
import com.biz.eisp.mdm.role.vo.TmRoleVo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tMroleController"})
public class TmRoleController
extends BaseController {
    @Autowired
    private TmFunctionService functionService;
    @Autowired
    private TmRoleService tmRoleService;
    @Autowired
    private TmFunAuthService tmFunAuthService;

    @RequestMapping(value={"goRoleList"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goRoleList(HttpServletRequest request) {
        request.setAttribute("extendTableName", (Object)Globals.TABLE_ROLE);
        return new ModelAndView("com/biz/eisp/mdm/role/tmRoleMain");
    }

    @RequestMapping(value={"goTmRoleCheckedMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTmRoleCheckedMain(TmRoleVo tmRoleVo, HttpServletRequest request) {
        if (StringUtil.isNotEmpty((String)tmRoleVo.getPosId())) {
            request.setAttribute("posId", (Object)tmRoleVo.getPosId());
        } else {
            request.setAttribute("posId", (Object)"-1");
        }
        if (StringUtil.isNotEmpty((String)tmRoleVo.getUserId())) {
            request.setAttribute("userId", (Object)tmRoleVo.getUserId());
        } else {
            request.setAttribute("userId", (Object)"-1");
        }
        return new ModelAndView("com/biz/eisp/mdm/role/tmRoleCheckedMain");
    }

    @RequestMapping(value={"findRoleList"}, method={RequestMethod.GET, RequestMethod.POST})
    public void findRoleList(HttpServletRequest request, TmRoleVo tmRoleVo, HttpServletResponse response) {
        String pagination = OConvertUtils.getString(request.getParameter("pagination"));
        EuPage page = new EuPage(request);
        if (StringUtil.isNotEmpty((String)pagination)) {
            page = null;
        }
        List<TmRoleEntity> roles = this.tmRoleService.findRoleList(tmRoleVo, page);
        if (StringUtil.isNotEmpty((String)pagination)) {
            this.datagridReturn(response, roles);
        } else {
            this.datagridReturn(response, roles, page);
        }
    }

    @RequestMapping(value={"getRoleListByUserPost"}, method={RequestMethod.GET, RequestMethod.POST})
    public void getRoleListByUserPost(HttpServletRequest request, TmRoleVo tmRoleVo, HttpServletResponse response) {
        String pagination = OConvertUtils.getString(request.getParameter("pagination"));
        EuPage page = new EuPage(request);
        if (StringUtil.isNotEmpty((String)pagination)) {
            page = null;
        }
        List<TmRoleEntity> roles = this.tmRoleService.getRoleListByCurrentPosId(tmRoleVo, page);
        if (StringUtil.isNotEmpty((String)pagination)) {
            this.datagridReturn(response, roles);
        } else {
            this.datagridReturn(response, roles, page);
        }
    }

    @RequestMapping(value={"goRoleForm"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goRoleForm(HttpServletRequest request) {
        String id = OConvertUtils.getString(request.getParameter("id"));
        if (StringUtil.isNotEmpty((String)id)) {
            TmRoleEntity roleEntity = this.tmRoleService.get(TmRoleEntity.class, (Serializable)((Object)id));
            request.setAttribute("role", (Object)roleEntity);
        }
        String optype = request.getParameter("optype");
        request.setAttribute("optype", (Object)optype);
        request.setAttribute("extendTableName", (Object)Globals.TABLE_ROLE);
        return new ModelAndView("com/biz/eisp/mdm/role/tmRoleForm");
    }

    @RequestMapping(value={"validFormRoleForm"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ValidForm validFormRoleForm(HttpServletRequest request, TmRoleEntity tmRoleEntity) {
        String param = OConvertUtils.getString(request.getParameter("param"));
        String flag = OConvertUtils.getString(request.getParameter("flag"));
        if (StringUtil.isNotEmpty((String)flag) && flag.equalsIgnoreCase("roleName")) {
            tmRoleEntity.setRoleName(param);
        }
        if (StringUtil.isNotEmpty((String)flag) && flag.equalsIgnoreCase("roleCode")) {
            tmRoleEntity.setRoleCode(param);
        }
        return this.tmRoleService.validateTmRoleForm(tmRoleEntity);
    }

    @RequestMapping(value={"saveRoleForm"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveRoleForm(HttpServletRequest request, TmRoleVo tmRoleVo) {
        AjaxJson j = new AjaxJson();
        try {
            EuPage page = new EuPage(request);
            this.tmRoleService.createTmRole(tmRoleVo, page);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u89d2\u8272\u5931\u8d25");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(value={"delete"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson delete(String id) {
        AjaxJson j = new AjaxJson();
        try {
            if (this.tmRoleService.deleteTmRole(id)) {
                j.setMsg("\u5220\u9664\u89d2\u8272\u6210\u529f");
            } else {
                j.setSuccess(false);
                j.setMsg("\u8d85\u7ea7\u7ba1\u7406\u5458\u89d2\u8272\u4e0d\u80fd\u88ab\u5220\u9664");
            }
        }
        catch (Exception e1) {
            j.setSuccess(false);
            j.setMsg("\u5220\u9664\u5931\u8d25,\u8be5\u89d2\u8272\u5df2\u7ecf\u5173\u8054\u5176\u4ed6\u6570\u636e");
            e1.printStackTrace();
        }
        return j;
    }

    @RequestMapping(value={"update"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> update(TmRoleEntity tmRole) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        Map<String, String> map = this.tmRoleService.updateTmRole(tmRole);
        if ("true".equals(map.get("success"))) {
            model.put("success", true);
        } else {
            model.put("success", false);
            model.put("msg", map.get("msg"));
        }
        return model;
    }

    @RequestMapping(value={"startOrStopRole"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson startOrStopRole(TmRoleVo tmRoleVo) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.tmRoleService.startOrStopRole(tmRoleVo);
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(value={"goPermSetting"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goPermSetting(HttpServletRequest request) {
        String roleId = OConvertUtils.getString(request.getParameter("roleId"));
        request.setAttribute("roleId", (Object)roleId);
        return new ModelAndView("com/biz/eisp/mdm/role/permSetting");
    }

    @RequestMapping(value={"getMenuInfoTreeByRole"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public List<ComboTree> getMenuInfoTreeByRole(HttpServletRequest request, ComboTree comboTree) {
        String roleId = request.getParameter("roleId");
        List<ComboTree> trees = this.functionService.getAllFuncAndHandleCheck(request, comboTree, roleId);
        return trees;
    }

    @RequestMapping(value={"getOpetateInfoByRoleFunc"}, method={RequestMethod.GET, RequestMethod.POST})
    public void getOpetateInfoByRoleFunc(HttpServletRequest request, HttpServletResponse response, String roleId, String functionId) {
        try {
            List<TmOperationEntity> operations = this.functionService.getOptByRoleFunc(roleId, functionId);
            JSONArray operationsJson = JSONArray.parseArray((String)JSONObject.toJSONString(operations));
            this.sendResponseState(response, true, operationsJson);
        }
        catch (Exception e) {
            this.message = "\u83b7\u53d6\u6309\u94ae\u4fe1\u606f\u5931\u8d25";
            e.printStackTrace();
            this.sendResponseState(response, false, null);
        }
    }

    @RequestMapping(value={"setFuncRole"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson setFuncRole(HttpServletResponse response, String roleId, String funcIds) {
        AjaxJson j = new AjaxJson();
        try {
            this.functionService.delExistFuncRole(roleId, funcIds);
            this.functionService.setFuncRole(roleId, funcIds);
        }
        catch (Exception e) {
            j.setMsg("\u4fee\u6539\u83dc\u5355\u6743\u9650\u5931\u8d25");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(value={"setOperateByFuncRole"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson setOperateByFuncRole(HttpServletResponse response, String opretionIds, String roleId, String funcId) {
        AjaxJson j = new AjaxJson();
        try {
            this.functionService.setOperateByFuncRole(opretionIds, roleId, funcId);
        }
        catch (Exception e) {
            j.setMsg("\u4fee\u6539\u6309\u94ae\u6743\u9650\u5931\u8d25");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(value={"getAuthObj"}, method={RequestMethod.GET, RequestMethod.POST})
    public void getAuthObj(HttpServletResponse response, String roleId, String funcId) {
        try {
            List<TmFunctionAuthVo> authVos = this.functionService.getAuthObjByFunc(roleId, funcId);
            JSONArray obj = JSONArray.parseArray((String)JSONObject.toJSONString(authVos));
            this.sendResponseState(response, true, obj);
        }
        catch (Exception e) {
            this.message = "\u83b7\u53d6\u6743\u9650\u5bf9\u8c61\u5931\u8d25";
            this.sendResponseState(response, false, null);
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"getAuthObjValue"}, method={RequestMethod.GET, RequestMethod.POST})
    public void getAuthObjValue(HttpServletResponse response, String roleId, String funcId, String authObj) {
        try {
            List<TmDictDataAuVo> dataVos = this.tmFunAuthService.getTmFunAuthValueByRoleFunc(roleId, funcId, authObj);
            JSONArray obj = JSONArray.parseArray((String)JSONObject.toJSONString(dataVos));
            this.sendResponseState(response, true, obj);
        }
        catch (Exception e) {
            this.message = "\u83b7\u53d6\u6743\u9650\u5bf9\u8c61\u503c\u5931\u8d25";
            this.sendResponseState(response, false, null);
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"setAuthObjValue"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson setAuthObjValue(String roleId, String funcId, String authObj, String authCodes) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            this.tmFunAuthService.saveFunAuthValue(roleId, funcId, authObj, authCodes);
        }
        catch (Exception e) {
            ajaxJson.setMsg("\u8bbe\u7f6e\u6743\u9650\u503c\u5931\u8d25");
            ajaxJson.setSuccess(false);
            e.printStackTrace();
        }
        return ajaxJson;
    }

    @RequestMapping(value={"goNoSelfRoleMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goNoSelfRoleMain(HttpServletRequest request) {
        return new ModelAndView("com/biz/eisp/mdm/role/noSelfRoleMain");
    }

    @RequestMapping(value={"findNoSelfRoleList"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public DataGrid findNoSelfRoleList(HttpServletRequest request, TmRoleVo tmRoleVo, String selfRoleId) {
        EuPage page = new EuPage(request);
        List<TmRoleVo> voList = this.tmRoleService.findNoSelfRoleList(tmRoleVo, selfRoleId, page);
        return new DataGrid(voList, page);
    }

    @RequestMapping(value={"exportXls"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportXls(TmRoleInfoExportVo tmRoleInfoExportVo, HttpServletRequest request, HttpServletResponse response) {
        List<TmRoleInfoExportVo> voList = this.tmRoleService.findExportRoleInfoList(tmRoleInfoExportVo);
        this.doExportXls(response, request, voList, TmRoleInfoExportVo.class, "\u6743\u9650\u89d2\u8272\u5217\u8868");
    }
}

