/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.mdm.user.controller;

import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.web.BaseController;
import com.biz.eisp.base.utils.SysConfigUtils;
import com.biz.eisp.mdm.user.service.TmUserBackExtendService;
import com.biz.eisp.mdm.user.service.TmUserFormExtendService;
import com.biz.eisp.mdm.user.service.TmUserMainExtendService;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/tmUserController"})
public class TmUserController
extends BaseController {
    @Autowired
    private TmUserService tmUserService;
    @Autowired(required=false)
    private TmUserBackExtendService tmUserBackExtendService;
    @Autowired(required=false)
    private TmUserFormExtendService tmUserFormExtendService;
    @Autowired(required=false)
    private TmUserMainExtendService tmUserMainExtendService;
    @Autowired
    private SysConfigUtils sysConfigUtils;

    @RequestMapping(value={"goTmUserMain"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTmUserMain(HttpServletRequest request) {
        request.setAttribute("extendTableName", (Object)Globals.TABLE_USER);
        if (this.tmUserMainExtendService != null) {
            request.setAttribute("includeJsp", (Object)this.tmUserMainExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmUser/tmUserMain");
    }

    @RequestMapping(value={"goTmUserForm"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTmUserForm(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
        List<TmUserVo> tmUserVoList;
        if (StringUtil.isNotEmpty((String)tmUserVo.getId()) && (tmUserVoList = this.tmUserService.findTmUserList(tmUserVo, null)) != null && tmUserVoList.size() > 0) {
            TmUserVo vo = tmUserVoList.get(0);
            if (StringUtil.isNotEmpty(vo)) {
                vo.setPassword("******");
            }
            request.setAttribute("vo", (Object)vo);
        }
        String optype = request.getParameter("optype");
        request.setAttribute("optype", (Object)optype);
        request.setAttribute("extendTableName", (Object)Globals.TABLE_USER);
        if (this.tmUserFormExtendService != null) {
            request.setAttribute("includeJsp", (Object)this.tmUserFormExtendService.includeJsp());
        }
        return new ModelAndView("com/biz/eisp/mdm/tmUser/tmUserForm");
    }

    @RequestMapping(value={"findTmUserList"}, method={RequestMethod.GET, RequestMethod.POST})
    public void findTmUserList(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
        EuPage page = new EuPage(request);
        tmUserVo.setUserType(Globals.ENTERPRISE_USER);
        List<TmUserVo> tmUserVoList = this.tmUserService.findTmUserListNew(tmUserVo, page);
        this.datagridReturn(response, tmUserVoList, page);
    }

    @RequestMapping(value={"findTmUserBySearchList"}, method={RequestMethod.GET, RequestMethod.POST})
    public void findTmUserBySearchList(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
        List<TmUserVo> tmUserVoList;
        EuPage page = new EuPage(request);
        tmUserVo.setUserType(Globals.ENTERPRISE_USER);
        if (StringUtil.isNotEmpty((String)tmUserVo.getSearchParam())) {
            tmUserVo.setFullName(tmUserVo.getSearchParam());
        }
        try {
            tmUserVoList = this.tmUserService.findTmUserList(tmUserVo, page);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25," + e.getMessage());
        }
        this.datagridReturn(response, tmUserVoList, page);
    }

    @RequestMapping(value={"getTmUserBySearch"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson getTmUserBySearch(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson json = new AjaxJson();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        EuPage page = new EuPage(request);
        tmUserVo.setUserType(Globals.ENTERPRISE_USER);
        if (StringUtil.isNotEmpty((String)tmUserVo.getSearchParam())) {
            tmUserVo.setFullName(tmUserVo.getSearchParam());
        }
        try {
            List<TmUserVo> tmUserVoList = this.tmUserService.findTmUserList(tmUserVo, page);
            json.setObj(tmUserVoList);
            attributes.put("totle", tmUserVoList.size());
        }
        catch (Exception e) {
            attributes.put("totle", 0);
            e.printStackTrace();
            throw new BusinessException("\u83b7\u53d6\u7528\u6237\u5931\u8d25" + e.getMessage());
        }
        json.setAttributes(attributes);
        return json;
    }

    @RequestMapping(value={"goTmUserSearch"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goTmUserSearch(TmUserVo tmUserVo, String singleSelect, String searchUrl) {
        ModelAndView view = new ModelAndView("com/biz/eisp/mdm/tmUser/tmUserSearchMain");
        view.addObject("extendTableName", (Object)Globals.TABLE_USER);
        view.addObject("vo", (Object)tmUserVo);
        if (StringUtil.isEmpty(searchUrl)) {
            searchUrl = "tmUserController.do?findTmUserBySearchList";
        }
        view.addObject("searchUrl", (Object)searchUrl);
        view.addObject("singleSelect", (Object)singleSelect);
        return view;
    }

    @RequestMapping(value={"saveTmUser"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveTmUser(TmUserVo tmUserVo, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        EuPage page = new EuPage(request);
        try {
            tmUserVo.setUserType(Globals.ENTERPRISE_USER);
            String id = this.tmUserService.saveTmUser(tmUserVo, page);
            if (null != this.tmUserBackExtendService) {
                this.tmUserBackExtendService.afterSaveTmUser(id);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u64cd\u4f5c\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(value={"deleteTmUser"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson deleteTmUser(String ids, HttpServletRequest request, HttpServletResponse response) {
        AjaxJson ajaxJson = new AjaxJson();
        try {
            Map<String, Object> attributes;
            Object userNameList;
            ajaxJson = this.tmUserService.deleteTmUser(ids, this.page);
            if (null != this.tmUserBackExtendService && null != (userNameList = (attributes = ajaxJson.getAttributes()).get("userNameList"))) {
                this.tmUserBackExtendService.afterDeleteTmUser((List)userNameList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ajaxJson.setMsg("\u5220\u9664\u5931\u8d25");
        }
        return ajaxJson;
    }

    @RequestMapping(value={"valideTmUser"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public ValidForm valideTmUser(TmUserVo tmUserVo, HttpServletRequest request) {
        ValidForm validForm = new ValidForm();
        String param = OConvertUtils.getString(request.getParameter("param"));
        try {
            validForm = this.tmUserService.valideTmUser(tmUserVo, param);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u9a8c\u8bc1\u7528\u6237\u5f02\u5e38");
        }
        return validForm;
    }

    @RequestMapping(value={"startOrStopTmuser"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson startOrStopTmuser(TmUserVo tmUserVo) {
        AjaxJson json = new AjaxJson();
        try {
            json = this.tmUserService.startOrStopTmuser(tmUserVo);
            if (null != this.tmUserBackExtendService) {
                this.tmUserBackExtendService.afterStartOrStopTmuser(tmUserVo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return json;
    }

    @RequestMapping(value={"goChangeTmUserPassword"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goChangeTmUserPassword(HttpServletRequest request) {
        String passwordDataType = this.sysConfigUtils.getPasswordDataType();
        String passwordErrorMsg = this.sysConfigUtils.getPasswordErrorMsg();
        if (StringUtil.isBlank((String)passwordDataType)) {
            passwordDataType = "/^[a-zA-Z0-9_\\x21-\\x7e]{6,20}$/";
        }
        if (StringUtil.isBlank((String)passwordErrorMsg)) {
            passwordErrorMsg = "\u53ea\u80fd\u586b\u5199\u957f\u5ea6\u4e3a6~20\uff0c\u5b57\u7b26\u7c7b\u578b\uff08\u82f1\u6587\u3001\u6570\u5b57\u3001\u6807\u70b9\u7b26\u53f7\u3001\u7279\u6b8a\u5b57\u7b26\uff09";
        }
        request.setAttribute("passwordDataType", (Object)passwordDataType);
        request.setAttribute("passwordErrorMsg", (Object)passwordErrorMsg);
        return new ModelAndView("com/biz/eisp/mdm/tmUser/changeTmPassword");
    }

    @RequestMapping(value={"goFirstChangeTmUserPassword"}, method={RequestMethod.GET, RequestMethod.POST})
    public ModelAndView goFirstChangeTmUserPassword(TmUserVo tmUserVo) {
        String passwordDataType = this.sysConfigUtils.getPasswordDataType();
        String passwordErrorMsg = this.sysConfigUtils.getPasswordErrorMsg();
        if (StringUtil.isBlank((String)passwordDataType)) {
            passwordDataType = "/^[a-zA-Z0-9_\\x21-\\x7e]{6,20}$/";
        }
        if (StringUtil.isBlank((String)passwordErrorMsg)) {
            passwordErrorMsg = "\u53ea\u80fd\u586b\u5199\u957f\u5ea6\u4e3a6~20\uff0c\u5b57\u7b26\u7c7b\u578b\uff08\u82f1\u6587\u3001\u6570\u5b57\u3001\u6807\u70b9\u7b26\u53f7\u3001\u7279\u6b8a\u5b57\u7b26\uff09";
        }
        ModelAndView view = new ModelAndView("login/loginFirstChangeTmPassword");
        view.addObject("tmUserVo", (Object)tmUserVo);
        view.addObject("passwordDataType", (Object)passwordDataType);
        view.addObject("passwordErrorMsg", (Object)passwordErrorMsg);
        return view;
    }

    @RequestMapping(value={"changeTmPassword"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson changeTmPassword(HttpServletRequest request, TmUserVo tmUserVo) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.tmUserService.changeTmuserPassword(tmUserVo);
            if (null != this.tmUserBackExtendService) {
                this.tmUserBackExtendService.afterChangeTmPassword(tmUserVo);
            }
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(value={"changeFirstTmPassword"}, method={RequestMethod.GET, RequestMethod.POST})
    @ResponseBody
    public AjaxJson changeFirstTmPassword(HttpServletRequest request, TmUserVo tmUserVo) {
        AjaxJson j = new AjaxJson();
        try {
            j = this.tmUserService.changeFirstTmPassword(tmUserVo);
            if (null != this.tmUserBackExtendService) {
                this.tmUserBackExtendService.afterChangeFirstTmPassword(tmUserVo);
            }
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u4fee\u6539\u5bc6\u7801\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(value={"exportXls"}, method={RequestMethod.GET, RequestMethod.POST})
    public void exportXls(TmUserVo tmUserVo, HttpServletRequest request, HttpServletResponse response) {
        tmUserVo.setUserType(Globals.ENTERPRISE_USER);
        List<TmUserVo> tmUserVoList = this.tmUserService.findTmUserList(tmUserVo, null);
        this.doExportXls(response, request, tmUserVoList, TmUserVo.class, "\u4f01\u4e1a\u7528\u6237\u5217\u8868");
    }
}

