--抄送数据表
DROP TABLE TA_COPY;
CREATE TABLE TA_COPY (
  ID VARCHAR2(32 BYTE) VISIBLE NOT NULL ,
  BUSINESS_KEY VARCHAR2(32 BYTE) VISIBLE ,
  PROCESS_INSTANCE_ID VARCHAR2(32 BYTE) VISIBLE ,
  PROCESS_NAME VARCHAR2(50 BYTE) VISIBLE ,
  PROCESS_KEY VARCHAR2(32 BYTE) VISIBLE ,
  PROCESS_TITLE VARCHAR2(500 BYTE) VISIBLE ,
  COPY_CODE VARCHAR2(32 BYTE) VISIBLE ,
  COPY_NAME VARCHAR2(32 BYTE) VISIBLE ,
  VIEW_STATUS VARCHAR2(5 BYTE) VISIBLE ,
  CREATE_DATE TIMESTAMP(6) VISIBLE ,
  CREATE_NAME VARCHAR2(50 BYTE) VISIBLE ,
  UPDATE_DATE TIMESTAMP(6) VISIBLE ,
  UPDATE_NAME VARCHAR2(50 BYTE) VISIBLE ,
  CREATE_PROCESS_POSITION_NAME VARCHAR2(32 BYTE) VISIBLE ,
  CREATE_PROCESS_POSITION_CODE VARCHAR2(32 BYTE) VISIBLE
);
COMMENT ON COLUMN TA_COPY.ID IS '逻辑主键';
COMMENT ON COLUMN TA_COPY.BUSINESS_KEY IS '业务id';
COMMENT ON COLUMN TA_COPY.PROCESS_INSTANCE_ID IS '实例id';
COMMENT ON COLUMN TA_COPY.PROCESS_NAME IS '流程名称';
COMMENT ON COLUMN TA_COPY.PROCESS_KEY IS '流程Key';
COMMENT ON COLUMN TA_COPY.PROCESS_TITLE IS '单据名称';
COMMENT ON COLUMN TA_COPY.COPY_CODE IS '抄送人职位编码';
COMMENT ON COLUMN TA_COPY.COPY_NAME IS '抄送人职位名称';
COMMENT ON COLUMN TA_COPY.VIEW_STATUS IS '查阅状态';
COMMENT ON COLUMN TA_COPY.CREATE_PROCESS_POSITION_NAME IS '流程创建人职位名称';
COMMENT ON COLUMN TA_COPY.CREATE_PROCESS_POSITION_CODE IS '流程创建人职位编码';
ALTER TABLE TA_COPY ADD CONSTRAINT SYS_C007213 CHECK (ID IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

--抄送配置表
DROP TABLE TA_CARBONCOPY;
CREATE TABLE TA_CARBONCOPY (
  ID VARCHAR2(32 BYTE) VISIBLE NOT NULL ,
  TA_PROCESS_ID VARCHAR2(32 BYTE) VISIBLE ,
  TA_PROCESS_KEY VARCHAR2(32 BYTE) VISIBLE ,
  STATE VARCHAR2(32 BYTE) VISIBLE ,
  CHOOSE_CONDITION VARCHAR2(32 BYTE) VISIBLE ,
  CODE VARCHAR2(32 BYTE) VISIBLE ,
  NAME VARCHAR2(32 BYTE) VISIBLE ,
  CREATE_DATE TIMESTAMP(6) VISIBLE ,
  CREATE_NAME VARCHAR2(50 BYTE) VISIBLE ,
  UPDATE_DATE TIMESTAMP(6) VISIBLE ,
  UPDATE_NAME VARCHAR2(50 BYTE) VISIBLE
);
COMMENT ON COLUMN TA_CARBONCOPY.ID IS '逻辑主键';
COMMENT ON COLUMN TA_CARBONCOPY.TA_PROCESS_ID IS '流程id';
COMMENT ON COLUMN TA_CARBONCOPY.TA_PROCESS_KEY IS '流程key';
COMMENT ON COLUMN TA_CARBONCOPY.STATE IS '按职位/角色抄送标识';
COMMENT ON COLUMN TA_CARBONCOPY.CHOOSE_CONDITION IS '当前组织/当前组织及以下';
COMMENT ON COLUMN TA_CARBONCOPY.CODE IS '抄送编码';
COMMENT ON COLUMN TA_CARBONCOPY.NAME IS '抄送名称';
ALTER TABLE TA_CARBONCOPY ADD CONSTRAINT SYS_C007210 CHECK (ID IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;

--传阅主表
DROP TABLE TA_CIRCULATION;
CREATE TABLE TA_CIRCULATION (
  ID VARCHAR2(32 BYTE) VISIBLE NOT NULL ,
  BUSINESS_KEY VARCHAR2(32 BYTE) VISIBLE ,
  PROCESS_INSTANCE_ID VARCHAR2(32 BYTE) VISIBLE ,
  PROCESS_NAME VARCHAR2(128 BYTE) VISIBLE ,
  PROCESS_KEY VARCHAR2(32 BYTE) VISIBLE ,
  PROCESS_TITLE VARCHAR2(100 BYTE) VISIBLE ,
  LAUNCH_CODE VARCHAR2(50 BYTE) VISIBLE ,
  LAUNCH_NAME VARCHAR2(50 BYTE) VISIBLE ,
  CREATE_DATE TIMESTAMP(6) VISIBLE ,
  CREATE_NAME VARCHAR2(50 BYTE) VISIBLE ,
  UPDATE_DATE TIMESTAMP(6) VISIBLE ,
  UPDATE_NAME VARCHAR2(50 BYTE) VISIBLE ,
  CREATE_PROCESS_POSITION_NAME VARCHAR2(50 BYTE) VISIBLE ,
  CREATE_PROCESS_POSITION_CODE VARCHAR2(50 BYTE) VISIBLE
);
COMMENT ON COLUMN TA_CIRCULATION.ID IS '逻辑主键';
COMMENT ON COLUMN TA_CIRCULATION.BUSINESS_KEY IS '业务主键';
COMMENT ON COLUMN TA_CIRCULATION.PROCESS_INSTANCE_ID IS '实例主键';
COMMENT ON COLUMN TA_CIRCULATION.PROCESS_NAME IS '流程名称';
COMMENT ON COLUMN TA_CIRCULATION.PROCESS_KEY IS '流程key';
COMMENT ON COLUMN TA_CIRCULATION.PROCESS_TITLE IS '单据名称';
COMMENT ON COLUMN TA_CIRCULATION.LAUNCH_CODE IS '传阅发起人职位编码';
COMMENT ON COLUMN TA_CIRCULATION.LAUNCH_NAME IS '传阅发起人职位名称';
COMMENT ON COLUMN TA_CIRCULATION.CREATE_PROCESS_POSITION_NAME IS '流程创建人职位名称';
COMMENT ON COLUMN TA_CIRCULATION.CREATE_PROCESS_POSITION_CODE IS '流程创建人职位编码';
ALTER TABLE TA_CIRCULATION ADD CONSTRAINT SYS_C007211 CHECK (ID IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
--传阅子表
DROP TABLE TA_CIRCULATION_CONTENT;
CREATE TABLE TA_CIRCULATION_CONTENT (
  ID VARCHAR2(32 BYTE) VISIBLE NOT NULL ,
  TA_CIRCULATION_ID VARCHAR2(32 BYTE) VISIBLE ,
  CIRCULATION_CODE VARCHAR2(32 BYTE) VISIBLE ,
  CIRCULATION_NAME VARCHAR2(50 BYTE) VISIBLE ,
  CONTENT VARCHAR2(500 BYTE) VISIBLE ,
  RECIVE_CONTENT VARCHAR2(500 BYTE) VISIBLE ,
  VIEW_STATUS VARCHAR2(5 BYTE) VISIBLE ,
  READ_STATUS VARCHAR2(5 BYTE) VISIBLE ,
  IS_REPLY VARCHAR2(5 BYTE) VISIBLE ,
  CREATE_DATE TIMESTAMP(6) VISIBLE ,
  CREATE_NAME VARCHAR2(50 BYTE) VISIBLE ,
  UPDATE_DATE TIMESTAMP(6) VISIBLE ,
  UPDATE_NAME VARCHAR2(50 BYTE) VISIBLE 
);
COMMENT ON COLUMN TA_CIRCULATION_CONTENT.ID IS '逻辑主键';
COMMENT ON COLUMN TA_CIRCULATION_CONTENT.TA_CIRCULATION_ID IS '传阅主表';
COMMENT ON COLUMN TA_CIRCULATION_CONTENT.CIRCULATION_CODE IS '传阅接收编码';
COMMENT ON COLUMN TA_CIRCULATION_CONTENT.CIRCULATION_NAME IS '传阅接收名称';
COMMENT ON COLUMN TA_CIRCULATION_CONTENT.CONTENT IS '内容';
COMMENT ON COLUMN TA_CIRCULATION_CONTENT.RECIVE_CONTENT IS '返回内容';
COMMENT ON COLUMN TA_CIRCULATION_CONTENT.VIEW_STATUS IS '查阅状态';
COMMENT ON COLUMN TA_CIRCULATION_CONTENT.READ_STATUS IS '阅读状态';
COMMENT ON COLUMN TA_CIRCULATION_CONTENT.IS_REPLY IS '是否可以回复';
ALTER TABLE TA_CIRCULATION_CONTENT ADD CONSTRAINT SYS_C007212 CHECK (ID IS NOT NULL) NOT DEFERRABLE INITIALLY IMMEDIATE NORELY VALIDATE;
