/**  
 * 文件名：RestModelService.java   
 * 版本信息：  
 * 日期：2015年8月25日  
 * Copyright 博智 Corporation 2015   
 * 版权所有  BIZ
 * @项目名称：eisp-base-core  
 * @类名称：RestModelService  
 * @类描述：  
 * @创建人：xuduan  
 * @创建时间：2015年8月25日 下午1:38:36  
 * @类说明：
 */
package cn.com.biz.common.webservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.eisp.api.AbstractConfWebSerivce;
import com.biz.eisp.api.AbstractWebService;
import com.biz.eisp.mdm.dict.util.DictUtil;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

@Component("webMiddleService")
public class WebMiddleService {

    private static final Logger logger = LoggerFactory.getLogger(WebMiddleService.class);

    @Resource
	Map<String, AbstractWebService> map=new HashMap<String, AbstractWebService>();
    @Resource
	Map<String, AbstractConfWebSerivce> map_=new HashMap<String, AbstractConfWebSerivce>();
	/**
	 * @创建人：xuduan
	 * @创建时间：2015年8月25日 下午5:24:28
	 * @方法说明：
	 * @param sapData
	 * @return
	 */
	public String restMiddle(String sapData) {
		sapData = sapData.replaceAll(" ", "");
		JSONObject jsonObject = JSONObject.parseObject(sapData);
		if(map_!=null){
			AbstractConfWebSerivce conf=map_.get("confWebSerivce");
			if (conf!=null) {
				JSONObject tmp=conf.getConf(jsonObject);
				return tmp!=null?tmp.toJSONString():"处理失败!";
			}
		}
		JSONObject head=new JSONObject();
		String CONTENT=jsonObject.get("CONTENT")!=null?jsonObject.getString("CONTENT"):"";
		String mth="";
		if (StringUtils.isNotBlank(CONTENT)) {//
			String tmp=CONTENT.split("\\:")[0];//对应接口函数
		    mth=DictUtil.getDictDatasByCodes("SAP_RFN", tmp);
            logger.debug("方法:"+mth+"接收数据为=====>："+sapData);
        }
		if (StringUtils.isNotBlank(mth)) {
			AbstractWebService webs=map.get(mth);
			if (webs!=null) {
				JSONObject result=webs.analysisWebService(jsonObject);
				return result.toJSONString();
			}
		}else{
			JSONArray arr=new JSONArray();
			head.put("MTYPE", "E");
			head.put("MSGTXT", "DMS未配置接口权限");
			arr.add(head);
			jsonObject.put("DATA", arr);
		}
		return head.toJSONString();
	}
}
