package com.biz.eisp.activiti.demo.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.biz.eisp.base.common.util.ResourceConfigUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.activiti.demo.entity.LeaveEntity;
import com.biz.eisp.activiti.demo.service.LeaveService;
import com.biz.eisp.activiti.demo.vo.TaLeaveQueryVo;
import com.biz.eisp.activiti.demo.vo.TaLeaveVo;
import com.biz.eisp.activiti.designer.businessconf.service.TaProcessBusinessObjConfigService;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;

/** 
 * 请假管理demo Controller
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/leaveController")
public class LeaveController extends BaseController{

	@Autowired
	private LeaveService leaveService;
	
	@Autowired
	private TaProcessBusinessObjConfigService taProcessBusinessObjConfigService;
	
	/**
	 * 跳转请假列表页面
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "goLeaveMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goLeaveMain(HttpServletRequest request) {
		return new ModelAndView("com/biz/eisp/activiti/demo/leaveMain");
	}
	
	/**
	 * 跳转请假信息历史版本页面
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "goLeaveHisMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goLeaveMain(String id,HttpServletRequest request) {
		request.setAttribute("id", id);
		return new ModelAndView("com/biz/eisp/activiti/demo/leaveHisMain");
	}
	
	/**
	 * 跳转请假表单页面
	 * @param request
	 * @return
	 */
	@RequestMapping(value = "goLeaveForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goLeaveForm(String id ,HttpServletRequest request) {
		if(StringUtils.isNotBlank(id)) {
			LeaveEntity entity = leaveService.get(LeaveEntity.class, id);
			TaLeaveQueryVo vo = new TaLeaveQueryVo();
			vo.setId(entity.getId());
			vo.setContent(entity.getContent());
			vo.setProcessTitle(entity.getProcessTitle());
			vo.setProcessKey(entity.getTaProcessBusinessObjConfigEntity().
					getTaProcessEntity().getProcessKey());
			vo.setProcessName(entity.getTaProcessBusinessObjConfigEntity().
					getTaProcessEntity().getProcessName());
			request.setAttribute("vo", vo);
		}
		return new ModelAndView("com/biz/eisp/activiti/demo/leaveForm");
	}
	@RequestMapping(params = "goLeaveForm1")
	public ModelAndView goLeaveForm1(HttpServletRequest request) {
		String businessObjId = request.getParameter("businessObjId");
		LeaveEntity entity = leaveService.get(LeaveEntity.class, businessObjId);
		request.setAttribute("vo", entity);
		return new ModelAndView("com/biz/eisp/activiti/demo/leaveForm2");
	}
	
	/**
	 * 查询请假信息列表 
	 * @param taLeaveQueryVo
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "findLeaveList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findLeaveList(TaLeaveQueryVo taLeaveQueryVo, HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		taLeaveQueryVo.setPositionCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
		List <TaLeaveQueryVo> list = leaveService.findLeaveList(taLeaveQueryVo, page);
		return new DataGrid(list, page);
	}
	
	/**
	 * 查询请假信息列表 
	 * @param taLeaveQueryVo
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "findLeaveHisList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findLeaveHisList(TaLeaveQueryVo taLeaveQueryVo, HttpServletRequest request, HttpServletResponse response) {
		Page page = new EuPage(request);
		taLeaveQueryVo.setPositionCode(ResourceConfigUtils.getCurrPosition().getPositionCode());
		if(StringUtil.isNotEmpty(taLeaveQueryVo.getId())){
			LeaveEntity entity = leaveService.get(LeaveEntity.class, taLeaveQueryVo.getId());
			taLeaveQueryVo.setId(entity.getRefrenceId());
		}
		List <TaLeaveQueryVo> list = leaveService.findLeaveHisList(taLeaveQueryVo, page);
		return new DataGrid(list, page);
	}
	
	/**
	 *保存请假信息
	 * @param taLeaveVo
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "saveLeave", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveLeave(TaLeaveVo taLeaveVo,HttpServletRequest request, HttpServletResponse response) {
		AjaxJson ajaxJson= new AjaxJson();
		Page page = new EuPage(request);
		try {
			leaveService.saveTaLeave(taLeaveVo, page);
		} catch (Exception e) {
			ajaxJson.setSuccess(false);
			ajaxJson.setMsg("保存失败");
			e.printStackTrace();
		}
		return ajaxJson;
	}
	
	/**
	 * 删除请假信息
	 * @param id
	 * @param request
	 * @param response
	 * @return
	 */
	@RequestMapping(value = "deleteLeave", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson deleteLeave(String id, HttpServletRequest request, HttpServletResponse response) {
		LeaveEntity leaveEntity = taProcessBusinessObjConfigService.get(LeaveEntity.class, id);
		String runtimeStatusCode = leaveEntity.getTaRuntimeStatusEntity() == null 
				? "" : leaveEntity.getTaRuntimeStatusEntity().getCode();
		if(StringUtils.isNotBlank(runtimeStatusCode) && !"new".equals(runtimeStatusCode)) {
			return new AjaxJson("已进入流程，不能删除");
		}
		taProcessBusinessObjConfigService.delete(leaveEntity);
		return new AjaxJson();
	}
}
