package com.biz.eisp.activiti.demo.dao;

import java.util.List;

import com.biz.eisp.activiti.demo.vo.TaLeaveQueryVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.interfacedao.annotation.Arguments;
import com.biz.eisp.base.interfacedao.annotation.InterfaceDao;
import com.biz.eisp.base.interfacedao.annotation.ResultType;

/**
 * 请假管理demo 接口dao
 * @author 肖胜
 * @version v1.0
 */
@InterfaceDao
public interface TaLeaveDao {
	
	/**
	 * 查询请假信息列表 
	 * @param vo
	 * @param page
	 * @return
	 */
	@ResultType(TaLeaveQueryVo.class)
	@Arguments({"vo","page"})
	public List<TaLeaveQueryVo> findLeaveQuery(TaLeaveQueryVo vo, Page page);
	
	/**
	 * 请假历史审批信息 
	 * @param vo
	 * @param page
	 * @return
	 */
	@ResultType(TaLeaveQueryVo.class)
	@Arguments({"vo","page"})
	public List<TaLeaveQueryVo> findLeaveHisList(TaLeaveQueryVo vo, Page page);
}
