package com.biz.eisp.activiti.demo.service;

import java.util.List;

import com.biz.eisp.activiti.demo.vo.TaLeaveQueryVo;
import com.biz.eisp.activiti.demo.vo.TaLeaveVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;

/** 
 * 请假管理demo Service接口
 * @author liukai
 * @version v1.0
 */
public interface LeaveService extends BaseService{

	/**
	 * 查询请假列表 
	 * @param taLeaveQueryVo
	 * @param page
	 * @return
	 */
	public List <TaLeaveQueryVo> findLeaveList(TaLeaveQueryVo taLeaveQueryVo, Page page);
	
	/**
	 * 保存请假信息
	 * @param taLeaveQueryVo
	 * @param page
	 */
	public void saveTaLeave(TaLeaveVo taLeaveVo, Page page);
	
	/**
	 * 请假历史审批信息 
	 * @param vo
	 * @param page
	 * @return
	 */
	public List<TaLeaveQueryVo> findLeaveHisList(TaLeaveQueryVo vo, Page page);
}
