package com.biz.eisp.activiti.demo.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.biz.eisp.base.common.util.ResourceConfigUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.demo.entity.DemoEntity;
import com.biz.eisp.activiti.demo.entity.DemoObjEntity;
import com.biz.eisp.activiti.demo.service.DemoService;
import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessBusinessObjConfigEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaProcessBusinessObjConfigService;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessBusinessObjConfigVo;
import com.biz.eisp.activiti.runtime.entity.TaRuntimeStatusEntity;
import com.biz.eisp.activiti.runtime.service.TaKeyIndicators;
import com.biz.eisp.activiti.runtime.service.TaProcessInstanceService;
import com.biz.eisp.activiti.runtime.vo.TaProcessThemeVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;

@Service("demoService")
@Transactional
public class DemoServiceImpl extends BaseServiceImpl implements DemoService,TaKeyIndicators{
	@Autowired
	private TaProcessBusinessObjConfigService taProcessBusinessObjConfigService;
	@Autowired
	private TaProcessInstanceService taProcessInstanceService;
	
	@Override
	public List<DemoEntity> findDemoList(Page page) {
		String hql = " from DemoEntity where createName = ?";
		return this.findByHql(hql, page, ResourceConfigUtils.getCreateName());
	}

	@Override
	public void submit(TaProcessThemeVo vo) {
		//流程key {建议做成配置}
		String processKey = "process1511940919545";
		
		TmPositionEntity positionEntity = this.get(TmPositionEntity.class, ResourceConfigUtils.getCurrPosition().getId());
		DemoObjEntity obj = new DemoObjEntity();
		//busconfig
		TaProcessBusinessObjConfigEntity busConfig = taProcessBusinessObjConfigService
				.getTaProcessBusinessObjConfigEntity(obj.getClass(), processKey);
		
		//获取流程状态
		TaRuntimeStatusEntity runTimeStatusEnttiy = this.findUniqueByProperty(
				TaRuntimeStatusEntity.class, "code", WorkFlowGlobals.RUNTIME_STATUS_NEW);
		
		//首先要创建tabasebusinessobj 对象 ，业务提交需要自行继承这个entity
		
		obj.setCreatetime(new Date());
		obj.setTmPositionEntity(positionEntity);
		obj.setTaRuntimeStatusEntity(runTimeStatusEnttiy);
		obj.setTaProcessBusinessObjConfigEntity(busConfig);
		obj.setCreatetime(new Date());
		obj.setProcessTitle(vo.getName());
		obj.setProcessDetail(vo.getDetail());
		obj.setPositionCode(positionEntity.getPositionCode());
		obj.setPositionName(positionEntity.getPositionName());
		obj.setUserName(ResourceConfigUtils.getSessionUserName().getUserName());
		obj.setFullName(ResourceConfigUtils.getSessionUserName().getFullName());
		this.save(obj);

		//更新附件外键
		String foreignKey = vo.getBusinessKeyMain();
		String sql = " update tb_attachment set business_key = ? where business_key = ?";
		this.updateBySql(sql, obj.getId(),foreignKey);
		
		//更新业务数据
		String[] key = vo.getBusinessKey().split(","); //这里前台传过来以什么隔开，就写什么{自己定义}
		for(String k : key){
			DemoEntity de = this.get(DemoEntity.class, k);
			de.setStatus(1);
			this.saveOrUpdate(de);
		}
		
		
		//发起工作流
		TaProcessBusinessObjConfigVo configVo = new TaProcessBusinessObjConfigVo();
		configVo.setId(busConfig.getId());
		Map<String,Object> var = new HashMap<String,Object>();
		List<String> list = new ArrayList<String>();
		list.add("zw0001");
		list.add("zw00024");
		var.put("persons", list);//注意会签参数名 必须是 persons
		configVo.setVariables(var);//传入流程参数
		taProcessInstanceService.saveStartWorkflow(configVo, obj);
	}

	
	//关键指标获取数据方法 需要实现TaKeyIndicators 接口
	//另外关键指标需要在ta_key_indicators_conf表中配置
	@Override
	public List<Map<String, Object>> findKeyIndicators(String bussinessKey) {
		String sql = "select name,content from ta_demo "; 
		
		return this.findForMapList(sql, new Object[]{});
	}
	
}
