package com.biz.eisp.activiti.demo.service.impl;

import java.util.Date;
import java.util.List;

import com.biz.eisp.base.common.util.ResourceConfigUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.activiti.common.WorkFlowGlobals;
import com.biz.eisp.activiti.demo.dao.TaLeaveDao;
import com.biz.eisp.activiti.demo.entity.LeaveEntity;
import com.biz.eisp.activiti.demo.service.LeaveService;
import com.biz.eisp.activiti.demo.vo.TaLeaveQueryVo;
import com.biz.eisp.activiti.demo.vo.TaLeaveVo;
import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessBusinessObjConfigEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaProcessBusinessObjConfigService;
import com.biz.eisp.activiti.runtime.entity.TaRuntimeStatusEntity;
import com.biz.eisp.base.common.constant.Globals;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;

/** 
 * 请假管理demo Service接口实现
 * @author liukai
 * @version v1.0
 */
@Service("leaveService")
@Transactional
public class LeaveServiceImpl extends BaseServiceImpl implements LeaveService{
	
	@Autowired
	private TaLeaveDao taLeaveDao;
	@Autowired
	private TaProcessBusinessObjConfigService taProcessBusinessObjConfigService;
	
	@Override
	public List<TaLeaveQueryVo> findLeaveList(TaLeaveQueryVo taLeaveQueryVo, Page page) {
		return taLeaveDao.findLeaveQuery(taLeaveQueryVo, page);
	}

	@Override
	public void saveTaLeave(TaLeaveVo taLeaveVo, Page page) {
		//流程key
		String processKey=taLeaveVo.getProcessKey();
		//主键id
		String id=taLeaveVo.getId();
		//单据名称
		String processTitle = taLeaveVo.getProcessTitle();
		//请假内容
		String content = taLeaveVo.getContent();
		TmPositionEntity positionEntity = this.get(TmPositionEntity.class, ResourceConfigUtils.getCurrPosition().getId());
		//huiqian_ceshi ->流程ID
		TaProcessBusinessObjConfigEntity busConfig = taProcessBusinessObjConfigService
				.getTaProcessBusinessObjConfigEntity(LeaveEntity.class, processKey);
		
		//获取流程状态
		TaRuntimeStatusEntity runTimeStatusEnttiy = this.findUniqueByProperty(
				TaRuntimeStatusEntity.class, "code", WorkFlowGlobals.RUNTIME_STATUS_NEW);
		
		LeaveEntity leave =  new LeaveEntity();
		if(StringUtils.isNotBlank(id)) {
			leave = this.get(LeaveEntity.class, id);
			//判断流程状态是否是驳回
			String status=leave.getTaRuntimeStatusEntity().getCode();
			if(StringUtil.equals(status, WorkFlowGlobals.RUNTIME_STATUS_REJECT)){
				//修改状态 数据备份
				leave.setEnableStatus(Globals.ONE);
				this.updateEntity(leave);
				//创建新对象
				leave=new LeaveEntity();
				//引入id
				leave.setRefrenceId(id);
			}
		}
		leave.setTaProcessBusinessObjConfigEntity(busConfig);
		leave.setTmPositionEntity(positionEntity);
		leave.setTaRuntimeStatusEntity(runTimeStatusEnttiy);
		leave.setCreatetime(new Date());
		leave.setProcessTitle(processTitle);
		leave.setPositionCode(positionEntity.getPositionCode());
		leave.setPositionName(positionEntity.getPositionName());
		leave.setUserName(ResourceConfigUtils.getSessionUserName().getUserName());
		leave.setFullName(ResourceConfigUtils.getSessionUserName().getFullName());
		leave.setContent(content);
		leave.setEnableStatus(Globals.ZERO);
		this.saveOrUpdate(leave);
	}

	@Override
	public List<TaLeaveQueryVo> findLeaveHisList(TaLeaveQueryVo vo, Page page) {
		return taLeaveDao.findLeaveHisList(vo, page);
	}

}
