package com.biz.eisp.activiti.designer.businessconf.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.activiti.designer.businessconf.entity.TaBusinessObjEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaBusinessObjService;
import com.biz.eisp.activiti.designer.businessconf.transformer.TaBusinessObjEntityToVo;
import com.biz.eisp.activiti.designer.businessconf.transformer.TaBusinessObjVoToEntity;
import com.biz.eisp.activiti.designer.businessconf.vo.TaBusinessObjVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;

/**
 * 业务实体对象信息实体Controller.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/taBusinessObjController")
public class TaBusinessObjController extends BaseController{
	
	@Autowired
	private TaBusinessObjService taBusinessObjService;
	
	/**
	 * 到业务实体主页面
	 * @author wan
	 * @return
	 */
	@RequestMapping(value = "goTaBusinessObjMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaBusinessObjMain(){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/businessconf/taBusinessObjMain");
		return view;
	}
	
	/**
	 * 到新增或者编辑页面
	 * @author wan
	 * @param busId
	 * @return
	 */
	@RequestMapping(value = "goTaBusinessObjForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goTaBusinessObjForm(String busId){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/businessconf/taBusinessObjForm");
		if(StringUtils.isNotBlank(busId)){
			TaBusinessObjEntity entity = taBusinessObjService.get(TaBusinessObjEntity.class, busId);
			TaBusinessObjVo vo = new TaBusinessObjEntityToVo().apply(entity);
			view.addObject("busVo", vo);
		}
		return view;
	}
	/**
	 * 查询全部的业务实体
	 * @author wan
	 * @return
	 */
	@RequestMapping(value = "findTaBusinessObjList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTaBusinessObjList(HttpServletRequest request){
		Page page = new EuPage(request);
		List<TaBusinessObjVo> busVo = taBusinessObjService.findAllBusinessObj(page);
		return new DataGrid(busVo, page);
	}
	/**
	 * 新增或者修改
	 * @author wan
	 * @param vo
	 * @return
	 */
	@RequestMapping(value = "saveOrUpdateTaBusinessObj", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveOrUpdateTaBusinessObj(TaBusinessObjVo vo){
		AjaxJson aj = new AjaxJson();
		TaBusinessObjEntity entity = new TaBusinessObjVoToEntity().apply(vo);
		if(vo.getId().equals("")){
			taBusinessObjService.save(entity);
			aj.setMsg("新增成功");
		}else{
			taBusinessObjService.updateEntity(entity);
			aj.setMsg("更新成功");
		}
		return aj;
	}
	/**
	 * 删除业务实体
	 * @author wan
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "delTaBusinessObjById", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson delTaBusinessObjById(String busId){
		AjaxJson aj = new AjaxJson();
		if(StringUtils.isNotBlank(busId)){
			TaBusinessObjEntity entity = taBusinessObjService.get(TaBusinessObjEntity.class, busId);
			taBusinessObjService.delete(entity);
			aj.setMsg("删除成功");
		}
		return aj;
	}
}
