package com.biz.eisp.activiti.designer.businessconf.controller;

import java.util.List;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.activiti.designer.businessconf.entity.TaBusinessObjEntity;
import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessBusinessObjConfigEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaBusinessObjService;
import com.biz.eisp.activiti.designer.businessconf.service.TaProcessBusinessObjConfigService;
import com.biz.eisp.activiti.designer.businessconf.transformer.TaProcessBusinessObjConfigEntityToVo;
import com.biz.eisp.activiti.designer.businessconf.transformer.TaProcessBusinessObjConfigVoToEntity;
import com.biz.eisp.activiti.designer.businessconf.vo.TaBusinessObjVo;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessBusinessObjConfigVo;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.common.jsonmodel.ValidForm;
import com.biz.eisp.base.common.util.OConvertUtils;
import com.biz.eisp.base.common.util.StringUtil;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;

/**
 * 工作流程与业务关联信息管理Controller.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/taProcessBusinessObjConfigController")
public class TaProcessBusinessObjConfigController extends BaseController{
	/*
	 * 本控制器方法目录：
	 * 1.跳转关联主页面
	 * 2.跳转新增编辑主页面
	 * 3.根据ProcessKey查找全部关联
	 * 4.新增+保存
	 * 5.删除
	 * 6.找寻实际业务对象
	 */
	@Autowired
	private TaProcessBusinessObjConfigService configService;
	@Autowired
	private TaBusinessObjService businessService;
	/**
	 * 跳转主页面
	 * @author wan
	 * @param pdKey process的key
	 * @return
	 */
	@RequestMapping(value = "goConfigMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goConfigMain(String taProcessId){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/businessconf/taProcessBusinessObjConfigMain");
		view.addObject("taProcessId", taProcessId);
		return view;
	}
	/**
	 * 从主页面跳转到新增或者编辑页面
	 * @author wan
	 * @param id 该关联的id
	 * @return	modelAndView
	 */
	@RequestMapping(value = "goConfigForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goConfigForm(String id,String taProcessId){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/businessconf/taProcessBusinessObjConfigForm");
		if(StringUtils.isNotBlank(id)){
			TaProcessBusinessObjConfigEntity entity = configService.get(TaProcessBusinessObjConfigEntity.class, id);
			TaProcessBusinessObjConfigVo vo = new TaProcessBusinessObjConfigEntityToVo().apply(entity);
			view.addObject("configVo", vo);
		}
		List<TaBusinessObjVo> taBusinessObjVo = this.findAllBusinessObj();
		view.addObject("taProcessId", taProcessId);
		view.addObject("taBusinessObjVos", taBusinessObjVo);
		return view;
	}
	/**
	 * 根据ProcessKey找全部的关联关系
	 * @author wan
	 * @param id process的id
	 * @return
	 */
	@RequestMapping(value = "findConfigList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findConfigList(String taProcessId,HttpServletRequest request){
		Page page = new EuPage(request);
		List<TaProcessBusinessObjConfigVo> list = configService.findConfigByProcessId(taProcessId,page);
		return new DataGrid(list, page);
	}
	/**
	 * 新增或者更新
	 * @author wan
	 * @param vo 关联vo
	 * @return ajax
	 */
	@RequestMapping(value = "saveOrUpdateConfig", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveOrUpdateConfig(TaProcessBusinessObjConfigVo vo){
		AjaxJson aj = new AjaxJson();
		String message = null;
		TaProcessBusinessObjConfigEntity entity = new TaProcessBusinessObjConfigVoToEntity().apply(vo);
		
		TaBusinessObjEntity objEntity = businessService.get(TaBusinessObjEntity.class, vo.getBusinessObjId());//查询出业务实体
		TaProcessEntity pEntity = configService.get(TaProcessEntity.class, vo.getProcessId());//查询出流程实体
		entity.setTaBusinessObjEntity(objEntity);
		entity.setTaProcessEntity(pEntity);
		
		if(vo.getId().equals("")){//新增
			configService.save(entity);
			message = "新增:" + vo.getBusinessName() +"成功";
		}else{//更新
			configService.updateEntity(entity);
			message = "更新:" + vo.getBusinessName() + "成功";
		}
		aj.setSuccess(true);
		aj.setMsg(message);
		return aj;
	}
	/**
	 * 方法的简述.
	 * <p>方法的详细说明第一行<br>
	 * 方法的详细说明第二行
	 * @author wan
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "delConfigById", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson delConfigById(String id){
		AjaxJson aj = new AjaxJson();
		if(StringUtils.isNotBlank(id)){
			TaProcessBusinessObjConfigEntity entity = configService.get(TaProcessBusinessObjConfigEntity.class, id);
			configService.delete(entity);
			aj.setMsg("删除成功");
			aj.setSuccess(true);
		}
		return aj;
	}
	/**
	 * 找寻全部的业务实体
	 * @author wan
	 * @return
	 */
	public List<TaBusinessObjVo> findAllBusinessObj(){
		return businessService.findAllBusinessObj();
	}
	/**
	 * 验证重复业务名称Name.
	 * @author wuzhujun
	 * @param 
	 * @param 验证对象
	 */
	@RequestMapping(value = "validateBusinessName", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public ValidForm validateBusinessName(TaProcessBusinessObjConfigVo vo,HttpServletRequest request) {
		String param = OConvertUtils.getString(request.getParameter("param"));
		ValidForm validForm = new ValidForm();
		//验证
		if(StringUtil.isNotEmpty(vo.getId())){
			//修改
			Criterion cr1 = Restrictions.eq("businessName",param);
			Criterion cr2 = Restrictions.ne("id", vo.getId());
			List<TaProcessBusinessObjConfigEntity> taconfigs= configService.findByCriteria(TaProcessBusinessObjConfigEntity.class, cr1, cr2);
			if(!CollectionUtils.isEmpty(taconfigs)){
				validForm.setStatus("n");
				validForm.setInfo("业务名称已存在");
			}
		}else{
			//新增
			Criterion cr3 = Restrictions.eq("businessName", param);
			List<TaProcessBusinessObjConfigEntity> taconfigs = configService.findByCriteria(TaProcessBusinessObjConfigEntity.class, cr3);
			if(!CollectionUtils.isEmpty(taconfigs)){
				validForm.setStatus("n");
				validForm.setInfo("业务名称已存在");
			}
		}
		return validForm;
	}
}
