package com.biz.eisp.activiti.designer.businessconf.controller;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessVariableEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaProcessVariableService;
import com.biz.eisp.activiti.designer.businessconf.transformer.TaProcessVariableEntityToTaProcessVariableVo;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessVariableVo;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.vo.TaProcessNodeVo;
import com.biz.eisp.base.common.jsonmodel.AjaxJson;
import com.biz.eisp.base.common.jsonmodel.DataGrid;
import com.biz.eisp.base.core.page.EuPage;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.web.BaseController;

/**
 * 流程变量对象信息实体管理Controller.
 * <p>
 * 
 * @author liukai
 * @version v1.0
 */
@Controller
@RequestMapping("/taProcessVariableController")
public class TaProcessVariableController extends BaseController{
	
	@Autowired
	private TaProcessNodeService taProcessNodeService;
	@Autowired
	private TaProcessVariableService taProcessVariableService;
	/**
	 * 到流程配置主页面
	 * @author wan
	 * @param processId 流程的key
	 * @return
	 */
	@RequestMapping(value = "goVariableMain", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goVariableMain(String taProcessId){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/businessconf/taProcessVariableMain");
		view.addObject("taProcessId",taProcessId);
		return view;
	}
	/**
	 * 查询所有的相关的variable
	 * @author wan
	 * @param pdKey 流程key
	 * @return
	 */
	@RequestMapping(value = "findVariableList", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public DataGrid findTaProcessVariableList(String processId,HttpServletRequest request) {
		Page page = new EuPage(request);
		List<TaProcessVariableVo> list = taProcessVariableService.getVariableByProcessId(processId, page);
		return new DataGrid(list, page);
	}
	/**
	 * 到更新或者编辑页面
	 * @author wan
	 * @param id : 变量id
	 * @return
	 */
	@RequestMapping(value = "goVariableForm", method = {RequestMethod.GET, RequestMethod.POST})
	public ModelAndView goVariableForm(String id,String taProcessId){
		ModelAndView view = new ModelAndView("com/biz/eisp/activiti/designer/businessconf/taProcessVariableForm");
		if(StringUtils.isNotBlank(id)){
			TaProcessVariableEntity entity = taProcessVariableService.get(TaProcessVariableEntity.class, id);
			TaProcessVariableVo vo = new TaProcessVariableEntityToTaProcessVariableVo().apply(entity);
			view.addObject("pvVo", vo);
		}
		List<TaProcessNodeVo> nodes = this.findNodeListByProcessId(taProcessId);
		
		view.addObject("processId",taProcessId);
		view.addObject("nodes", nodes);
		return view;
	}
	/**
	 * 更新或者保存
	 * @author wan
	 * @param pvVo  流程变量vo
	 * @return aj ajax返回给前台
	 */
	@RequestMapping(value = "saveOrUpdateVariable", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson saveOrUpdateVariable(TaProcessVariableVo pvVo){
		AjaxJson aj = new AjaxJson();
		try {
			taProcessVariableService.saveVariable(pvVo);
			aj.setMsg("保存成功");
			aj.setSuccess(true);
		} catch (Exception e) {
			aj.setMsg("保存失败");
			aj.setSuccess(false);
			throw new RuntimeException("保存变量出现错误，请重试");
		}
		return aj;
	}
	/**
	 * 删除变量根据id
	 * @author wan
	 * @param id
	 * @return
	 */
	@RequestMapping(value = "delVariableById", method = {RequestMethod.GET, RequestMethod.POST})
	@ResponseBody
	public AjaxJson delVariableById(String id){
		AjaxJson aj = new AjaxJson();
		if(!id.equals("")){
			TaProcessVariableEntity entity = taProcessVariableService.get(TaProcessVariableEntity.class, id);
			taProcessVariableService.delete(entity);
			aj.setMsg("删除成功");
		}else{
			aj.setMsg("删除失败");
		}
		return aj;
	}
	/**
	 * 根据流程找寻所有的节点,这个是在新增或者编辑页面，下拉框选择的
	 * @author wan
	 * @param processKey 流程Key
	 * @return
	 */
	public List<TaProcessNodeVo> findNodeListByProcessId(String processId){
		List<TaProcessNodeVo> nodes = taProcessNodeService.getNodeByProcessId(processId);
		return nodes;
	}
}
