package com.biz.eisp.activiti.designer.businessconf.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.base.common.identity.IdEntity;

/**
 * Activiti流程实体与业务实体配置.
 * <p>
 * 主要目的是把Activiti绘制的工作流与实际的业务结合起来
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "ta_process_busiobj_config")
public class TaProcessBusinessObjConfigEntity extends IdEntity implements java.io.Serializable {
	// 业务名称
	private String businessName;

	// 实际业务对象
	private TaBusinessObjEntity taBusinessObjEntity = new TaBusinessObjEntity();// 业务表

	// Activiti流程实体对象
	private TaProcessEntity taProcessEntity = new TaProcessEntity();

	@Column(name = "business_name", length = 30)
	public String getBusinessName() {
		return businessName;
	}

	public void setBusinessName(String businessName) {
		this.businessName = businessName;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "business_obj_id")
	public TaBusinessObjEntity getTaBusinessObjEntity() {
		return taBusinessObjEntity;
	}

	public void setTaBusinessObjEntity(TaBusinessObjEntity taBusinessObjEntity) {
		this.taBusinessObjEntity = taBusinessObjEntity;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "process_id")
	public TaProcessEntity getTaProcessEntity() {
		return taProcessEntity;
	}

	public void setTaProcessEntity(TaProcessEntity taProcessEntity) {
		this.taProcessEntity = taProcessEntity;
	}

}
