package com.biz.eisp.activiti.designer.businessconf.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.base.common.identity.IdEntity;

/**
 * 流程变量配置.
 * <p>
 * 流程变量配置，要配置到每个流程节点上
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "ta_process_variable")
public class TaProcessVariableEntity extends IdEntity implements java.io.Serializable {
	private static final long serialVersionUID = 4463536829474634047L;
	// 所属流程
	private TaProcessEntity taProcessEntity = new TaProcessEntity();
	// 所属节点
	private TaProcessNodeEntity taProcessNodeEntity = new TaProcessNodeEntity();
	// 标量标示
	private String processVariableKey;
	// 变量名称
	private String processVariableName;
	// 变量类型
	private String processVariableType;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "process_id")
	public TaProcessEntity getTaProcessEntity() {
		return taProcessEntity;
	}

	public void setTaProcessEntity(TaProcessEntity taProcessEntity) {
		this.taProcessEntity = taProcessEntity;
	}

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "process_node_id")
	public TaProcessNodeEntity getTaProcessNodeEntity() {
		return taProcessNodeEntity;
	}

	public void setTaProcessNodeEntity(TaProcessNodeEntity taProcessNodeEntity) {
		this.taProcessNodeEntity = taProcessNodeEntity;
	}

	@Column(name = "process_variable_key", length = 20)
	public String getProcessVariableKey() {
		return processVariableKey;
	}

	public void setProcessVariableKey(String processVariableKey) {
		this.processVariableKey = processVariableKey;
	}

	@Column(name = "process_varibale_name", length = 50)
	public String getProcessVariableName() {
		return processVariableName;
	}

	public void setProcessVariableName(String processVariableName) {
		this.processVariableName = processVariableName;
	}

	@Column(name = "process_variable_type", length = 50)
	public String getProcessVariableType() {
		return processVariableType;
	}

	public void setProcessVariableType(String processVariableType) {
		this.processVariableType = processVariableType;
	}
}
