package com.biz.eisp.activiti.designer.businessconf.entity;

import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.base.common.identity.IdEntity;

import javax.persistence.*;

/**
 * 流程变量配置.
 * <p>
 * 流程变量配置，要配置到每个流程节点上
 * 
 * @author liukai
 * @version v1.0
 */
@Entity
@Table(name = "ta_process_variable_pro")
public class TaProcessVariableProEntity extends IdEntity implements java.io.Serializable {
	private static final long serialVersionUID = 4463536829474634047L;

	// 所属流程
	private String processId;
	/**流程版本*/
	private String procDefId;
	/**
	 * 流程节点ID，外键对应ta_process_node的id字段
	 */
	private String processNodeId;

	// 标量标示
	private String processVariableKey;
	// 变量名称
	private String processVariableName;
	// 变量类型
	private String processVariableType;

	@Column(name = "process_node_id")
	public String getProcessNodeId() {
		return processNodeId;
	}

	public void setProcessNodeId(String processNodeId) {
		this.processNodeId = processNodeId;
	}

	@Column(name = "process_variable_key", length = 20)
	public String getProcessVariableKey() {
		return processVariableKey;
	}

	public void setProcessVariableKey(String processVariableKey) {
		this.processVariableKey = processVariableKey;
	}

	@Column(name = "process_varibale_name", length = 50)
	public String getProcessVariableName() {
		return processVariableName;
	}

	public void setProcessVariableName(String processVariableName) {
		this.processVariableName = processVariableName;
	}

	@Column(name = "process_variable_type", length = 50)
	public String getProcessVariableType() {
		return processVariableType;
	}

	public void setProcessVariableType(String processVariableType) {
		this.processVariableType = processVariableType;
	}


	@Column(name = "process_Id", length = 50)
	public String getProcessId() {
		return processId;
	}
	@Column(name = "proc_Def_Id", length = 50)
	public String getProcDefId() {
		return procDefId;
	}

	public void setProcessId(String processId) {
		this.processId = processId;
	}

	public void setProcDefId(String procDefId) {
		this.procDefId = procDefId;
	}
}
