package com.biz.eisp.activiti.designer.businessconf.service;

import java.util.List;

import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessVariableVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.BaseService;

/** 流程变量对象信息实体管理Service 接口.
 * <p>
 * 主要管理流程变量的CURD操作（TaProcessVariableEntity）
 * @author liukai
 * @version v1.0
 */
public interface TaProcessVariableService extends BaseService{
	
	/**
	 * 查询流程的变量，通过流程主体的id
	 * @author wan
	 * @param processId 流程主体的id
	 * @param page	分页参数
	 * @return	List<TaProcessVariableVo>
	 */
	public List<TaProcessVariableVo> getVariableByProcessId(String processId,Page page);
	/**
	 * 保存流程变量
	 * <p>方法的详细说明第一行<br>
	 * 方法的详细说明第二行
	 * @author wan
	 * @param pvVo
	 */
	public void saveVariable(TaProcessVariableVo pvVo);
}
