package com.biz.eisp.activiti.designer.businessconf.service.impl;


import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.activiti.designer.businessconf.entity.TaBusinessObjEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaBusinessObjService;
import com.biz.eisp.activiti.designer.businessconf.transformer.TaBusinessObjEntityToVo;
import com.biz.eisp.activiti.designer.businessconf.vo.TaBusinessObjVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;

/**
 * 业务实体对象信息实体Service 接口实现.
 * <p>
 * 
 * 完成对业务实体对象（TaBusinessObjEntity）CURD操作实现
 * 
 * @author liukai
 * @version v1.0
 */
@Service("taBusinessObjService")
@Transactional
public class TaBusinessObjServiceImpl extends BaseServiceImpl implements TaBusinessObjService {

	@Override
	public List<TaBusinessObjVo> findAllBusinessObj(Page page) {
		String hql = "from TaBusinessObjEntity";
		List<TaBusinessObjEntity> list = findByHql(hql, page);
		List<TaBusinessObjVo> results = new ArrayList<>();
		for(TaBusinessObjEntity entity : list){
			TaBusinessObjVo vo = new TaBusinessObjEntityToVo().apply(entity);
			results.add(vo);
		}
		return results;
	}

	@Override
	public List<TaBusinessObjVo> findAllBusinessObj() {
		List<TaBusinessObjEntity> list = findByHql("from TaBusinessObjEntity");
		List<TaBusinessObjVo> results = new ArrayList<>();
		for(TaBusinessObjEntity entity : list){
			TaBusinessObjVo vo = new TaBusinessObjEntityToVo().apply(entity);
			results.add(vo);
		}
		return results;
	}

}
