package com.biz.eisp.activiti.designer.businessconf.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessBusinessObjConfigEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaProcessBusinessObjConfigService;
import com.biz.eisp.activiti.designer.businessconf.transformer.TaProcessBusinessObjConfigEntityToVo;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessBusinessObjConfigVo;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;

/**
 * 工作流程与业务关联信息管理 Service接口 实现
 * <p>
 * 主要管理工作流程与业务关系的CURD操作
 * 
 * @author liukai
 * @version v1.0
 */
@Service("taProcessBusinessObjService")
@Transactional
public class TaProcessBusinessObjServiceImpl extends BaseServiceImpl implements TaProcessBusinessObjConfigService {

	@Override
	public TaProcessBusinessObjConfigEntity getTaProcessBusinessObjConfigEntity(Class clazz, String processKey) {
		String hql = "from TaProcessBusinessObjConfigEntity where taBusinessObjEntity.entityName = ? and taProcessEntity.processKey = ?";
		List<TaProcessBusinessObjConfigEntity> list = this.findByHql(hql, clazz.getName(), processKey);
		if (list.size() > 0) {
			return list.get(0);
		}
		return null;
	}

	@Override
	public List<TaProcessBusinessObjConfigVo> findConfigByProcessId(String taProcessId,Page page) {
		String hql = "from TaProcessBusinessObjConfigEntity t where t.taProcessEntity.id = ?";
		List<TaProcessBusinessObjConfigEntity> entitys = findByHql(hql, page, taProcessId);
		List<TaProcessBusinessObjConfigVo> results = new ArrayList<>();
		for (TaProcessBusinessObjConfigEntity entity : entitys) {
			TaProcessBusinessObjConfigVo vo = new TaProcessBusinessObjConfigEntityToVo().apply(entity);
			results.add(vo);
		}
		return results;
	}

}
