package com.biz.eisp.activiti.designer.businessconf.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.biz.eisp.activiti.designer.businessconf.entity.TaProcessVariableEntity;
import com.biz.eisp.activiti.designer.businessconf.service.TaProcessVariableService;
import com.biz.eisp.activiti.designer.businessconf.transformer.TaProcessVariableEntityToTaProcessVariableVo;
import com.biz.eisp.activiti.designer.businessconf.transformer.TaProcessVariableVoToTaProcessVariableEntity;
import com.biz.eisp.activiti.designer.businessconf.vo.TaProcessVariableVo;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessService;
import com.biz.eisp.base.common.exception.BusinessException;
import com.biz.eisp.base.core.page.Page;
import com.biz.eisp.base.core.service.impl.BaseServiceImpl;

/** 流程变量对象信息实体管理Service 接口实现.
 * <p>
 * 主要管理流程变量的CURD操作（TaProcessVariableEntity）
 * @author liukai
 * @version v1.0
 */
@Service("taProcessVariableService")
@Transactional
public class TaProcessVariableServiceImpl extends BaseServiceImpl implements TaProcessVariableService{
	
	@Autowired
	private TaProcessService taProcessService;	
	@Autowired
	private TaProcessNodeService taProcessNodeService;
	
	
	@Override
	public List<TaProcessVariableVo> getVariableByProcessId(String processId,Page page) {
		String hql = "from TaProcessVariableEntity t where t.taProcessEntity.id = ?";
		List<TaProcessVariableEntity> list = findByHql(hql, page, processId);
		List<TaProcessVariableVo> result = new ArrayList<>();
		for(TaProcessVariableEntity entity : list){
			TaProcessVariableVo vo = new TaProcessVariableEntityToTaProcessVariableVo().apply(entity);
			result.add(vo);
		}
		return result;
	}

	@Override
	public void saveVariable(TaProcessVariableVo pvVo) {
		TaProcessVariableEntity entity = new TaProcessVariableVoToTaProcessVariableEntity().apply(pvVo);
		String nodeId = pvVo.getNodeId();//节点的id
		TaProcessNodeEntity nodeEntity = taProcessNodeService.get(TaProcessNodeEntity.class, nodeId);//查询出节点
		String processId = pvVo.getProcessId();//流程id
		TaProcessEntity pe = taProcessService.get(TaProcessEntity.class, processId);//查询出流程
		entity.setTaProcessEntity(pe);
		entity.setTaProcessNodeEntity(nodeEntity);
		try {
			if(pvVo.getId().equals("")){//vo的id为空,新增
				this.save(entity);
			}else{
				this.updateEntity(entity);
			}
		} catch (Exception e) {
			throw new BusinessException("数据库操作异常");
		}
	}
}
