package com.biz.eisp.activiti.designer.processcheck.batchck;

import com.biz.eisp.activiti.designer.processcheck.entity.TaProcessCheckDetail;
import com.biz.eisp.activiti.designer.processcheck.service.TaProcessCheckService;
import com.biz.eisp.activiti.designer.processcheck.util.ProcessCheckUtil;
import com.biz.eisp.activiti.designer.processcheck.vo.TaProcessCkRecordVo;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeEntity;
import com.biz.eisp.activiti.designer.processconf.entity.TaProcessNodeProEntity;
import com.biz.eisp.activiti.designer.processconf.service.TaProcessNodeService;
import com.biz.eisp.activiti.util.CommentUtil;
import com.biz.eisp.activiti.util.DateUtils;
import com.biz.eisp.activiti.util.EhcacheUtil;
import com.biz.eisp.base.common.util.CollectionUtil;
import com.biz.eisp.base.utils.ApplicationContextUtils;
import com.biz.eisp.mdm.position.entity.TmPositionEntity;
import com.biz.eisp.mdm.position.service.TmPositionService;
import com.biz.eisp.mdm.position.vo.TmPositionVo;
import com.biz.eisp.mdm.user.service.TmUserService;
import com.biz.eisp.mdm.user.vo.TmUserVo;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;

import java.util.*;
/**
 * 用户检测业务类
 * @ClassName: com.biz.eisp.activiti.runtime.batchck.BatchCheckBean 
 * @author LeoWen
 * @date 2017年9月14日 上午12:22:27
 */
public class BatchCheckBean {
	
	private String userName;

	private String batchId;

	private TaProcessCkRecordVo record;

	private String proInsId;

	private List<TaProcessCheckDetail> ckDetails;

	private Map<String, Integer> isCkKey = new HashMap<String, Integer>();

	private TaProcessCheckService taProcessCheckService;

	private TmUserService tmUserService;

	private TmPositionService tmPositionService;

	private IdentityService identityService;

	private RuntimeService runtimeService;

	private RepositoryService repositoryService;

	private TaskService taskService;

	private TaProcessNodeService taProcessNodeService;

	public BatchCheckBean(String userName, String batchId){
		this.userName = userName;
		this.batchId = batchId;
		record = (TaProcessCkRecordVo) EhcacheUtil.getItem("PRO_CK_" + batchId);
		setCkDetails();
		setServices();
	}

	/**
	 * 设置service
	 */
	public void setServices(){
		taProcessCheckService = (TaProcessCheckService) ApplicationContextUtils.getContext().getBean("taProcessCheckService");
		tmUserService = (TmUserService) ApplicationContextUtils.getContext().getBean("tmUserService");
		tmPositionService = (TmPositionService) ApplicationContextUtils.getContext().getBean("tmPositionService");
		identityService = (IdentityService) ApplicationContextUtils.getContext().getBean("identityService");
		runtimeService = (RuntimeService) ApplicationContextUtils.getContext().getBean("runtimeService");
		taskService = (TaskService) ApplicationContextUtils.getContext().getBean("taskService");
        taProcessNodeService = (TaProcessNodeService) ApplicationContextUtils.getContext().getBean("taProcessNodeService");
		repositoryService = (RepositoryService) ApplicationContextUtils.getContext().getBean("repositoryService");
	}

	/**
	 * 检测开始
	 *
	 * @throws Exception
	 */
	public void checkStart(){
		boolean isSucc = true;
		try {
			TaProcessCheckDetail detail = passStarPro();
			forCheck(detail);
		} catch (Exception e) {
			isSucc = false;
		} finally {
			saveStopedNode(isSucc);
		}
	}

	/**
	 * 保存中断的节点
	 *
	 * @param isSucc
	 */
	public void saveStopedNode(boolean isSucc){
		for(TaProcessCheckDetail detail : ckDetails){
			Integer ckResult = isCkKey.get(detail.getNodeKey());
			if(ckResult == null){
				detail.setCheckTime(DateUtils.getFormatDateStr(new Date(), DateUtils.DEFAULT_DATE_ALL_PATTERN));
				detail.setState("3");
				String remark = "<p><span style=\"color: blue;\">节点检测中断";
				if(isSucc){// 成功后的部分中断
		    		remark = remark + "，原因：未自动找到该节点任务，可能该节点为条件参数的分支节点，请重新设置分支参数再检测！";
		    	}else{
		    		remark = remark + "，原因：中途节点检测失败，被迫中断！";
		    	}
		    	remark = remark + "</span></p><p>-----------------------------------------</p>";
				detail.setCheckResult(remark);
				int done = (int)EhcacheUtil.getItem("PRO_CK_PG_STOP_" + batchId) + 1;
				EhcacheUtil.putItem("PRO_CK_PG_STOP_" + batchId, done);
				isCkKey.put(detail.getNodeKey(), 3);
			}else{
				if(ckResult == 1){
					int done = (int)EhcacheUtil.getItem("PRO_CK_PG_SUCC_" + batchId) + 1;
					EhcacheUtil.putItem("PRO_CK_PG_SUCC_" + batchId, done);
				}else{
					int done = (int)EhcacheUtil.getItem("PRO_CK_PG_FAIL_" + batchId) + 1;
					EhcacheUtil.putItem("PRO_CK_PG_FAIL_" + batchId, done);
				}
			}
		}
	}

	/**
	 * 循环执行通过检测
	 *
	 * @param detail
	 * @throws Exception
	 */
	public void forCheck(TaProcessCheckDetail detail) throws Exception{
		List<Task> nextTasks = taskService.createTaskQuery().processInstanceId(detail.getProcessInsId()).list();
		if(nextTasks.size() > 0){
			String nextNode = nextTasks.get(0).getTaskDefinitionKey();
			detail.setNextNode(nextNode);
			TaProcessCheckDetail newDetail = passProNode(nextNode);
			forCheck(newDetail);
		}
	}


	/**
	 * 通过检测
	 *
	 * @param nodeKey
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings("finally")
	private TaProcessCheckDetail passProNode(String nodeKey) throws Exception{
		TaProcessCheckDetail detail = getDetail(nodeKey);
		detail.setCheckTime(DateUtils.getFormatDateStr(new Date(), DateUtils.DEFAULT_DATE_ALL_PATTERN));
		StringBuffer ckDetail = new StringBuffer();
		String oldCkResult = "";
        if(StringUtils.isNotEmpty(detail.getCheckResult())){
        	oldCkResult = detail.getCheckResult();
        }
		try {
			TaProcessEntity process = taProcessCheckService.get(TaProcessEntity.class, record.getProcessId());
			if(process == null){
				throw new Exception("未找到流程实体");
			}
			List<Task> tasks = taskService.createTaskQuery().processInstanceId(proInsId)
					.taskDefinitionKey(detail.getNodeKey()).list();
			int taskSize = tasks.size();
			ckDetail.append("<p>检测出该节点产生了" + taskSize + "个任务</p>");
			int index = 1;
			for(Task task : tasks){
				ckDetail.append("<p>开始处理第" + index + "个任务...</p>");
				ckDetail = completeTask(task, ckDetail);
				ckDetail.append("<p>处理第" + index + "个任务结束...</p>");
				index ++;
			}
	        detail.setState("1");
	        detail.setProcessInsId(proInsId);
	        detail.setCheckResult(oldCkResult + ckDetail.toString() + "<p>节点通过检测成功!</p>");
		} catch (Exception e) {
			ckDetail.append("<p><span style=\"color:red\">节点通过检测失败!</span></p>");
			String msg = e.getMessage();
			if(StringUtils.isEmpty(msg)){
				msg = "未知错误，日志未被捕获。";
			}
			ckDetail.append("<p><span style=\"color:red\">错误日志：" + msg + "</span></p>");
			detail.setState("2");
			detail.setCheckResult(oldCkResult + ckDetail.toString());
		} finally {
			detail.setCheckResult(detail.getCheckResult() + "<p>-----------------------------------------</p>");
			isCkKey.put(detail.getNodeKey(), Integer.parseInt(detail.getState()));
			return detail;
		}
	}

	/**
	 * 完成任务
	 *
	 * @param task
	 * @throws Exception
	 */
	private StringBuffer completeTask(Task task, StringBuffer ckDetail) throws Exception{
		boolean toComplete = true;
//		String taskKey = task.getTaskDefinitionKey();
		String processKey = repositoryService.createProcessDefinitionQuery()
				.processDefinitionId(task.getProcessDefinitionId()).singleResult().getKey();
//		TaProcessNodeEntity node = taProcessNodeService.getTaProcessNodeEntity(taskKey, processKey);
		TaProcessNodeProEntity node = taProcessNodeService.getTaProcessNodeByVersionKey(task.getProcessDefinitionId(), processKey);
		if(node == null){
			throw new RuntimeException("节点表中未找到该节点！");
		}
		Map<String, Object> variables = runtimeService.getVariables(task.getExecutionId());
        String proStartPosiCode = (String) variables.get(ProcessCheckUtil.PROCEE_START_POSICODE);
		// 发起人职位
        TmPositionVo vo = this.getPositionVoInfo(proStartPosiCode);
        // 当前审批人对应职位
        TmPositionVo currVo = null;
        if(task.getTaskDefinitionKey().equals(CommentUtil.DEFAULT_TASK_NODE)){//初始节点
        	ckDetail.append("<p>任务处理人：[" + vo.getUserName() + "]" + vo.getFullName())
        	.append("、职位[" + vo.getPositionCode() + "]" + vo.getPositionName() + "</p>");
		}else{
			if(StringUtils.isEmpty(task.getAssignee())){
				List <IdentityLink> identityLinkList = taskService.getIdentityLinksForTask(task.getId());
				if(CollectionUtil.listNotEmptyNotSizeZero(identityLinkList)) { //多个职位竞争审批的情况
					for(IdentityLink identityLink : identityLinkList) {
						if(StringUtils.isNotBlank(identityLink.getUserId())) {
							currVo = this.getPositionVoInfo(identityLink.getUserId());
							if(currVo == null){
								throw new RuntimeException("根据任务执行职位[" + task.getAssignee() + "]查询职位数据为空！");
							}
							ckDetail.append("<p>任务处理人：[" + currVo.getUserName() + "]" + currVo.getFullName())
									.append("、职位[" + currVo.getPositionCode() + "]" + currVo.getPositionName() + "</p>");
						}
					}
				} else {
					throw new RuntimeException("节点任务的[assignee]审批人字段为空！");
				}
			} else { //一个职位审批的情况
				currVo = this.getPositionVoInfo(task.getAssignee());
				if(currVo == null){
					throw new RuntimeException("根据任务执行职位[" + task.getAssignee() + "]查询职位数据为空！");
				}
				ckDetail.append("<p>任务处理人：[" + currVo.getUserName() + "]" + currVo.getFullName())
						.append("、职位[" + currVo.getPositionCode() + "]" + currVo.getPositionName() + "</p>");
			}
		}
		if (toComplete) {
			try{
				taskService.complete(task.getId());
			} catch (Exception e) {
				throw e;
			}
        }
		return ckDetail;
	}

	/**
	 * 发起检测
	 *
	 * @return
	 * @throws Exception
	 */
	@SuppressWarnings("finally")
	public TaProcessCheckDetail passStarPro() throws Exception{
		TaProcessCheckDetail detail = getDetail("TO_START");
		String bussId = UUID.randomUUID().toString().replace("-", "");
		detail.setRecordId(batchId);
		detail.setCheckTime(DateUtils.getFormatDateStr(new Date(), DateUtils.DEFAULT_DATE_ALL_PATTERN));
		TaProcessEntity process = taProcessCheckService.get(TaProcessEntity.class, record.getProcessId());
		if(process == null) throw new Exception("未找到流程实体");
		String authenticatedUser = userName;
		StringBuffer ckDetail = new StringBuffer();
		try {
			Map<String, Object> variables = taProcessCheckService.getCkParams(record.getCkParams());
			variables.put(ProcessCheckUtil.PROCEE_START_USERNAME, authenticatedUser);
			variables.put("FROM_TYPE", "PROCESS_PASS_CHECK");
			// 设置流程发起人
			ckDetail.append("<p>发起人账号[" + authenticatedUser + "]去执行流程发起；</p>");
			// 设置发起人职位参数
			TmUserVo user = this.getUserVo(authenticatedUser);
			if(user == null){
				ckDetail.append("<p><span style=\"color:red\">根据发起人账号[" + authenticatedUser + "]未找到对应用户;</span></p>");
				throw new Exception("");
			}
	        TmPositionVo vo = this.getPositionVoById(user.getPositionId());
	        if(vo == null){
				ckDetail.append("<p><span style=\"color:red\">未找到发起人对应职位;</span></p>");
				throw new Exception("");
			}else{
				ckDetail.append("<p>发起人信息：[" + authenticatedUser + "]" + user.getFullName())
				.append("，职位[" + vo.getPositionCode() + "]" + vo.getPositionName() + "；</p>");
			}
	        variables.put(ProcessCheckUtil.PROCEE_START_POSICODE, vo.getPositionCode());
			identityService.setAuthenticatedUserId(authenticatedUser);
	        ProcessInstance processInstance = runtimeService.startProcessInstanceByKey(
	        		process.getProcessKey(), bussId, variables);
	        ckDetail.append("<p>成功发起了流程，发起检测成功!</p>");
	        detail.setState("1");
	        detail.setProcessInsId(processInstance.getProcessInstanceId());
	        proInsId = processInstance.getProcessInstanceId();
			detail.setCheckResult(ckDetail.toString());
		} catch (Exception e) {
			ckDetail.append("<p><span style=\"color:red\">发起流程失败!</span></p>");
			String msg = e.getMessage();
			if(StringUtils.isEmpty(msg)){
				msg = "未知错误，日志未被捕获。";
			}else if(msg.length() > 500){
				msg = msg.substring(0, 500) + "...";
			}
			ckDetail.append("<p><span style=\"color:red\">错误日志：" + msg + "</span></p>");
			detail.setState("2");
			detail.setCheckResult(ckDetail.toString());
		} finally {
			detail.setCheckResult(detail.getCheckResult() + "<p>-----------------------------------------</p>");
			isCkKey.put("TO_START", Integer.parseInt(detail.getState()));
			return detail;
		}
	}

	/**
	 * 获得
	 *
	 * @return
	 */
	public TaProcessCheckDetail getDetail(String nodeCode){
		for(TaProcessCheckDetail detail : ckDetails){
			if(nodeCode.equals(detail.getNodeKey())){
				return detail;
			}
		}
		return null;

	}
	public List<TaProcessCheckDetail> getCkDetails() {
		return ckDetails;
	}

	public void setCkDetails() {
		List<TaProcessCheckDetail> details = new ArrayList<TaProcessCheckDetail>();
		for(TaProcessCheckDetail detail : record.getCkPassDetails()){
			if(userName.equals(detail.getUserName())){
				details.add(detail);
			}
		}
		this.ckDetails = details;
	}

	/**
	 * 获取职位信息
	 * @param positionCode
	 * @return
	 */
	private TmPositionVo getPositionVoInfo(String positionCode) {
		if(StringUtils.isBlank(positionCode)) {
			throw new RuntimeException("未传递职位编码信息");
		}
		TmPositionVo paramVo = new TmPositionVo();
		paramVo.setPositionCode(positionCode);
		List <TmPositionVo> list = tmPositionService.findPositionByConditions(paramVo, null);
		if(CollectionUtil.listNotEmptyNotSizeZero(list)) {
			return list.get(0);
		}
		return null;
	}

	/**
	 * 通过id获取职位信息
	 * @param id
	 * @return
	 */
	private TmPositionVo getPositionVoById(String id) {
		TmPositionEntity positionEntity = tmPositionService.get(TmPositionEntity.class, id);
		if(positionEntity == null) {
			return null;
		}
		return this.getPositionVoInfo(positionEntity.getPositionCode());
	}

	private TmUserVo getUserVo(String userName) {
		TmUserVo paramVo = new TmUserVo();
		paramVo.setUserName(userName);
		TmUserVo userVo = tmUserService.getTmUser(paramVo);
		return userVo;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getBatchId() {
		return batchId;
	}

	public void setBatchId(String batchId) {
		this.batchId = batchId;
	}

}
