package com.biz.eisp.activiti.designer.processcheck.batchck;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;

/**
 * 批量检测处理类
 * @author LeoWen
 * @date 2017年9月13日 下午9:41:50
 */
public class BatchCheckProDeal {
	
	private static final Logger logger = LoggerFactory.getLogger(BatchCheckProDeal.class);
	
	/**
	 * 每次获得的用户数量
	 */
	public static final int  SINGLE = 20;
	
	/**
	 * 获得索引
	 */
	private int batchIndex = 0;
	
	/**
	 * 检测的用户IDS
	 */
	private List<String> users;
	
	/**
	 * 当前批量执行的唯一ID
	 */
	private String batchId;
	
	
	public BatchCheckProDeal(List<String> users, String batchId){
		this.users = users;
		this.batchId = batchId;
	}

	/**
	 * 分段获得用户数据
	 */
	public synchronized List<String> getUsers(){
		int startNum = batchIndex * SINGLE;//截取起始角标
		int endNum = startNum + SINGLE;//截取结束角标
		if(startNum >= users.size()){
			return null;
		}
		endNum = endNum > users.size() ? users.size() : endNum;
		batchIndex ++;
		return users.subList(startNum, endNum);
		
	}
	
	/**
	 * 构建多线程处理执行
	 */
	public void execute() throws Exception{
		
		if(users == null || users.isEmpty())
			return;
		
		int size = users.size() % SINGLE == 0 ? users.size() / SINGLE : (users.size() / SINGLE) + 1;
		
		///核数判断
		int prcNum = Runtime.getRuntime().availableProcessors();
		size = size > prcNum ? prcNum : size;
		logger.info("批量检测流程构建的线程数：" + size);
		for (int i = 0; i < size; i++){
			new BatchCheckProThread(this).start();
		}
	}
	
	/**
	 * 批量执行检测
	 * 
	 * @param users
	 * @throws Exception
	 */
	public void batchChecks(List<String> users){
		for(int i = 0; i < users.size(); i ++){
			String user = users.get(i);
			if(StringUtils.isNotBlank(user)){
				try {
					new BatchCheckBean(user, batchId).checkStart();
					logger.info("用户[" + user + "]完成检测!");
				} catch (Exception e) {
					e.printStackTrace();
					logger.error("用户[" + user + "]执行检测异常："+ e.getMessage());
				}
			}
		}
	}
	
	
}
